  
                   < Press  Home  PgDn  PgUp  Down Arrow  End >
      
 Y                                                                      F M <P>>G)GWǋ>>_>Fu >M t  װ
N ;GvIu
;>GrF=
uG;>GrF>r+  5>M t >Ftr׹N ;GvIu^
+S !
t<uA!<Pt<Ot4<Gu<Qu
>Ft"$<Iũ.P9>w6L! @!M K Q YL W     _úB MSTRUX.EXE

     is a program which expands "structured" assembly-language code into
"standard" text which may be processed using the Microsoft or IBM
assemblers.  

     The command line is

     C>STRUX ASMSOURC

which opens ASMSOURC.A (the "structured" sourcetext) and creates
ASMSOURC.ASM from it ("standard" sourcetext).  ASMSOURC.ASM may then be
assembled in the conventional manner.

============================================================================

Overview:

     Writing an assembly-language program is tedious enough without having
to keep conscious track of those "local" labels used in constructing the
equivalent of the IF/ELSEIF/ELSE and WHILE/UNTIL structures available in
modern high-level languages.  This is particularly true if you are working
with a large source module, or modifying an old module -- you will find
that your own chosen "style" works against you, because you tend to
automatically "generate" the same labels over and over again, and this can
lead to conflict with existing code (or worse, no conflict will appear, but
your program will jump Finagle knows where...).

     It is convenient to write assembly code as you write high level code,
using modern control structures.  By automatically generating "standard"
assembly source from a "structured" form, local labels are created without
conflict -- and without requiring the programmer to do the work.  In fact,
the programmer need never know that local labels have changed in later
maintenance work;  the automatic generation takes care of the details.

     One way to do this is to construct a set of macros which may be
INCLUDEd in all program sourcetexts.  The Microsoft and IBM 8086 macro
assemblers have enough flexibility to allow macros of this kind, but there
are some disadvantages.  First, expanding "structure" macros is moderately
slow under MASM 4.0, excruciatingly slow under earlier assemblers.  Second,
the macro definitions reduce the space available for other macros,
constants, and the assembly itself (again, 4.0 is not too bad, earlier
versions have real problems). 

     The other way is to pre-process the structured sourcetext with a
program designed for the purpose, creating a "standard" text which may be
assembled conventionally.  STRUX.EXE is such a preprocessor.  It is at
least as fast as the macro approach, and leaves both "structured" and
"standard" sourcetexts for inspection.  (Whether this is a convenience or a
nuisance depends on your attitude).

======================================================================

Here is a short sample of "structured" assembly code:

     MOV  SI,OFFSET USER_PROMPT    ;point to user prompt
     MOV  AL,[SI]                  ;display all printables
     .WHILE    <CMP AL,1Fh>,AE
          CALL OUTCHAR
          INC  SI                  ;next character
          MOV  AL,[SI]
     .WEND
     .IF       <CMP AL,ESC>,E      ;string ended with what?
          CALL ASK_USER            ;ESC ==> ask for user response
     .ELSEIF   <CMP AL,CR>,E       ;CR ==> wait ten seconds
          MOV  AL,10
          CALL PAUSE
     .ELSE                         ;NULL ==> done, return to calling routine
          RET
     .ENDIF
       ...


and what it generates:


     MOV  SI,OFFSET USER_PROMPT    ;point to user prompt
     MOV  AL,[SI]                  ;display all printables
;     .WHILE    <CMP AL,1Fh>,AE
_b1:
     CMP AL,1Fh
     jnae	_f1
          CALL OUTCHAR
          INC  SI                  ;next character
          MOV  AL,[SI]
;     .WEND
     jmp	_b1
_f1:
;     .IF       <CMP AL,ESC>,E      ;string ended with what?
     CMP AL,ESC
     jne	_f2
          CALL ASK_USER            ;ESC ==> ask for user response
;     .ELSEIF   <CMP AL,CR>,E       ;CR ==> wait ten seconds
     jmp	_e2
_f2:
     CMP AL,CR
     jne	_f3
          MOV  AL,10
          CALL PAUSE
;     .ELSE                         ;NULL ==> done, return to calling routine
     jmp	_e2
_f3:
          RET
;     .ENDIF
_f4:
_e2:


     As you can see, STRUX.EXE replaces the structured form with local
labels of the form "_Xnnn" (where 'X' is 'f' for "forward" jumps, 'b' for
"backward" jumps and 'e' for "endif", and "nnn" are digits), along with
appropriate jumps (usually the NEGATION of the condition called for in the
structured test) to implement the logic.

     The "conditions" specified are the standard tests available on the
8086 family:

     A  above                      G  signed greater
     AE above or equal             GE signed greater or equal
     B  below                      L  signed less
     BE below or equal             LE signed less or equal
     E  equal                      PO parity odd
     NE not equal                  PE parity even
     S  sign bit set               NS sign bit NOT set

and their negations (NA, NBE, etc.)  The JCXZ test usually applies to
special operations and is NOT supported in this set of conditions.

     The general form of a structured line is

     .KEY      <OPCODE TO,TEST>,CNDX

where  .KEY              is one of the specialized "structured opcodes"
       OPCODE  TO,TEST   is an optional "standard" opcode to be performed
                         before doing the test
and    CNDX              is one of the conditions in the table above

     ================================================================

     The structured opcodes all begin with a DOT to distinguish them from
standard opcodes.  They are:


"IF" CHAINS:

     .IF            opens an IF/ELSEIF/ELSE chain
     .ELSEIF        continues an IF chain with a new test
     .ELSE          default "otherwise" selection in an IF chain
     .ENDIF         closes an IF chain

     An .IF must be "closed" with an .ENDIF (which becomes the "target" of
the "jump not true" test).  Zero, one or many .ELSEIF's may follow a single
.IF -- the tests they perform are done in the order encountered in the
text.  An .ELSE may be used within an .IF chain.  .ELSE is the LAST block
of the .IF chain, and any subsequent .ELSEIF's will NOT be tested!  Examples:

     OR   AL,AL
     .IF  ,Z        ;if AL is nonzero
          ...
     .ENDIF

     .IF  <OR  AL,AL>,Z  ;generates code identical to above example
          ...
     .ENDIF

     .IF  <CMP AL,20>,A  ;if [AL] is (unsigned) above 20
          CALL ABOVE
     .ELSEIF   ,B        ;if [AL] is below 20.  Note flags are still set
          CALL BELOW     ; from first test
     .ELSE               ;default: [AL] == 20
          CALL EQUAL
     .ENDIF


LOOPS:

     .LOOP               opens a loop
     .WHILE              synonym for .LOOP
     .REPEAT             synonym for .LOOP

     .LEND               ends ("closes") a loop
     .WEND               synonym for .LEND
     .UNTIL              synonym for .LEND

     .BREAK              exits a loop
     .CNTNU              restarts a loop at top

     All of these loop keywords may be used with an optional opcode and
test, if desired.  Any number of .BREAK and .CNTNU may be used within a
single loop.

     Typically, .LOOP/.LEND will be used to create an "infinite loop" which
is "broken" by exitting the loop via .BREAK or via a RET or JMP to another
routine.  .WHILE and .UNTIL will typically have their tests included in the
structured opcode:

                    .LOOP
                         LODSB
                    .BREAK <OR AL,AL>,Z
                         CALL OUTCHAR
                    .LEND

      .WHILE    <CMP AL,'1'>,B          .REPEAT
           CALL GET_NEXT_CHAR                CALL PROMPT_USER
      .WEND                             .UNTIL <CMP AL,'y'>,E

     It is funny-looking, but perfectly legal, to use ANY of the "open
loop" keywords with any of the "close loop" keywords.  You may do a
.LOOP/.WEND, or a .WHILE/.UNTIL for example.  It is also perfectly
permissible to test both at the top and bottom of a loop -- and anywhere
within it:

          .WHILE    <OR  AL,AL>,NZ
               ...
          .BREAK    <CMP AL,ESC>,E
               ...
          .CNTNU    <CMP AL,CR>,AE
               ...
          .UNTIL    <OR  AL,AL>,Z

     ================================================================

     Loops and IF chains may be nested.  You must make sure that the
nesting is correct -- for example, if you place a .IF inside a loop, its
closing .ENDIF must be inside the same loop.  STRUX will complain if it
finds structures that "straddle" others.

     Finally, remember that these "structured opcodes" aren't really
opcodes at all, just commands to a preprocessor that generate true .ASM
opcodes.  This means that it is possible -- and sometimes useful -- to do
"non-structured" things that a high-level language would NOT permit, such
as jumping into the heart of a loop from outside it, or CALLing a spot
inside an IF chain.  The slight utility of such bizarre code, however, is
seldom worth the difficulty in explaining and maintaining it, so try to
stay "structured" if you can.  If you are in a situation where you really
DO need that last byte or clock cycle, chances are you know better anyway.

     ================================================================

Known bugs:

STRUX does not have the intelligence to know when a "short" jump
(JC TARGET) will be out of range and a "long" jump (JNC $+5/JMP TARGET)
is needed.  If MASM complains, you will have to make the substitutions
yourself.  You might typically perform a "long conditional jump" like 
this:

          .IF  ,C        ;long "jump if carry" to TARGET
               JMP  TARGET
          .ENDIF

MASM error message refer by line to the errors in the GENERATED .ASM
source, not to the original structured .A text.  This makes them a little
tedious to track down.  I am working on a solution to this.

     ================================================================

APPENDIX -- The IN prettyprinter

     IN.EXE is a "prettyprinter" for structured .A sourcetexts.  It indents
appropriately for loop and IF chains.  The sourcetext is formatted "in
place" -- that is, the formatted version replaces the original.

     One oddity is worth mentioning:  IN indents the .BREAK and .CNTNU
codes to the level of the .LOOP they are associated with, so you may see
easily just what is being exitted:

     .LOOP
          .IF  <or  al,al>,z
               call Alarm
     .BREAK
          .ENDIF
          ...
     .LEND


