{To increase number of records "F", either lower "No" or "M".
 The product of F, No and M must not be more than about 60,000.
 Setting "No" to 6 would allow over 400 records "F" in the file}


Program SimpleAddress;     {3-17-86, last change: 12-27-87}
Const   F=280;             {Max records ("A" in options=860 for 280 rec)}
       No=9;               {No of fields, F * No * M <= 60000}
        M=24;              {Max field length}
        T=7;               {Write offset}
       Ex='.SAD';          {Data file extension}
      SSt='                           ';
      Ent=#17#205#188;     {"Enter" symbol}
 Type   N=String[M];
  Charset=set of Char;
    Str75=String[75];
 Var    A:array[0..F,1..No] of N;  {file}
        Q:array[1..No] of Integer; {Field lengths}
       FN:String[16];              {File Name}
    Textf:Text[$200];              {Data file}
      Amt:String[M];
       Cr:String[1];
 D,X,B,I,L,J,K,SC:Integer; {X=Record on Screen, I=No of records}
 FP,Ins,Kp,Y,Z,ZZ:Boolean; {ZZ=PM on, Z=changes, Y=print Record}
     Ips,Ip,Ch:Char;       {If Ins=True, insert on during editing}

Procedure Cursor(On:Boolean);
Type
 Reglist=record
  AX,BX,CX,DX,BP,SI,DI,DS,ES,FLAGS:Integer
 end;
Var Reg:Reglist;
begin
  If On then
   if mem[0:$449]=7 then
   Reg.CX:=$0C0D
    else
   Reg.CX:=$0607
    else
   Reg.CX:=$2000;
   Reg.AX:=$0100;
   Intr($10,Reg)
 end;

Procedure Writef(S:Str75;Col,Row:Integer); {Write fast to video}
var
 P,VL,Offs:Integer;
begin
 If mem[0:$449]=7 then VL:=$B000 {MDA}
  else
 VL:=$B800; {CGA}
  Offs:=(Row-1)*80+Col-1;
   Offs:=Offs+Offs;
    For p:=1 to Ord(S[0]) do      {Ord(S[0])=String length}
     Mem[VL:Offs+P+P-2]:=Ord(S[P])
end;

Procedure Blank(O:Integer);
begin
 For J:=1 to O do
  begin
   GotoXY(1,26-J);
    ClrEol
  end
end;

Procedure POut(Go:Boolean);
begin
 If Go then ConOutPtr:=LstOutPtr else ConOutPtr:=SC
end;

Procedure Pok;
begin
 Blank(3);
 Writef
('- Ready printer, then press '+Ent+', or press ESC to Cancel -',T,25);
 Repeat
  Read(Kbd,Ch);
 Until Ch in[#13,#27];
  Blank(1)
end;

Function UpS(S:N):N;
var P:Integer;
begin
 For P:=1 to Ord(S[0]) do S[P]:=Upcase(S[P]);
  UpS:=S
end;

Function MakeS(C:Char;N:Integer):Str75;
var S:Str75;
begin
 If N<0 then N:=0;
  S[0]:=Chr(N);
   FillChar(S[1],N,C);
    MakeS:=S
end;

Procedure EnterS(var S:Str75;L,X,Y:Integer;Term:CharSet;var TC:Char);
const LCh=#250;
var P:Integer;
   Ch:Char;
begin
 Cursor(True);
 GotoXY(70,23);
 LowVideo;
 If Ins then Write('Insert   ')else Write('Overwrite');
 NormVideo;
 Writef('>'+S+MakeS(LCh,L-Ord(S[0]))+'<',X,Y+1);
 P:=0;
 Kp:=False;
 Repeat
  GotoXY(X+P+1,Y+1);
  Read(Kbd,Ch);
   If Ch=#4 then begin if P<Ord(S[0])then P:=P+1;Ch:=#0 end;
   If(Ch=#27)and keypressed then
   begin
    Read(Kbd,Ch);
    Kp:=True;
    case ch of
     #68:Ch:=#4;  {^D}
     #72:Ch:=#5;  {^E}
     #80:Ch:=#24; {^X}
     #71:P:=0;
     #75:If P>0        then P:=P-1;
     #77:If P<Ord(S[0])then P:=P+1;
     #79:P:=Ord(S[0]);
     #83:If P<Ord(S[0])then   {Delete Char}
         begin
          Delete(S,P+1,1);
          Write(Copy(S,P+1,L),LCh)
         end;
     #82:If not Ins then Ins:=True else Ins:=False;
    end
   end
    else
   begin
    case Ch of
     #32..#126,#128..#254:If P<L then
         begin
          If Ins and(Ord(S[0])=L)then Delete(S,L,1);
          P:=P+1;
          If not Ins then delete(S,P,1);
          Insert(Ch,S,P);
          Write(Copy(S,P,L));
         end;
      #1:P:=P-8;
      #6:P:=P+8;
      #7:If P<Ord(S[0])then  {Delete Char}
         begin
          Delete(S,P+1,1);
           Write(Copy(S,P+1,L),LCh)
         end;
     #19:If P>0 then P:=P-1;
     #25:begin
           Write(MakeS(LCh,Ord(S[0])-P));
           Delete(S,P+1,L)
          end;
      #8:If P>0 then
          begin
           Delete(S,P,1);
           Write(#8,Copy(S,P,L),LCh);
           P:=P-1
          end;
   end;
    If P>Ord(S[0])then P:=Ord(S[0])else if P<0 then P:=0
   end;
    If Ins then Writef('Insert   ',70,23)else Writef('Overwrite',70,23);
 Until ch in Term;
  P:=Ord(S[0]);
  GotoXY(X+P+1,Y+1);
  Write('':L-P);
  TC:=Ch
end;

Procedure EditR;                  {Edit or input record}
 const  Term:Charset=[#13,#4,#5,#24];
 Var    Str75:String[75];
          TC:Char;
       LL,BB:Integer;
 begin
  Writef(Sst,1,23);
  Writef('- Edit Mode -',7,23);
  Writef(Sst,1,25);
  LL:=1;
  Ins:=False;
  Writef('- Use Cursor Pad, Press F10 when finished -',T,25);
  Repeat
   Str75:=A[X,LL];
   If X=0 then BB:=11 else BB:=Q[LL];
   EnterS(Str75,BB,16,LL+10,Term,TC);
   A[X,LL]:=Str75;
   If(TC=#13)or(Tc=#24)then If LL=No then LL:=1
    else
   LL:=LL+1 else
   If TC=#5 then if LL=1 then LL:=No else LL:=LL-1;
   If (X<>0)and(A[0,6]='State')then A[X,6]:=UpS(A[X,6]);
  Until Kp and(TC=#4);
   Z:=True;
   GotoXY(70,23);
   ClrEol;
   Cursor(False)
 end;

Procedure EditFL;                 {Edit or input field length}
 const  Term:Charset=[#13,#4,#5,#24];
 Var   Str75:String[75];
          TC:Char;
       LL,PP:Integer;
begin
  For J:=1 to No do
 begin
  GotoXY(17,11+J);
   ClrEol;
    Write(Q[J])
 end;
  Ins:=False;
   LL:=1;
 Repeat
  Str(Q[LL],Str75);
  EnterS(Str75,2,16,LL+10,Term,TC);
  Val(Str75,Q[LL],B);
  If (TC=#24)or(TC=#13) then If LL=No then LL:=1
    else
  LL:=LL+1
    else
  If TC=#5 then if LL=1 then LL:=No
    else
  LL:=LL-1;
  PP:=0;
  For K:=1 to No do               {Input error check}
  If (Q[K]>M)or(Q[K]<0)then PP:=K;
  If PP<>0 then LL:=PP;
 Until Kp and(TC=#4)and(PP=0);
  Z:=True;
   GotoXY(70,23);
    ClrEol;
     Cursor(False)
end;

Procedure Sort;   {Simple Bubble Sort}
 Var AA:Array[1..No] of N;
    G,U:Integer;
begin
 blank(3);
  Str(No,Amt);
 Writef('- Sort Mode -',T,23);
 Writef('- Sort by which Field ? 1 to '+Amt,T,24);
  Repeat Read(Kbd,Ch);
  Until ch in['1'..cr];
   Val(ch,U,B);
   Writef('- Sorting by : '+A[0,U]+' -',T,25);
 For J:=1 to I-1 do
  For K:=J+1 to I do
   If A[K,U]<A[J,U] then
 begin
   For G:=1 to No do
  begin             {Swap}
   AA[G]:=A[J,G];
    A[J,G]:=A[K,G];
     A[K,G]:=AA[G]
  end
 end;
  X:=1;
  Y:=True;
  Z:=True
end;

Procedure PrintF;                 {Print Field names on screen}
begin
 Writef('   Record [',1,10);
  For J:=1 to No do
 begin
  Str(J:2,Amt);
   Writef(Sst,1,11+J);
    Writef(Amt,1,11+J);
     Writef(A[0,J],4,11+J);
      Writef(':',15,11+J);
 end
end;

Procedure PrintR;                 {Print Record & Record No. on screen}
begin
 Str(X:3,Amt);
  Writef(Amt,12,10);
   Writef(']',15,10);
    For J:=1 to No do
   begin
    Writef(Sst,16,11+J);
     Writef(A[X,J],17,11+J);
 end
end;

Procedure LabelP;  {Print record on label}
begin
 PrintR;
 POut(True);
 Writeln(A[X,1],' ',A[X,2]);
 Writeln(A[X,3]);
 If A[X,4]<>''then Writeln(A[X,4]);
 Writeln(A[X,5],', ',A[X,6],' ',A[X,7]);
 If A[X,4]='' then Writeln;
 writeln;
 writeln;        {Linefeed to next label}
 POut(False)
end;

Procedure PR;            {Printer}
 var BB,C,NR:Integer;
     Amt2,St:String[M];
Procedure List;
begin
 Blank(3);
 Writef('- Press T to list tagged records only else press '+Ent+' -',T,23);
  Repeat Read(Kbd,Ch);
   Ch:=UpCase(Ch);
  Until Ch in['T',#13];
   Writef('- Press '+Ent+' to start, ESC to cancel -',T,24);
    GoToXY(1,22);
  Repeat
   Read(Kbd,Ips);
  Until Ips in[#13,#27];
   If Ips=#13 then
 begin
   POut(True);
   For X:=1 to I do
  begin
    If ((Ch='T')and(pos('*',A[X,No])=1))or(Ch=#13)then
   begin
    PrintR;
    Write('   ');
     For J:=1 to 4 do
      begin
       write(A[X,J],' ');
      end;
       writeln;
   Write('    ');
    For J:=5 to No do
     begin
      write(A[X,J],' ');
     end;
    Writeln
   end
  end;
   POut(False)
 end
end;  {end list}

begin
 Blank(3);
 Writef('- Label Selecting & Printing -',T,23);
 Writef
 ('- Press 1 to '+Cr+' to search a field,  L to print a line listing -',T,24);
 Writef('- T to print tagged records only -',T,25);
 repeat
  read(Kbd,ch);
  Ch:=UpCase(Ch);
 until ch in['1'..Cr,'L','T'];
  If Ch='L'then List
   else
 begin
  If Ch='T' then begin B:=1;BB:=I end
   else
  if (Ch<>'T')and(Ch<>'L')then
 begin
  Val(Ch,D,B);
  Cursor(True);
Repeat
 Blank(2);
 GotoXY(T,24);
  Write('- Search for what in ',A[0,D],' ? : ');
  Read(St);
Until St<>'';
   Repeat
    blank(1);
    GotoXY(T,25);
    Write('- Start with which record no ? : ');
    read(Amt2);If Amt2='' then B:=1 else Val(Amt2,B,K);
   until (B<=I)and(B>0);
   Repeat
    blank(1);
    GotoXY(T,25);
    Write('- Stop with which record No ? ');Read(Amt2);
    If Amt2='' then BB:=I else Val(Amt2,BB,K);
   Until (BB<=I)and(BB>=B)
 end;
  Repeat
   Blank(2);
   GotoXY(T,24);
   Write('- How many copies of each record selected, 1-50 ? ');
   Read(Amt2);
   If Amt2='' then NR:=1 else Val(Amt2,NR,K);
  Until NR in[1..50];
   Cursor(False);
   Blank(1);
   Writef('- Press '+Ent+' to start,  ESC to Cancel -',T,25);
  Repeat
   Read(Kbd,Ips);
   If(Ips=#27)and keypressed then read(Kbd,Ips)
  until Ips in[#13,#27];
   If Ips=#13 then
 begin
  For X:=B to BB do
   begin
    For C:=1 to NR do
     begin
      If ((Ch='T')and(pos('*',A[X,No])=1))or
      ((Ch<>'T')and( pos(St,A[X,D])<>0))then LabelP
     end
   end
 end;
  POut(False);
  If X>I then X:=I else if X<1 then X:=1;
  Y:=True;
  Blank(1)
 end;
  If Ch='T'then
 begin
  Blank(2);
   Writef('- To erase all tags, Press "*", else press '+Ent+' -',T,25);
    Repeat Read(Kbd,Ips) Until Ips in[#13,#42];
     If Ips=#42 then
      begin
       For J:=1 to I do
       If pos('*',A[J,No])=1 then A[J,No]:=copy(A[J,No],2,M)
      end
 end
end;

Procedure Find;
 Var  U:Integer;
     Cc:Char;
   Amt1:String[M];
     FF:Boolean;
begin
 FF:=False;
 Blank(3);
 Writef('- Search Mode -',T,23);
 Writef('- Search which field ? 1 to '+Cr,T,24);
 repeat
  read(Kbd,cc)
 until cc in['1'..Cr];Val(Cc,D,B);
  X:=0;
  Cursor(True);
  Blank(1);
  GotoXY(T,25);
  Write('- Search for what in "',A[0,D],'" : ');
  Repeat
   Read(Amt1);
  Until Amt1<>'';
  Cursor(False);
  Ips:='C';
 While (Ips='C')or(Ips=#13) do
  begin
   Writef('Ctrl-E to Print Label',37,23);
    PrintR;
     If not FF then
  begin
   Repeat
    X:=Succ(X);
     U:=pos(Amt1,A[X,D]);
      If X=I then write(#7);
   Until (U<>0)or(X>=I)
  end;
    Ips:=' ';
     If(U<>0)and(X<I)then
   begin
    PrintR;
     Blank(2);
      Writef('- C)ontinue  E)dit  S)top -',T,25);
   repeat
    Read(Kbd,Ips);
    Ips:=UpCase(Ips);
   until Ips in[#5,#13,'C','E','S'];
    If Ips='E' then begin GotoXY(37,23);ClrEol;EditR;FF:=True end;
    If Ips='S' then end;
    If Ips=#5 then
     begin
      FF:=True;Pok;if Ch=#13 then LabelP else POut(False)
     end;
      If (Ips='C')or(Ips=#13)then FF:=False;
      If (Ips='E')or(Ips=#5 )then Ips:='C'
   end;
    Y:=True
end;

Procedure Zero;
begin
 For J:=0 to F do
  For K:=1 to No do
   A[J,K]:='';
   I:=0;
  For K:=1 to No do
   Q[K]:=M
end;

Procedure GetFn;
 Const Term:Charset=[#13];
 var  Str75:string[75];
         TC:Char;
begin
 Blank(2);
 Ins:=False;
 If pos('.',Fn)<>0 then
 Str75:=copy(Fn,1,pos('.',Fn)-1) else Str75:=Fn;
 Writef('- Name of file, no Ext :',T,25);
  repeat
   EnterS(Str75,16,31,24,Term,TC);
  until TC=#13;
   Amt:=Str75;
   If Amt<>'' then
  begin If pos('.',Amt)<>0 then
   Amt:=copy(Amt,1,pos('.',Amt)-1);
   If(pos('*',Amt)=0)and(Ord(Amt[0])<9)
   and(pos(' ',Amt)=0)and(pos('?',Amt)=0)then
   Fn:=Ups(Amt+ex)
     else
  Amt:=''
 end;
  GotoXY(70,23);
  ClrEol;
  Cursor(False)
end;

Procedure FileSave;
var cc:Char;
begin
 Amt:=copy(Fn,1,pos('.',Fn)-1);
 blank(3);
 Writef('- Save File Mode -',T,23);
 writef('- Press T to save tagged records only, else press '+Ent+' -',T,25);
  Repeat read(Kbd,Cc);
   Cc:=UpCase(Cc);
  Until Cc in['T',#13];
   if cc=#13 then
 begin
   Writef('- Press (Y) if file name '+Amt+' is OK, else press (N)'+' -',T,25);
  Repeat Read(Kbd,Ch);
   Ch:=UpCase(Ch);
  Until Ch in ['Y','N'];
   If Ch='N' then GetFn
 end else
  GetFn;
  If Amt<>'' then
 begin
  Assign(Textf,Fn);
  Rewrite(Textf);
 For J:=1 to No do
  begin Str(Q[J],Amt);
   If Ord(Amt[0])<2 then Amt:=concat('0'+Amt);
   A[0,J]:=concat(Amt+A[0,J])
  end;
 For J:=0 to I do
  If (J=0)or((Cc='T')and(pos('*',A[J,No])=1))or(Cc=#13) then
   For K:=1 to No do writeln(Textf,A[J,K]);
   For K:=1 to No do A[0,K]:=copy(A[0,K],3,11);
    Close(Textf);
    Y:=False
 end;
  Z:=False
end;

Procedure FileLoad;
begin
  X:=1;
  Blank(3);
  Writef('- File Load Mode,  Press '+Ent+' when finished -',T,23);
  GetFn;
 If Amt<>''then
  begin
   Assign(Textf,Fn);
   {$I-}
   Reset(Textf);
   {$I+}
   If IOresult<>0 then
   begin blank(2);
    Writef('- Cannot find '+FN+' -',T,24);
    Delay(1000);
    Fileload
  end
   else
 begin
  zero;
  I:=-1;
  blank(3);
  While (not Eof(Textf))and(I<F)do
   begin
    I:=I+1;
    For K:=1 to No do Readln(Textf,A[I,K])
   end;
    Close(Textf);
     For K:=1 to No do
   begin
    Val(copy(A[0,K],1,2),Q[K],B);
    A[0,K]:=copy(A[0,K],3,11)
   end;
    Y:=True;
    Z:=False
  end
 end
end;

Procedure FileHandle;
begin
 blank(3);
 If Z then writef('- Warning: changes have been made in the data file -',T,23);
 Writef('- F1 Save File  F2 Load File   Esc to cancel -',T,25);
  Repeat
   Read(Kbd,Ips);
   If (Ips=#27)and keypressed then read(Kbd,Ips);
  Until Ips in [#27,#59,#60];
   Case Ips of
    #27:Y:=False;
    #59:begin FileSave;If Amt='' then Y:=False end;
    #60:begin FileLoad;If Amt='' then Y:=False else Printf end;
   end
end;

Procedure SaveFile;
begin
 blank(3);
 If Z then
 begin
  Writef
  ('- Warning: file has been changed, save file? Y/N   Esc to cancel -',T,25);
  Repeat Read(Kbd,IpS);
   If(Ips=#27)and keypressed then read(Kbd,Ips);
  Until UpCase(IpS) in ['Y','N',#27];
   If UpCase(IpS)='Y'then Filesave else if IpS=#27 then ZZ:=False
 end
  else
 begin
  Writef('- Are you sure?   ESC to cancel -',T,25);
  Repeat
   Read(Kbd,IpS);
  Until IpS in[#13,#27,#32..#126]
 end
end;

Procedure Field;
begin
 Z:=True;
  X:=0;
   Y:=False;
    Blank(3);
 Writef('- Enter or change field names -',T,24);
  PrintR;
   EditR;
    PrintF;
 Writef('- Enter or Alter Field Lengths -',T,24);
  EditFL;
   X:=1;
    PrintR;
end;

Procedure AddRec;
 var Ip:Char;
      N:String[M];
begin
 blank(3);
 Writef('- Add Record Mode -',T,23);
 Writef('- To start, press '+Ent+';   ESC to Cancel -',T,25);
  Repeat
   Read(Kbd,Ip);
   If(Ip=#27)and keypressed then read(Kbd,Ip)
  until Ip in[#13,#27];
   Writef(Sst,1,25);
  If Ip=#13 then
 begin
  Ch:='Y';
   While(ch='Y')and(I<F) do
  begin
   I:=Succ(I);
   X:=I;
   PrintF;
   PrintR;
   For K:=1 to No do A[I,K]:='';
   EditR;
   Str(I:3,Amt);
   If pos('.',Fn)<>0 then
   N:=copy(Fn,1,pos('.',Fn)-1) else N:=Fn;
   writef(Amt+' Records in '+N+'               ',20,4);
   PrintR;
    If I<F then
   begin
    Writef(Sst+'                          ',1,25);
    Writef('- More? Y/N -',T,25);
   Repeat
    Read(Kbd,ch);
    Ch:=Upcase(ch);
   Until ch in['N','Y'];
    Y:=True;
    Z:=True
   end
  end
 end
   else
  begin
   Y:=False;
   If I=0 then ZZ:=False
 end
end;

Procedure Delete;
 var Ips:Char;
begin
 Blank(3);
 Writef('- Are you sure you wish to delete this record ? Y/N -',T,25);
 Repeat read(Kbd,Ips);
  Ips:=UpCase(Ips);
 Until Ips in['Y','N'];
  If Ips='Y'then
  begin
   blank(2);
   Str(X:3,Amt);
   writef('- Deleting Record # '+Amt+' -',T,24);
   Writef('- Not permanent until the file is saved -',T,25);
   For J:=X to I-1 do
    For K:=1 to No do
     A[J,K]:=A[J+1,K];
     I:=Pred(I);
     Z:=True;
     X:=Pred(X);
     If X<1 then X:=1;
     Delay((315+X-J)*5)
 end;
  PrintR
end;

Procedure Menu;
 var N:String[M];
Begin
 ZZ:=False;
 If(Ip<>#71)and(Ip<>#72)and(Ip<>#73)and(Ip<>#79)
 and(Ip<>#80)and(Ip<>#81)and(Ip<>#59)then
 begin
  Writef(Sst,1,4);
  Str(I:3,Amt);
  If pos('.',Fn)<>0 then
  N:=copy(Fn,1,pos('.',Fn)-1) else N:=Fn;
  Writef(Amt+' Records in '+N+'               ',20,4);
  Blank(3);
  Write('            ',#24,' ',#25);
  Writef('PgUp PgDn           Ctrl-E to Print Label',17,23);
  Writef
('F1Tag  2Edit  3Find  4Add  5Del  6Fil  7Sort  8Fld  9Prn  Ctrl-Q  Quit',2,25)
 end;
  Repeat
   Read(Kbd,Ip);
    if (Ip=#27)and keypressed then
    read(Kbd,Ip);
     Kp:=True;
    Until Ip in [#5,#59..#67,#71..#73,#79..#81,#17];
   Case Ip of
    #5:begin Pok;If Ch=#13 then LabelP else POut(False) end;
   #59:Begin
        If copy(A[X,No],1,1)<>'*'then A[X,No]:=concat('*',A[X,No]) else
        If copy(A[X,No],1,1)='*' then A[X,No]:=copy(A[X,No],2,23);
        Y:=True;
        Z:=True
       end;
   #60:begin Ip:=#0;Blank(3);EditR;Y:=True end;
   #61:Find;
   #62:AddRec;
   #63:Delete;
   #64:FileHandle;
   #65:Sort;
   #66:Field;
   #67:begin POk;If Ch=#13 then PR else POut(False) end;
   #71:begin If X>0  then begin X:=1;Y:=True end else Y:=False end;
   #72:begin If X<=1 then Y:=False else begin X:=Pred(X);Y:=True end end;
   #73:begin If X<=1 then Y:=False else
        begin X:=X-10;If X<1 then X:=1;Y:=True end end;
   #79:begin If X<>I then begin X:=I;Y:=True end else Y:=False end;
   #80:Begin If X>=I then Y:=False else begin X:=Succ(X);Y:=True end end;
   #81:Begin If X>=I then Y:=False else begin X:=X+10;Y:=True;If X>I then X:=I end end;
   #17:begin SaveFile;If IpS<>#27 then
        begin ClrScr;Cursor(True);Halt end;
  end
 end
end;

Procedure PM;                     {Program manager}
 var Ip:Char;
begin
 If ZZ then
  begin
   Cursor(False);
   Z:=False;
   ClrScr;
   Str(No,Cr);
   X:=0;
   zero;
   Fn:='';
   LowVideo;                {Set fields dim for writef routines}
   GotoXY(1,10);
   Write('         ');
   For J:=1 to No do
    begin
     GotoXY(1,11+J);
     Write('               ')
    end;
   GotoXY(3,2);
   Write
   ('- Ed''s Simple Address File Manager- Maximum No of Records :',F,' -');
   GotoXY(18,4);
   write('      EA.COM Version 1.0              ');
   GotoXY(T,6);
   Write('- The 1st 7 fields will print on a 15/16 x 3 1/2 label -');
   NormVideo;
   If ParamStr(1)<>''then
  begin
    FN:=ParamStr(1);
    FileLoad;
    If Amt='' then
     begin ZZ:=True;Pm end;
    Ip:=' ';
    X:=1;
    PrintF;
    PrintR
  end
    else
  begin
   Writef('- F1 Load existing file  F2 Create new File  ESC to Quit -',T,25);
   Repeat
     Read(Kbd,Ip);
      If(Ip=#27)and keypressed then
      read(Kbd,Ip);
    Until Ip in [#27,#59,#60];
     Case Ip of
      #27:begin Cursor(True);ClrScr;Halt end;
      #59:begin FileLoad;If Amt='' then
           begin ZZ:=True;Pm end;
            Ip:=' ';
            X:=1;
            PrintF;
            PrintR
           end;
      #60:begin GetFn;if Amt<>''then
           begin
            Zero;
            X:=0;
            I:=0;
            blank(3);
            PrintF;
            Field;
            AddRec;
            ZZ:=False
           end
            else
           begin
            ZZ:=True;
             PM
           end
          end
         end
     end
  end;
   If Y then PrintR;
   Menu;
 Pm
end;

BEGIN                             {Main}
 SC:=ConOutPtr;
 ZZ:=True;
 Pm
END.