/* seqio.c - do a sequential I/O test */
#include "stdio.h"

long gettime() ;

long seqio(dno,nseg,nstart,buffer,nit)
 int dno , nstart , nseg , nit ;
 char *buffer ; 
 {
    int i , nerror ;
    long t ;

    nerror =0 ;
				/* do one read to fix starting point */
    if( rawread(dno,1,nstart,buffer) != 0 )
            nerror = nerror + 1 ;          
				/* now do a series of reads */
    t = gettime() ;		/* start timing */
    for(i=0 ; i<nit ; i=i+1)
      {				/* do a read and check for errors */
        if( rawread(dno,nseg,nstart,buffer) != 0 )
            nerror = nerror + 1 ;          
        nstart = nstart + nseg ; /* move past area read */
      }
   t = gettime() - t ;		/* get elapsed time */
   if( t < 0L )
       t = t + 0x1800B0 ;

   if( nerror > 0 )
       printf(" %d errors \n",nerror) ;

   return( t ) ;		/* return elapsed time in ticks */
 }
