#include <graphics.h>

{This Library contains an implementation of the MANDELZOOM program described
in the August '85 Scientific American's Mathematical Recreations.}

main(argc,argv)
int argc;
char *argv[];
{
	int px,py,lim,count,flag;
	double rc,ic,r,i,r1,i1,xl,xr,yb,yt,xd,yd,two,four;

	if (argc != 6) {
		printf("syntax is mz Xleft,Xright,Ybottom,Ytop,LIMIT\n");
		printf("try: mz -1.5 -.75 0 .45 20\n");
		exit(0);
		}
	sscanf(argv[1],"%lf",&xl);
	sscanf(argv[2],"%lf",&xr);
	sscanf(argv[3],"%lf",&yb);
	sscanf(argv[4],"%lf",&yt);
	lim = atoi(argv[5]);
	two = (double)2.0;
	four= (double)4.0;

	xd = 640;
	xd = (xr-xl)/xd;
	if ((xl+xd) == xl) {
		printf("X interval too small\n");
		exit(0);
		}
	
	yd = 200;
	yd = (yt-yb)/yd;
	if ((yt-yd) == yt) {
		printf("Y interval too small\n");
		exit(0);
		}
	
	scr_setup();
	scr_setmode(6);
	scr_clr();

	for (py = 0; py < 200; py++) {
		for (px = 0; px < 640; px++) {
			if ( 0 != scr_csts()) {
				scr_setmode(2);
				scr_clr();
				exit(0);
				}
			pset(px,py,7);
			rc=xl+(px*xd);
			r=rc;
			ic=yt-(py*yd);
			i=ic;
			count = 0;
			flag = 7;
			while (lim>count++) {
				r1=r;
				r=r1*r1;
				i1=i;
				i=i1*i1;
				if ((r+i) > four) {
					flag = 0;
					break; 
					}
				r = rc + r - i;
				i = ic + two*r1*i1;
				}
			pset(px,py,flag);
			}
		}
	while ( 0 == scr_csts());
	scr_setmode(2);
	scr_clr();
	exit(0);
	}
