
/*
Ŀ
jzwldcrd								     
Implement a dumb wildcard search for files				     
Synopsis:								     
   match = jzwldcrd("TEST.FIL","??ST.*");                                   
									     

*/
#include <ctype.h>
jzwldcrd(fstr,fcard)
char *fstr;			/* string to search on */
char *fcard;			/* wild cards	       */
{
  int wmatch;
  int w,wlen,x;
  int wch1,wch2;

  wmatch = 1;
  wlen = strlen(fcard);

  w = 0;
  while (wmatch && (w < wlen) && *fstr)
    switch(fcard[w]) {
      case '?' :                        /* character substitution */
		 w ++;
		 fstr++;		/* look at next character */
		 break;
      case '*' :
		 x = index(fstr,'.');   /* look for dot */
		 if (x > 0) {
		   fstr += (int) x ;	/* get past period */
		   w ++;
		 }
		 else {
		   w = wlen;		/* exit loop */
		   wmatch = (fcard[wlen-1] == '*');
		 }
		 break;
      default  :
		 wch1 = *fstr++;
		 wch2 = fcard[w++];
		 wmatch = (toupper(wch1) == toupper(wch2));
		 break;
    }

  if (fcard[w] && (fcard[w] != '*'))
    return(0);
  else
    return(wmatch);
}
