#include <jaz.h>

/*
Ŀ
jzpopdir								     
Pop the directory off the directory stack and change back to that directory 
Notes									     
  if fpopdrive is NON zero, the drive will be popped also.		     
Synopsis								     
   pushdir(&whead);							     
   chdir("\\test");                                                         
   ....								     
   jzpopdir(&whead,1);   (pop the directory and drive) 		     

*/

jzpopdir(fhead,fpopdrive)
TSTKHEAD *fhead;
int fpopdrive;			/* non zero if we should pop the drive */
{
  TSTACK *wtemp;

  if (fhead->numitems) {	/* don't pop anything if there is no stack */
    chdir(fhead->last->pointer);	/* restore the path */
    if (fpopdrive)
      jzlogdrv(fhead->last->wint);	/* get original drive back */

    wtemp = fhead->last;		/* save temp copy of pointer */

    fhead->last = fhead->last->prev;
    fhead->numitems --; 		/* decrement count of items */

    free(wtemp->pointer);		   /* free memory for path */
    free((char *) wtemp);

  }
}
