/*
Ŀ
Title	 : csdsksts							     
Purpose : return 1 disk status byte					     
									     
Parms									     
  fdrive   : 0..3 for FLOPPY DISKETTE DRIVES A,B,C,D			     
  fdrive   : $80..$83 FOR FIXED DISK DRIVES  C,D,E,F ETC.		     
  fsector  : 1..9 . which sector to read				     
  ftrack   : 0..42  which track to read				     
  fhead    : 0..1   which head to read from				     
  fnumsect : how many sectors to read					     
									     
Notes: This routine reads a dummy sector into a dummy buffer because the    
	disk status option returns the status of the previous read.	     
									     
Returns								     
  $80	-   Timeout							     
  $40	-   Bad Seek							     
  $20	-   Nec Controller failed					     
  $10	-   Bad Crc							     
   $8	-   Attempt to cross 64k boundry				     
   $4	-   Sector not found						     
   $3	-   write protect						     
   $2	-   address mark not found					     
   $1	-   bad command 						     
   $0	-   Succsessful 						     
									     
written by Jack A. Zucker 75766,1336 (301) 794-5950			     
									     

*/

#include <jaz.h>		/* include register defs */
jzdsksts(fdrive)
int fdrive;
{
  TREG wreg;
  char wbuf[512];		/* buffer for sector read */
  int weseg,w;

  weseg = getes();		/* get value of extra segment */

  for (w = 0 ; w < 3 ; w ++ ) { /* allow 3 retries */
    wreg.x.ax = 0x201;		  /* read 1 sector */
    wreg.h.dh = 0;		  /* get head number */
    wreg.h.dl = fdrive; 	  /* get users drive */
    wreg.x.cx = 1;		  /* ch = track,cl = sector number */
    wreg.x.es = weseg;		  /* segment of buffer */
    wreg.x.bx = (int) wbuf;	  /* offset of wbuf    */
    intr(0x13,&wreg);
    if (! (wreg.x.flags & 1))	  /* we got a good read */
      return(0);		  /* indicate it with a zero status */
  }
  return(wreg.h.ah);		  /* at this point we have a disk error */
}
