/*
Ŀ
jzdelay.c                                                                   
Hold the program in a wait state for the specified number of clock tics.    
Note that this is NOT tied to processor speed.                              
                                                                            
Notes: there are approx 18.2 tics a second.                                 
                                                                            
 (C) JazSoft Software by Jack A. Zucker (301) 794-5950                      

*/

jzdelay(ftics)
long ftics;
{
   long wstart; 		/* hold the starting time */
   long welapse;		/* count of elapsed tics  */
   union REGS sreg,dreg;

   sreg.x.ax = 0;		/* return timer count function */
   int86(0x1A,&sreg,&dreg);
   wstart = (long) (dreg.x.cx << 16) | dreg.x.dx;
   welapse = 0;
   while (ftics > welapse) {
     sreg.x.ax = 0;		/* return timer count function */
     int86(0x1A,&sreg,&dreg);
     welapse = ((long) (dreg.x.cx << 16) | dreg.x.dx) - wstart;
   }
}
