        name    trytd
        title   TRYTD --- time & date demo
        page    55,132

;
; TRYTD.ASM -- demonstrate use of time and date routines
;
; Ray Duncan, December 1987
;

cr      equ     0dh             ; ASCII carriage return
lf      equ     0ah             ; ASCII line feed

stdin   equ     0               ; standard input handle
stdout  equ     1               ; standard output handle
stderr  equ     2               ; standard error handle


DGROUP  group   _DATA


_TEXT   segment word public 'CODE'

        assume  cs:_TEXT,ds:_DATA

        extrn   systcvt:near    ; format system time
        extrn   sysdcvt:near    ; format system date
        extrn   dirtcvt:near    ; format directory time
        extrn   dirdcvt:near    ; format directory date

main    proc    near
                                
        mov     ax,_DATA        ; make our data segment
        mov     ds,ax           ; addressable...
        mov     es,ax
        
                                ; format system time...
        mov     si,offset msg1a ; buffer address
        mov     bx,11           ; buffer length (max 11)
        call    systcvt

                                ; format system date
        mov     si,offset msg1b ; buffer address
        mov     bx,8            ; buffer length (max 8)
        call    sysdcvt

        mov     dx,offset fname ; open TRYTD.EXE file
        mov     ax,3d00h        ; Function 3DH = open,
                                ; mode = read-only
        int     21h             ; transfer to MS-DOS
        jc      main1           ; jump if open failed

        mov     fhandle,ax      ; save handle
        mov     bx,ax           ; now get file date
        mov     ax,5700h        ; and time...
        int     21h             ; transfer to MS-DOS

        mov     ax,cx           ; format file time
        mov     bx,11           ; buffer length
        mov     si,offset msg1c ; buffer address
        call    dirtcvt

        mov     ax,dx           ; format file date
        mov     bx,8            ; buffer length
        mov     si,offset msg1d ; buffer address
        call    dirdcvt

        mov     bx,fhandle      ; now release handle
        mov     ax,3e00h        ; Function 3EH = close
        int     21h             ; transfer to MS-DOS

                                ; display formatted
                                ; date and time...
        mov     dx,offset msg1  ; message address
        mov     cx,msg1_len     ; message length
        mov     bx,stdout       ; standard output handle
        mov     ah,40h          ; Function 40h = write
        int     21h             ; transfer to MS-DOS

        mov     ax,4c00h        ; terminate with
        int     21h             ; return code = zero

main1:  mov     dx,offset msg2  ; display message
        mov     cx,msg2_len     ; "Can't open TRYTD.EXE"
        mov     bx,stdout
        mov     ah,40h
        int     21h

        mov     ax,4c01h        ; terminate with
        int     21h             ; return code = 1 (error)


main    endp
        

_TEXT   ends


_DATA   segment word public 'DATA'

msg1    db      cr,lf                           
        db      'The current time and date are: '
msg1a   db      12 dup (' ')    ; time formatted here
msg1b   db      8 dup  (' ')    ; date formatted here
        db      cr,lf,lf
        db      'The TRYTD.EXE file time and date are: '
msg1c   db      12 dup (' ')    ; time formatted here
msg1d   db      8 dup  (' ')    ; date formatted here
        db      cr,lf

msg1_len equ $-msg1

msg2    db      cr,lf
        db      'Can''t open TRYTD.EXE'
        db      cr,lf

msg2_len equ $-msg2

fname   db      'TRYTD.EXE',0   ; name of this file
fhandle dw      0               ; handle for this file

_DATA   ends


STACK   segment para stack 'STACK'
        
        db      128 dup (?)

STACK   ends


        end     main

