PROGRAM PRIMES; (*$R-*)

(* This program will calculate and display all prime numbers *)
(* between 1 and 30000. The algorithm of the program is to   *)
(* start out with an array containing representatives for    *)
(* all odd numbers between 3 and 29999. Starting from 3 and  *)
(* working upwards, each odd number is then tested. If a     *)
(* number is still a member of the list when it is tested,   *)
(* it is a prime number, and thus it is printed, and all odd *)
(* multiples of the number are eliminated from the list. As  *)
(* can be expected, the program is quite slow on calculating *)
(* the very first primes, but from then on it gets faster    *)
(* and faster. Note that 1 and 2 are assumed to be primes,   *)
(* and not actually calculated.				     *)

CONST
  MAX2 = 15000;   (* MAXPRIME/2 *)
  MAX3 = 10000;   (* MAXPRIME/3 *)

VAR
  I,J,K: INTEGER;
  TEST: ARRAY[2..MAX2] OF BOOLEAN;

BEGIN
  WRITE(1:8,2:8);
  FOR I:=2 TO MAX2 DO TEST[I]:=TRUE;
  FOR I:=2 TO MAX2 DO
  IF TEST[I] THEN
  BEGIN
    J:=I+I-1; WRITE(J:8);
    IF J<MAX3 THEN
    BEGIN
      K:=I+J;
      WHILE K<=MAX2 DO
      BEGIN
	TEST[K]:=FALSE; K:=K+J;
      END;
    END;
  END;
  WRITELN;
END.
                                                 