PROGRAM HEXDUMP; (*$R-,K-*)

(* This program will output a hex dump af any disk file. Each	*)
(* line shows the address of the first byte of the line, then	*)
(* 16 bytes in hex, and then the same bytes in ASCII, if they	*)
(* are printable. On running the program, you must specify the	*)
(* name of the disk file to be dumped, and the name of the disk	*)
(* file or logical device (CON:, LST:, etc.), which is to reci-	*)
(* eve the dump.						*)

LABEL EXIT;

TYPE
  SECTOR = ARRAY[0..7,0..15] OF BYTE;
  HEXSTRING = STRING[4];
  FILENAME = STRING[14];

VAR
  ADDRESS,L,P,I,J: INTEGER;
  CH: CHAR;
  INNAME,OUTNAME: FILENAME;
  BUFFER: SECTOR;
  INFILE: FILE;
  OUTFILE: TEXT;

FUNCTION HEX(NUMBER,DIGITS: INTEGER): HEXSTRING;
CONST
  HEXDIGIT: ARRAY[0..15] OF CHAR = '0123456789ABCDEF';
VAR
  D: INTEGER;
  H: HEXSTRING;
BEGIN
  H[0]:=CHR(DIGITS);
  FOR D:=DIGITS DOWNTO 1 DO
  BEGIN
    H[D]:=HEXDIGIT[NUMBER AND 15];
    NUMBER:=NUMBER SHR 4;
  END;
  HEX:=H;
END;

BEGIN
  WRITE('Input file name? '); READLN(INNAME);
  IF INNAME='' THEN GOTO EXIT;
  WRITE('Output file name? '); READLN(OUTNAME);
  IF OUTNAME='' THEN GOTO EXIT;
  ASSIGN(INFILE,INNAME); (*$I-*) RESET(INFILE,128) (*$I+*);
  IF IORES>0 THEN
  BEGIN
    WRITELN(INNAME,' does not exist'); GOTO EXIT;
  END;
  ASSIGN(OUTFILE,OUTNAME); REWRITE(OUTFILE);
  ADDRESS:=0;
  WHILE NOT EOF(INFILE) DO
  BEGIN
    BLOCKREAD(INFILE,BUFFER,1);
    FOR L:=0 TO 7 DO
    BEGIN
      WRITE(OUTFILE,HEX(ADDRESS,4),' ');
      FOR P:=0 TO 15 DO
      BEGIN
	IF P=8 THEN WRITE(OUTFILE,' ');
	WRITE(OUTFILE,HEX(BUFFER[L,P],2):3);
      END;
      WRITE(OUTFILE,'  ');
      FOR P:=0 TO 15 DO
      BEGIN
	CH:=CHR(BUFFER[L,P]);
	IF (CH>=@32) AND (CH<=@126) THEN
	WRITE(OUTFILE,CH) ELSE WRITE(OUTFILE,'.');
      END;
      WRITELN(OUTFILE);
      ADDRESS:=ADDRESS+16;
    END;
  END;
  CLOSE(INFILE); CLOSE(OUTFILE);
  EXIT:
END.
