/**

		Program to allow selection of
		HP-2225 dot matrix LaserJet printer
		functions from the terminal

		Uses HP terminal Soft Keys

		Written in Software Toolworks C/80
		by Kent Walker, October, 1984

		Extensively modified for
		MS-DOS Lattice C, March, 1985

**/

#include <STDIO.H>
	/* Number of key  codes */
#define KODES 18

static char *pcode[KODES][4] = {
/*
Print Code	Key Label		Screen Display
*/
"\033&k0S", " Normal  Print  ", "A", "Normal Print\t80 Columns", 
"\033&k2S", "Compress Print  ", "B", "Compressed Print\t132 Columns",
"\033&k1S", "Expanded Print  ", "C", "Expanded Print\t40 Columns",
"\033&k3S", "Exp-Comp Print  ", "D", "Exp-Comp Print\t71 Columns",
"\017",	    "  Bold    On    ", "E", "Bold Print On",
"\020",	    "  Bold    Off   ", "F", "Bold Print Off",
"\033&l6D", " 6 LPI          ", "G", "6 Lines Per Inch\t66 Lines/Page",
"\033&l8D", " 8 LPI          ", "H", "8 Lines Per Inch\t88 Lines/Page",
"\033l1L",  "  Perf  Skip On ", "I", "Perferation Skip On",
"\033l0L",  "  Perf  Skip Off", "J", "Perferation Skip Off",
"\033&s0C", "  Line  Wrap On ", "K", "Line Wrap On",
"\033&s1C", "  Line  Wrap Off", "L", "Line Wrap Off",
"\033Y",    "Display Function", "M", "Display Functions On",
"\033Z",    "No Disp Function", "N", "Display Functions Off",
"\033&k0W", "UniDir   Print  ", "O", "Unidirectional Print",
"\033&k1W", " BiDir   Print  ", "P", "Bidirectional Print",
"\033E",    " Reset  Printer ", "Q", "Printer has been RESET",
" ",        "                ", " ", " " 

};
	
main()
{
	FILE *fp;
	int c;

	printf("\033H\033J");		/* clear the screen */

	printf("\033&j@");		/* erase labels */

	printf ("\033&jB");		/* enable user keys */

		/* define keys 7 & 8 */
	key( 0, 7, "  Next    Menu", "Z");
	key( 0, 8, "  Exit  Program", "X");

		/* open the PRN: "file" */
	fp = fopen( "PRN:", "w");
 
		/* display the softkeys */

	menu();

	while ( ( ( c = getch() ) != EOF )
		&& ( ( c = toupper(c) ) != 'X' ) ) {

		if ( c == 'Z' )		/* next menu */
			menu();

		else if ( ( c >= 'A' ) && ( c < 'A'+KODES ) ) {

			fprintf( fp, "%s", pcode[c-'A'][0] );
			printf( "%s\n", pcode[c-'A'][3] ); 
		}
	}

	exit();		/* close the "LST:" file */

}

menu()		/* display soft keys */
{
static tswitch = 0;

	do {
		key( 0, (tswitch % 6) + 1 ,
			 pcode[tswitch][1], pcode[tswitch][2] );

		tswitch++ ;

	} while ( tswitch < KODES && tswitch % 6 != 0 );

	printf( "\033&jB" );	/* turn on softkeys */

	if ( tswitch >= KODES )	
		tswitch = 0;
}	
/**
	KEY function sets the HP terminal User Soft keys.
	The Soft Keys must be enabled before they can be used.

	Attrribute (attr) is set in the terminal hardware and
	is defined as folows:

	attr		result
	0		Normal Key: String sent verbatim.
	1		Local Key: Response sent only to terminal,
				and not application program.
	2		Transmit Key: CR appended to string.

	The Key number should be an integer between 1 & 8

	The label can be up to 80 characters long, however only
	the first 16 characters are displayed.  The first
	eight characters are printed on the first line of the label.

	The Defined String (def) is the string returned by the 
	Soft Key when pressed.  The string can be up to 80 bytes long.
	A label of length -1 clears the buffer.

**/
key( attr, keyno, label, def )
int attr, keyno;
char *label, *def;
{
	printf("\033&f");			/* escape lead-in */

	printf( "%1.0da", attr );		/* attribute */

	printf( "%1.0dk", keyno );		/* key number */

	printf( "%02.0dd", strlen(label) );	/* length of label */

	printf( "%02.0dL", strlen(def) ); 	/* definition length */

	printf( "%s", label );			/* label */

	printf( "%s", def );			/* definition string */

	return;
}
