	Name unique
	Title
	page	,132
comment /

	This program is a filter that reads a sorted file and removes
	all duplicated lines.  Sending a sorted list of words will
	result in a list of all words, once each.

	Examples:

/
;===================================================================
code	segment	public
;===================================================================
;
;	command line is at 80h of psp - first byte is length
;
	org	80h
parmsize	db	?
parm		db	7fh dup (?)
;
; .com starts at 100h - but must jump around any data area
;
	org	100h			; com file starts here
	assume	cs:code,ds:code,es:code
unique:
	jmp	clear
;===================================================================
;
; data area for .com programs
; Uncomment (**) statements and comment (&&) statements
; if you need two different buffers.
;
buffersize	equ	255
bufsiz	db 	buffersize
bufcnt	db	?
buffer	db	buffersize dup (?)		; (&&)
;
savcnt	db	?
savbuf	db	buffersize dup (0h)		; init to nulls
;
;===================================================================
clear:
;
; start of actual code is here (clear)
;
;
; Read a line from standard input.  Char count is in bufcnt. Does not
; include the <cr>.
;
again:
	lea	dx,buffer	; point at input area
	mov	bufcnt,0h	; init size to zero
ioloop:
	mov	bx,0h		; input handle
	mov	cx,1h		; # of char to read
	mov	ah,3fh		; dos read function
	int	21h		; dos function call
;
	jc	oops		; io error!
	cmp	ax,0h		; if zero, eof!
	jz	linedone
;
	inc	bufcnt		; adjust buffer size for new character
	mov	si,dx
	cmp	byte ptr [si],0Ah	; if linefeed, line is done.
	je	linedone
	inc	dx		; point to next character spot
	jmp	ioloop		; go get another character
linedone:
	cmp	bufcnt,0h	; if zero, really eof!
	jz	oops
;
; Now compare the line just input to the previous line in savbuf.
; If they are different, print the new line and store in in savbuf.
; If they match, jump to again and read another line.
; (The first line input will never match savbuf - savbug contains
; nulls.)
;
	xor	cx,cx		; zero cx first
	mov	cl,bufcnt	; # of chars in line
	cmp	cl,savcnt	; to save line - if not equal, skip
	jne	printit
	lea	si,buffer	; input line
	lea	di,savbuf	; previous line
	repe	cmpsb		; compare each byte.
	je	again		; they matched - go get another line.
;
; Now print the line and save it in a compare buffer.
;
printit:
	xor	cx,cx		; zero out cx
	mov	cl,bufcnt	; # of characters to output
	lea	dx,buffer	; input line buffer
	mov	bx,1h		; standard output device
	mov	ah,40h		; dos write function
	int	21h		; invoke dos function
;
; copy buffer to savbuf.
;
	lea	si,bufcnt	; source buffer pointer
	lea	di,savcnt	; destination buffer pointer
	xor	cx,cx
	mov	cl,bufcnt	; size of source buffer
	inc	cx		; include size counter, too.
	rep	movsb		; character move

	jmp	again		; repeat until end of file or error
oops:
	int	20h		; return to dos
code	ends
	end	unique
