/* -*- Base: 10; Mode: C; Package: cmfs-i; -*- */
/*****************************************************************************
 * 	  Copyright (c) 1992 Thinking Machines Corporation, Inc.,	     *
 *		of Cambridge, Mass.   All rights reserved.		     *
 *									     *
 *  This notice is intended as a precaution against inadvertent publication  *
 *  and does not constitute an admission or acknowledgement that publication *
 *  has occurred or constitute a waiver of confidentiality.		     *
 *									     *
 *  Connection Machine software is the proprietary and confidential property *
 *  of Thinking Machines Corporation.					     *
 *****************************************************************************/

#ifndef _CMT_CTL_FILE_INCLUDED_
#define _CMT_CTL_FILE_INCLUDED_

#if !defined(lint) && !defined(__SABER__)
static char rcsid_cmt_ctl_file_h[] = "$Id: cmt_ctl_file.h,v 1.2 1992/07/07 18:06:58 sean Exp $";
#endif

/*****************************************************************************

Author:
Eric Sharakan, Sean Colbath

Purpose: 
Structure definition of the CTL file used for VBS files

Revision History:

$Log: cmt_ctl_file.h,v $
 * Revision 1.2  1992/07/07  18:06:58  sean
 * Saberize all code, add in standard comment header.
 *

******************************************************************************/

/*
 * Structures for the control file.
 * The basic layout of the control file is as follows.
 * Header:
 *  record format (fixed, variable, undefined)
 *  block attribute (blocked, spanned, neither, both)
 *  dataset name (padded to 20 characters to keep 32-bit alignment)
 *  number of records in dataset
 * Each entry (only used for variable-length record formats, except EOV):
 *  type of entry (BDW, SDW(1, 2 or 3), RDW(same as SDW(0)), or EOV marker)
 *  file offset (in bytes) of BDW/SDW
 *  length (in bytes) of segment, record, or block (including the DW's)
 *  length (in bytes) of data in record just ended (valid only for SDW0 & 2)
 */

/*
 * sizeof(CMT_ctl_header) must be an even multiple of sizeof(CMT_ctl_data),
 * and sizeof(CMT_ctl_header) must divide DVBASEBLOCKSIZE evenly.
 */

struct CMT_ctl_header {
  int ctl_h_rformat;
  int ctl_h_blocking;
  char ctl_h_dsn[20];
  int ctl_h_numrecs;
};

struct CMT_ctl_data {
  unsigned int ctl_e_type;
  unsigned int ctl_e_offset;
  unsigned int ctl_e_length;
  unsigned int ctl_e_reclen;
};

union CMT_ctl_entry {
  struct CMT_ctl_header CMTI_header;
  struct CMT_ctl_data CMTI_data[DVBASEBLOCKSIZE/sizeof(struct CMT_ctl_data)];
};
  
#define current_ctl_entry(fd) \
  CMTI_tape_descriptor[fd].ctl_entry->CMTI_data[CMTI_tape_descriptor[fd].ctl_entry_index]

/*
 * Values for ctl_h_rformat
 */
#define CMT_UNDEFINED 0
#define CMT_FIXED 1
#define CMT_VARIABLE 2

/*
 * Flags for ctl_h_blocking
 */
#define CMT_BLOCKED 0x1
#define CMT_SPANNED 0x2

/*
 * Values for ctl_e_type
 */
#define CMT_RDW CMT_SDW0
#define CMT_SDW0 0	/* Full record */
#define CMT_SDW1 1	/* First segment */
#define CMT_SDW2 2	/* Last segment */
#define CMT_SDW3 3	/* Intermediate segment */
#define CMT_BDW 4
#define CMT_EOV 5	/* End-of-Volume marker */

#endif /* _CMT_CTL_FILE_INCLUDED_ */
