/******************************************************************************
 *                             Revision History                               *
 ******************************************************************************

 $Log: cip_def.h,v $
 * Revision 1.2  1990/10/23  15:35:50  sharakan
 * Removed initial revision comment; changed Revision number in Rcs1Id string
 * to 5.0.1.1
 *
 * Revision 5.0.1.1  90/09/11  09:59:41  ric
 * added TOOLONG TIMEOUT
 * 
 * Revision 5.0  90/08/17  16:10:24  ric
 * *** empty log message ***
 * 
 * Revision 4.5  90/08/16  10:45:25  ric
 * trimmed down version
 * 

 *****************************************************************************/

#ifndef lint
static  char Rcs1Id[] = "cip_def.h: $Revision: 1.2 $";
#endif

/*
 *        The definitions within this file are as follows:
 *
 *	- Type definitions for 8, 16, and 32 bit quantities.
 *	- Definition of various configuration parameters
 *	- Definition for special control registers on RF-3500.
 *	- Definition for standard parameter block and its variations & qio structure.
 *	- Definition for memory based structures used by the controller.
 */

/*
 * Word order definitions
 */
#define byte    unsigned char           /*  8 bit quantity */
#define word    unsigned short          /* 16 bit quantity */
#define dword   unsigned int            /* 32 bit quantity */
#define SWAB(x) ((x) & 0xFFFF)          /* no swap for motorola processor */

/*
 *	Tunable Parameters
 */
#define RESET_DELAY     5	/* seconds to delay after SCSI-bus reset */
#define EXT_SUPER_DATA  0x0d    /* VME address modifier for Ext Sup */
#define CIP_SCSI_ID	6	/* Rimfire Controller SCSI target ID */
#define CNTRL           (CTRLSET+CTRLWID)       /* Data xfer control: no swap, 32 bit xfer */
#define THROTTLE        8       /* Bus throttle */
#define QIOPRI PRIBIO		/* Priority for sleep */
#define SCSI_STC SCSI_OPTICAL	/* STK grabbed the optical slot in the sc_conf.c file */

/*
 * How long (looping) until controller reset should complete
 * This is MUCH too cpu dependent to really be considered a second.
 */
#define SECONDS         600000          /* approx. one second in loop */

#ifdef STANDALONE
#define MAXWAIT         (2700*SECONDS)  /* wait up to45 min for format cmd */
#else
#define MAXWAIT         (15*SECONDS)    /* wait few seconds */
#endif

#define TOOLONG         (30*SECONDS)    /* wait few seconds */
/*
 * Thinking Machine supported
 * Extensions to scsi.h
 */

#define SCSI_BIG_DMA_OK   0x1000        /* Ctlr flag */
#define SC_UNF_BIG_DMA    0x1000

/*
 *	Non-Tunable Parameter
 */
#define RF3500_ID       0xFF    /* Target ID for general board commands */

/* Hardware Ports
 *
 *      The Rimfire 3500 is seen as a 512 byte area in the 16 bit
 *      address space.  There are four registers in this space,
 *      each on an 8 byte boundary.  The registers are defined below.
 */

/* Hardware ports */
typedef struct {
        word    resv;           /* msw address */
        word    addrbuf;        /* Address Buffer Port (see below) */
        word    space1[3];
        word    attention;      /* Channel Attention Port */
        word    space2[3];
        word    status;         /* Board Status Port */
        word    space3[3];
        word    reset;          /* Controller Reset Port */
} RF35REG;

/* Address Buffer Port
 *      Requires three writes in the order provided below:
 *
 *      +---------------+---------------+
 *      |    Control    | AM bits for PB|
 *      +---------------+---------------+
 *      |     PB address:  16 MSW       |
 *      +-------------------------------+
 *      |     PB address:  16 LSW       |
 *      +-------------------------------+
 */

/* Control Field bit masks */
#define CTRLBSW 0x01            /* byte swap control, 0=no swap, 1=swap */
#define CTRLWSW 0x02            /* word swap control, 0=no swap, 1=swap */
#define CTRLWID 0x04            /* width of data transfer, 0=16, 1=32 bit */
#define CTRLSET 0x80            /* apply these controls this command */

/* Status Port bit masks */
#define STATRST 0xFE            /* status of a board reset */
#define STATBSY 0x01            /* status of the Address Buffer Port */
#define STATRDY 0x02            /* board is ready */
#define RESETDONE 0x02          /* reset has completed */
#define STATCTYPE 0xFF00        /* Mask to grab controller type. */
#define STATRF3500 0x0200       /* A Rimfire 3500 board ID */

/* Standard Parameter Block
 *
 *      +-------------------------------------------------------+
 *      |                  Command Identifier                   |
 *      +---------------------------+-------------+-------------+
 *      | Reserved    |    Flags    |  Addr Mod   |  Target ID  |
 *      +---------------------------+-------------+-------------+
 *      |                  VME Memory Address                   |
 *      +-------------------------------------------------------+
 *      |                    Transfer Count                     |
 *      +-------------+-------------+-------------+-------------+
 *      |      0      |      1      |      2      |      3      |
 *      +-------------+----                  -----+-------------+
 *      |      4      | 5  SCSI Command Block  6  |      7      |
 *      +-------------+----                  -----+-------------+
 *      |      8      |      9      |     10      |     11      |
 *      +-------------+-------------+-------------+-------------+
 */
typedef struct {
        dword   pb_id;          /* unique command identifier */
        byte    resv;
        byte    flags;
        byte    addrmod;        /* address modifier used to access VME memory */
        byte    targetid;       /* SCSI target ID */
        dword   vmeaddr;        /* VME address to read from or write to */
        dword   count;          /* Transfer count */
	struct	scdb {		/* SCSI command descriptor block */
	  byte	cmd;		/* SCSI command */
	  byte 	lun	:3;	/* lun (byte 1) */
	  byte	tag	:5;	/* rest of byte 1 */
	  byte	byte2;
	  byte	byte3;		/* LSB sectors */
	  byte	byte4;		/* Number of sectors */
	  byte	byte5;		/* Control field */
	  byte	byte6;
	  byte	byte7;
	  byte	byte8;
	  byte	byte9;
	  byte	byte10;
	  byte	byte11;
	}scdb;
} PARMBLK;

/* Bits in flags field */
#define SGO     0x01            /* Scatter/gather operation */
#define DAT     0x02            /* Data transmitted in this operation */
#define DIR     0x04            /* Direction of data transfer 1=to the target */
#define IRS     0x08            /* Inhibit request sense */
#define VALID   0x80            /* Valid */


/* Status Block
 *
 *      +---------------------------+-------------+-------------+
 *      |                  Command Identifier                   |
 *      +-------------+-------------+-------------+-------------+
 *      |      0      | SCSI status |    Error    |    Flags    |
 *      +-------------+-------------+-------------+-------------+
 *      |                   Extra Information                   |
 *      +-------------------------------------------------------+
 *      |                   Extra Information                   |
 *      +-------------------------------------------------------+
 */
typedef struct {
        dword   sb_id;             /* command identifier generating status */
        byte    zero;
        byte    scsistat;       /* SCSI status, device specific */
        byte    error;          /* RF3500 specific error */
        byte    flags;          /* indicates type of status */
        byte    class;          /* class/code */
        byte    segment ;       /* Segment */
        byte    scsiflags;      /* SCSI flags */
        byte    infob3;         /* Information byte 3 */
        byte    infob4;         /* Information byte 4 */
        byte    infob5;         /* Information byte 5 */
        byte    infob6;         /* Information byte 6 */
        byte    exlength;       /* Extra length */
} STATBLK;

/* Status Block Flags Field bit masks */
#define ST_RTY  0x20            /* Retry required */
#define ST_ERR  0x40            /* Error, check error code */
#define ST_CC   0x80            /* Command complete, last status block */
#define ST_CON  0x04            /* This status block is continued from */
                                /* the previous one */  
#define ST_SOFT 0x02            /* A soft error occured (scsi sense key 01) */

/* Status Block Class bit masks */
#define ADVALID 0x80            /* Address field information valid */

/* Extended Parameter Block
 *
 *      +-------------------------------------------------------+
 *      |                                                       |
 *      +--                                                   --+
 *      |                                                       |
 *      +--                                                   --+
 *      |                                                       |
 *      +--                                                   --+
 *      |               Standard Parameter Block                |
 *      +--                                                   --+
 *      |                                                       |
 *      +--                                                   --+
 *      |                                                       |
 *      +--                                                   --+
 *      |                                                       |
 *      +---------------------------+---------------------------+
 *      |         Reserved          |          Interrupt        |
 *      +---------------------------+---------------------------+
 *      |                   Reserved, MUST be 0                 |
 *      +-------------------------------------------------------+
 *      |                                                       |
 *      +--                                                   --+
 *      |                 Standard Status Block                 |
 *      +--                                                   --+
 *      |                                                       |
 *      +-------------------------------------------------------+
 */
typedef struct {
        PARMBLK pb;             /* standard parameter block */
        word    resv0;          /* reserved */
        word    intr;           /* interrupt vector and level */
        dword   resv1;          /* reserved, must be 0 (zero) */
        STATBLK sb;             /* status block */
} EXTPB;

/*
 * The driver actually allocates these, rather than simply
 * inserting a PARMBLK into a command queue directly, to allow
 * for record keeping
 */

struct cipc_qio {
    struct cipc_qio *cipq_next;	/* Next on queue */
    struct cipc_qio *cipq_prev;	/* Previous on queue */
    struct scsi_unit *cipq_un;	/* SCSI unit struct associated with this IOPB */
    struct buf *cipq_buf;	/* Buf associated with this xfr */	
    int cipq_mbinfo;		/* Mainbus resources */
    int	cipq_flags;		/* Not yet used */
    int cipq_time;		/* Time this IOPB was given to the Rimfire */
    EXTPB qio_xpb;		/* Pointer to associated parameter block */
};
#define NQIO 16

/*
 * Values passed to cip_ext_cmd
 */
#define CIPC_WAIT	0	/* wait for completion */
#define CIPC_INTR	1	/* interrupt driven */


/* Command list format
 *
 *      +-------------------------------------------------------+
 *      |             Parameter block IN pointer                |
 *      +-------------------------------------------------------+
 *      |             Parameter block OUT pointer               |
 *      +-------------------------------------------------------+
 *      |               Status block IN pointer                 |
 *      +-------------------------------------------------------+
 *      |               Status block OUT pointer                |
 *      +-------------------------------------------------------+
 *      |              Parameter block area size                |
 *      +-------------------------------------------------------+
 *      |               Status block area size                  |
 *      +-------------------------------------------------------+
 *      |                                                       |
 *      |                                                       |
 *      |                 Parameter block area                  |
 *      |                                                       |
 *      |                                                       |
 *      +-------------------------------------------------------+
 *      |                                                       |
 *      |                                                       |
 *      |                   Status block area                   |
 *      |                                                       |
 *      |                                                       |
 *      +-------------------------------------------------------+
 */
#define NPB     0x20            /* Max. number of parameter blocks */
#define NSB     0x20            /* Max. number of status blocks */

/* Masks for wrapping around IN/OUT pointers - do NOT define these if
 * the corresponding NxB value is not a power of 2.
 */
#define NPBMASK 0x1F            /* mask for valid parameter block index */
#define NSBMASK 0x1F            /* mask for valid status block index */

typedef struct {
        dword   pbin;           /* parameter block in pointer */
        dword   pbout;          /* parameter block out pointer */
        dword   sbin;           /* status block in pointer */
        dword   sbout;          /* status block out pointer */
        dword   pbsize;         /* parameter block area size */
        dword   sbsize;         /* status block area size */
        dword   resv[2];        /* reserved */
        PARMBLK pblist[NPB];    /* parameter blocks */
        STATBLK sblist[NSB];    /* status blocks */
} CMDLIST;

/* RF 3500 commands for Targets ID 0xFF */
#define C_STARTCL       1       /* start command list */
#define C_STOPCL        2       /* stop command list */
#define C_IDENTIFY      5       /* identify */
#define C_STATS         6       /* board statistics */
#define C_OPTION        7       /* general options */
#define C_UNITOPT       8       /* init I/O control group */
#define C_DIAGNOSTIC    9       /* board self-test command */

/************************************************************************
 *      Command #1 - Start Command List
 ************************************************************************/

/* Alternate Parameter Block - Setup command list */
typedef struct {
        dword   id;             /* unique command identifier */
        word    resv1;          /* reserved */
        byte    addrmod;        /* address modifier used to access VME memory */
        byte    targetid;       /* SCSI target ID, set to 0xFF */
        dword   memaddr;        /* command list memory address */
        word    resv0;          /* reserved */
        word    intr;           /* interrupt vector and level */
        byte    command;        /* command to execute */
        byte    resv2[3];
        dword   resv3[2];       /* reserved */
} SETUPPB;

/************************************************************************
 *      Command #2 - Stop Command List
 ************************************************************************/

/* Alternate Parameter Block - Stop command list */
typedef struct {
        dword   id;             /* unique command identifier */
        byte    resv1[3];       /* reserved */
        byte    targetid;       /* SCSI target ID, set to 0xFF */
        dword   resv2[2];
        byte    command;        /* command to execute */
        byte    resv3[3];
        dword   resv4[2];
} STOPPB;

/************************************************************************
 *      Command #5 - Identify
 ************************************************************************/

/* Alternate Status Block for Identify command */
typedef struct {
        dword   id;             /* identifier */
        byte    fwrev;          /* firmware revision level */
        byte    engrev;         /* engineering revision level */
        byte    error;          /* error code */
        byte    flags;          /* flags */
        byte    optflags;       /* optional flags (see below) */
        byte    day;            /* day the firmware was generated */
        byte    month;          /* month the firmware was generated */
        byte    year;           /* year the firmware was generated */
        dword   resv;           /* reserved */
} RETID;

/* Opt flags field in Identify Status Block */
#define FDO     0x01            /* set   = Floppy Disk Option present */

/************************************************************************
 *      Command #6 - Board Statistics
 ************************************************************************/

/* Alternate Parameter Block - Board Statistics */
typedef struct {
        dword   id;             /* unique command identifier */
} STATPB;

/************************************************************************
 *      Command #7 - General Options
 ************************************************************************/

/* Alternate Parameter Block - General Options command */
typedef struct {
        dword   id;             /* identifier */
        byte    optflags;       /* optional flags (see below) */
        byte    throttle;       /* bus throttle */
        byte    ownid;          /* SCSI target ID */
        byte    targetid;       /* SCSI target ID, set to 0xFF */
        dword   resv0[2];       /* reserved */
        byte    command;        /* command to execute */
        byte    resv3[3];       /* status block interrupts (see below) */
        dword   resv4[2];
} GOPTPB;

/* Opt flags field in parameter block */
#define DIS     0x01            /* set   = Allow disconnect/reselect in SCSI operation */
#define PAR     0x02            /* set   = Report parity errors on SCSI bus */
#define BMT     0x04            /* set   = Use Block Mode Transfers to/from Memory */

/* NOTE: Suns DO NOT support the BMT option. */

/************************************************************************
 *      Command #8 - Unit options
 ************************************************************************/

/* Alternate Parameter Block - Unit Options */
typedef struct {
        dword   id;             /* command identifier */
        word    distimeout;     /* SCSI disconnect timeout, .1 sec unit */
        byte    unitid;         /* SCSI target id */
        byte    targetid;       /* SCSI target id, set to 0xFF */
        word    seltimeout;     /* SCSI select timeout, millisec units */
        byte    retrycntrl;     /* Retry control (see below) */
        byte    retrylimit;     /* Number of retries if retry enabled */
        word    resv2;          /* Reserved */
        byte    reqlength;      /* Extended sense count for req sense cmd */
        byte    uflags;         /* Unit flags (see below) */
        byte    command;        /* Command to execute (0x8) */
        byte    resv4[3];       /* Reserved */
        dword   resv5[2];       /* Reserved */
} UOPPB;

/* Retry control bit fields */
#define SCINT   0x01            /* Issue "error" interrupt for each retry */
#define RCISB   0x02            /* Issue status block for each retry */
#define RCRPE   0x04            /* Retry parity error */
#define RCRCE   0x08            /* Retry command errors (SCSI errors) */
#define RCRBE   0x10            /* Retry bus errors (selection timeouts, etc) */

/* Unit flags bit fields */
#define UF_IDI  0x01            /* Inhibit Disconnect */
#define UF_SYN  0x02            /* Synchronous Transfers */
#define UF_IAT  0x04            /* Inhibit ATN Signal */
#define UF_ISE  0x20            /* Don't retry soft errors, but report using  */
                                /* the flag field in the stat blk (ST_SOFT)   */  
/************************************************************************
 *      Command #9 - Diagnostic / Self Test
 ************************************************************************/

/* Alternate Parameter Block - Configure disk */
typedef struct {
        dword   id;             /* identifier */
        byte    resv1[3];       /* reserved */
        byte    targetid;       /* SCSI target id, set to 0xFF */
        dword   resv2[2];       /* reserved */
        byte    command;        /* Command to be executed */
        byte    flags;          /* Test flags */
        word    resv3;          /* Reserved */
        dword   resv4[2];       /* Reserved */
} TESTPB;

/* Test flags field in PB */
#define TESTSRT 0x01            /* Static RAM test */
#define TESTPCS 0x02            /* PROM checksum test */

/* Alternate Status Block for Diagnostic / Self Test command */
typedef struct {
        dword   id;             /* identifier */
        byte    zero[2];        /* Set to zero */
        byte    error;          /* error code */
        byte    flags;          /* flags */
        word    erroraddr;      /* Address where error found */
        byte    expected;       /* Pattern expected at error location */
        byte    found;          /* Pattern found at error location */
} RETTEST;

