/* -*- Package: CMFS-I; Base: 10; Mode: C; -*- */
/*****************************************************************************
* 	  Copyright (c) 1988 Thinking Machines Corporation, Inc.,	     *
*		of Cambridge, Mass.   All rights reserved.		     *
*									     *
*  This notice is intended as a precaution against inadvertent publication   *
*  and does not constitute an admission or acknowledgement that publication  *
*  has occurred or constitute a waiver of confidentiality.		     *
*									     *
*  Connection Machine software is the proprietary and confidential property  *
*  of Thinking Machines Corporation.					     *
*****************************************************************************/

#if !defined(lint) && !defined(__SABER__)
static char rcsid_cm_param[] = "$Id: cm_param.h,v 1.61 1992/08/20 17:14:00 taylor Exp $";
#endif

#include "cm_fs.h"

/*	Parameters for the CM file system */

#define CMINODESIZE	1024	/* was 8192; 512 *might* be even better... */
#define FIRSTBLOCKEXTENTS	(CMINODESIZE - sizeof(struct cm_inode))/sizeof(struct cm_extent)

#define BITSPERINT	(BITSPERBYTE * sizeof(int))	/* bits per int */

#define MAXDATAVAULTS	8	/* maximum striping factor */
#if !defined(MAXCMIOCS)
#define MAXCMIOCS       8       /* max number of CMIOC controllers in a CM */
#endif
#define MAXIOBUSES	16	/* max number of IO bus ids in one system */
#define MAXFSPORTS	2	/* number of I/O bus ports on a DataVault */


#if 0
#define MAXFDENTS	128	/* size of file descriptor table */
#define MAXINODES	64	/* size of inode table */
#else
#define MAXFDENTS	250	/* size of file descriptor table */
#define MAXINODES	250	/* size of inode table */
#endif

#define MAX_ERROR_NUMBER  256	/* maximum error number returned from system */
#define MAX_ERROR_MESSAGE	1024

#define MAX_CONTIGUOUS_FILE_EXTEND	0x7ffffff	/* max number of blocks to check for
						   contiguity with previous block */

#define MAXUNIQUE	(32767)	/* maximum unique value to be used in fd returned */

#define MAX_DIR_COPIES	2	/* maximum number of copies of dir. tree */

#define MAX_RETRY_COUNT	10	/* maximum number of retries on errors */

#define CMFS_MAX_GEOMETRIES	32	/* maximum number of axes in a geometry */
#define DEFAULT_BLOCKING_FACTOR    (16)    /* for nmo stuff */

#define PROCESSORS_PER_CHIP	16
#define LOG_OF_PROCESSORS_PER_CHIP	4
#define HARDWARE_PHYSICAL_WEDGE_SIZE	4096
#define SIMULATOR_PHYSICAL_WEDGE_SIZE	512
#define BITSPERIOTRANSFER		256

#define UNKNOWN_SEVERITY_LEVEL 0
#define FIRST_LEVEL FATAL
#define FATAL	1
#define MINOR	2
#define FYI	3
#define DEBUG	4
#define MAJOR   5
#define LAST_LEVEL MAJOR
#define NUM_LEVELS LAST_LEVEL+1
#define BAD_FS_LEVEL(level) \
    ((level) < FIRST_LEVEL) || ((level) > LAST_LEVEL)
#define GOOD_FS_LEVEL(in_level, out_level) \
    if (BAD_FS_LEVEL(in_level)) out_level = UNKNOWN_SEVERITY_LEVEL;

#if !defined(TRUE)
#define TRUE	1
#endif
#if !defined(FALSE)
#define FALSE	0
#endif


#define OK	1
#define ERROR	-1
#define ULOK	((unsigned long) 1)
#define ULERROR	((unsigned long) -1)

/* Status of command requests */
#define COMPLETED	1
#define ONHOLD		2
#define INPROGRESS	3

#define FOREVER		for (;;)


/* Bits which contain file permission stuff */
#define PERMISSIONS	0777

/* Error returns */
#define XXX	-1


/* For serial I/O and messages */
#define HEADER_STUFF    80              	/* max size of header stuff on write or read */
#define MAXMESSAGE	(MAXSERIALDISKIO + HEADER_STUFF)        /* max size of an ipc message */

/* For front end only ops through the FIFO */
#define CM_DEFAULT_LAN_BUFFER_SIZE	(1024 * 1024)





/* macros */

#ifndef min
#define min(a,b)	(((a) < (b)) ? (a) : (b))
#endif	/* min */
#ifndef max
#define max(a,b)	(((a) > (b)) ? (a) : (b))
#endif	/* max */


/*
 * A CM word is 4096 bits -- all internal counts are kept in this unit and all
 * variables should be unsigned longs
 * Even the file offset and size in the inode are in CM words
 * All I/O local and CM should be done in multiples of BITSPERCMWORD bits
 * For the CM this means the number of vps should be a multiple of BITSPERCMWORD
 */
#define bitstoCMwords(bits, bitspercmword)	((bits)/(bitspercmword))
#define CMwordstobits(cmwords, bitspercmword)	((cmwords)*(bitspercmword))
#define CMwordstodiskblocks(cmwords, cmwordsperdiskblock)	\
    ((cmwords)/(cmwordsperdiskblock))
#define CMwordstoroundeddiskblocks(cmwords, cmwordsperdiskblock)	\
    CMwordstodiskblocks((cmwords) + (cmwordsperdiskblock) - 1, \
			(cmwordsperdiskblock))

#define bytestoCMwords(bytes, bytespercmword)	((bytes)/(bytespercmword))
#define bytestoroundedCMwords(bytes, bytespercmword)	\
    (((bytes) + (bytespercmword) - 1)/(bytespercmword))
#define CMwordstobytes(cmwords, bytespercmword)	((cmwords)*(bytespercmword))
#define diskblockstoCMwords(cmwords, cmwordsperdiskblock)	\
    ((cmwords)*(cmwordsperdiskblock))
#define free_to_offset(bytes, bytespercmword)	\
    (((bytes) != 0) ? ((bytespercmword) - (bytes)) : 0)
#define offset_to_free(bytes, bytespercmword)	\
    (((bytes) != 0) ? ((bytespercmword) - (bytes)) : 0)

#define chip_to_proc(chip)		((chip) * PROCESSORS_PER_CHIP)


/*	Types for the CM file system */

#if !defined(NO_TYPEDEFS)
typedef short	IOBUSID;
#endif

#define IOBUSID_BUS(x) ((x) >> 8)
#define IOBUSID_TARGET(x) ((x) & 0xff)
#define MAKE_IOBUSID(bus, target) ((((bus)&0xff) << 8) | ((target)&0xff))
