;;; -*- SYNTAX: COMMON-LISP; MODE: LISP; BASE: 10; PACKAGE: (*LISP-COMPILER :use (lisp *lisp)); MUSER: YES; Lowercase: Yes; Patch-File: Yes -*-

;; Patch node-reference-with-wrapper-patch
;; Author: mincy
;; Installed by hlv on 13 Jan 1992.

;; This message describes the problem and patch installed.
;;
;; From: Jeffrey Mincy <mincy@Think.COM>
;; Date: Mon, 6 Jan 92 12:09:39 EST
;; 
;;    From: Harry Voorhees <hlv@Think.COM>
;;    Date: Fri, 3 Jan 92 13:20:15 EST
;; 
;;       From: Karl Sims <karl@Think.COM>
;;       Date: Thu, 2 Jan 92 14:57:22 EST
;; 
;;       Thanks for the fix.
;;       But, here's another test function that still doesn't compile properly.
;;       (6.1 starlisp)
;; 
;; 
;;       (DEFUN TEST (a b)
;;  	 (declare (type (pvar (complex single-float)) a))
;; 	 (declare (type single-float b))
;; 
;; 	 (+!! (*!! (-!! 1.0 a) b)
;; 	      2.0)
;; 	 )
;; 
;;    Jeff,
;; 
;;    I ran Karl's program with error reporting enabled, and here is where it
;;    bombs (below).  Do you have a fix?  
;; 
;;    Harry
;; 
;;    > (compile 'test)
;;    ;;;  You are using the compiler in development mode (compilation-speed = 3)
;;    ;;; If you want faster code at the expense of longer compile time,
;;    ;;; you should use the production mode of the compiler, which can be obtained
;;    ;;; by evaluating (proclaim '(optimize (compilation-speed 0)))
;;    ;;; Generation of full safety checking code is enabled (safety = 3)
;;    ;;; Optimization of tail calls is disabled (speed = 2)
;;    >>Error: Internal inconsistency, assumption failed, while compiling (COMPLEX!! (+!! (REALPART!! #) (REALPART!! #)) (+!! (IMAGPART!! #) (IMAGPART!! #))).
;;	    Invalid code was generated.  This expression will be interpreted.
;;	    The variable #:!!-ARGUMENT-5 was referenced before being bound.
;;	    This is probably caused by an unspecified length in the return type of a function, eg (the (field-pvar *) (foo)).
;;
;; yuck.
;; 
;; The fixes are in /cm/starlisp/compiler/compiler.lisp
;; I couldnt save the file in f6101.
;;
;; added (defvar *duplicated-bindings* ())
;;
;; The following functions were changed:
;; finish
;; finish-helper
;; node-reference-with-wrapper
;;
;;
;; The cause of the bug is that node-reference-with-wrapper was called on a the
;; same node more than once.  This was caused by the complex arithmetic transforms
;; that lower the operations to floating operations.  The * optimization creates two
;; references to some of the nodes.  One of those nodes should have been copied.
;; The rest of the complier generally assumes that it will never see a node more 
;; than once.  
;;
;; -jeff
;;
;; ***************************************************************************
;; This message describes an simpler way of fixing the problem, not installed.
;;
;; From: Jeffrey Mincy <mincy@Think.COM>
;; Date: Mon, 13 Jan 92 17:24:57 EST
;;
;; There may be a better fix.  Change c*2 transform to not generate
;; multiple references to the same argument.
;;
;; eg.  change
;;   `(complex!!
;;      (-!! (*!! (realpart!! ,number1) (realpart!! ,number2)) (*!! (imagpart!! ,number1) (imagpart!! ,number2)))
;;	(+!! (*!! (realpart!! ,number1) (imagpart!! ,number2)) (*!! (imagpart!! ,number1) (realpart!! ,number2)))))
;;
;; to 
;;
;;   `(complex!!
;;	(-!! (*!! (realpart!! ,number1) (realpart!! ,number2))
;;	     (*!! (imagpart!! ,(node-source number1)) (imagpart!! ,(node-source number2))))
;;	(+!! (*!! (realpart!! ,(node-source number1)) (imagpart!! ,(node-source number2)))
;;           (*!! (imagpart!! ,(node-source number1)) (realpart!! ,(node-source number2))))))
;;
;; I didnt actually test the change.
;;
;; -jeff


(in-package '*LISP-COMPILER :use '(lisp *lisp))

(defvar *duplicated-bindings* ())

(defun finish (expression-node
	       &aux check-stack check-stack-declares optimize-check-stack-declares optimize-check-stack-ignorables
	            extra-ignorables put-check-stack-in-bindings reference)
  (multiple-value-bind (bindings code)
      (let ((*duplicated-bindings* ()))
	(finish-helper-check expression-node))
    ;; Add reference for the top-level node.
    (setq code `(,@code ,(setq reference (node-reference expression-node))))
    ;; Add binding for stack-index if it is used.
    (when (or (tree-find 'stack-index bindings) (tree-find 'stack-index code))
      (setq bindings `((stack-index *stack-index* cm-address) ,@bindings)))
    (when *bind-temp-pvar-list*
      (if (and (consp reference) (eq (car reference) 'slc::allocate-temp-pvar))
	  (setq *bind-temp-pvar-list* nil)
	  (setq bindings `((*temp-pvar-list* *temp-pvar-list*) ,@bindings))))
    (if *optimize-peephole* 
	(setq code (peephole-list code bindings)))
    ;; Generate check-stack.
    (multiple-value-setq (check-stack check-stack-declares bindings)
      (finish-check-stack expression-node bindings code))
    ;; Check for references to bindings before their bindings.
    (when *move-bindings* 
      (setq bindings (move-bindings bindings)))
    (when *check-bindings*
      (check-bindings (reverse bindings) expression-node))
    ;; Optimize bindings.
    (if (and bindings *optimize-bindings* (not *pull-out-subexpressions*))
	(multiple-value-setq (bindings check-stack code)
	  (optimize-binding-list bindings check-stack code)))
    ;; Remove SETQued bindings that are only referenced once, after they're SETQued
    (if (and bindings *optimize-bindings* *optimize-setqued-bindings* 
	     (not (tree-find 'cm:set-vp-set code)) (not (tree-find 'dotimes code)) (not (tree-find 'do code)))
	(multiple-value-setq (bindings code)
	  (optimize-setqued-bindings bindings code)))
    ;; Optimize code by pulling out common subexpressions, in code dealing with cm memory addresses.
    (if *pull-out-subexpressions*
	(multiple-value-setq (bindings check-stack code)
	  (pull-out-common-subexpressions bindings check-stack code)))
    ;; Try to optimize out extra check-stacks.
    (when (and nil
	       *optimize-check-stack*
	       check-stack (consp (cadr check-stack)) (eq (caadr check-stack) 'max))
      (multiple-value-setq (check-stack optimize-check-stack-declares)
	(old-optimize-check-stack-expression check-stack bindings code))
      (if optimize-check-stack-declares (push optimize-check-stack-declares check-stack-declares)))
    (when (and *optimize-check-stack*
	       check-stack
	       (consp check-stack) (eq (car check-stack) 'cm:allocate-stack-field))
      (multiple-value-setq
	(check-stack put-check-stack-in-bindings optimize-check-stack-ignorables optimize-check-stack-declares)
	(optimize-check-stack-expression check-stack bindings code))
      (dolist (ignorable optimize-check-stack-ignorables)
	(push ignorable extra-ignorables))
      (if optimize-check-stack-declares
	  (push optimize-check-stack-declares check-stack-declares)))
    ;; Easiest place to stick optimizations.
    (if (and *optimize-peephole* *use-paris-macros* *use-undocumented-paris*)
	(setq code (peephole-use-paris-macro-instructions-list code)))
    ;; Patch up check-stack-declares when bindings may have been removed from under it.
    (if (and check-stack-declares *pull-out-subexpressions*)
	(setq check-stack-declares
	      (mapcar #'(lambda (declare)
			  `(declare ,@(mapcar #'(lambda (decl-spec)
						  `(,(car decl-spec)
						    ,@(remove-if-not #'(lambda (symbol)
									 (find symbol bindings :key #'car))
								     (cdr decl-spec))))
					      (cdr declare))))
		      check-stack-declares)))
    ;; Remove binding for stack-index when there is only one reference to it.
    (if (and bindings (eq (caar bindings) 'stack-index) (not (tree-find 'stack-index (cdr bindings)))
	     (= 1 (tree-count 'stack-index code)))
	(setq bindings (cdr bindings)
	      code (nsubst '*stack-index* 'stack-index code)))
    ;; Return lisp code, with bindings, and check-stacks, as necessary.
    (let* ((code (if (and check-stack (not put-check-stack-in-bindings)) `(,check-stack ,@code) code))
	   result)
      (when (and check-stack (null bindings))
	#.(if *consistency-checks*
	      '(ill-assumption
		 expression-node "Compiler generated code to check stack ~S, but there were no bindings." check-stack))
	(pop code))
      (setq result
	    (if bindings
		(let ((last (last code))
		      (bindings-without-declares (bindings-without-declares bindings)))
		  (if (and (null check-stack)
			   (or (tree-find 'stack-field bindings-without-declares)
			       (tree-find 'stack-field code)))
		      (ill-assumption *node* "Not making a binding for stack-field, but it is referenced."))
		  `(let* (,@(if (and (or check-stack *bind-temp-pvar-list*)
				     #|(not (and (consp last) (consp (car last)) (eq (caar last) 'slc::allocate-temp-pvar))))|#)
				`((stack-field
				    ,(if put-check-stack-in-bindings
					 check-stack
					 (cond (check-stack '(cm:next-stack-field-id))
					       (*bind-temp-pvar-list* '(cm:allocate-stack-field 0))
					       ;; this is probably an error
					       (t '(cm:next-stack-field-id)))))))
			  ,@bindings-without-declares)
		     ,@(if *add-declares* (binding-declares bindings check-stack))
		     ,@check-stack-declares
		     ,@(binding-ignorables bindings) ,@extra-ignorables
		     ,@(if *generate-comments* (list (comment (origional-expression-as-string) nil)))
		     ,@(if (and (or check-stack *bind-temp-pvar-list*)
				(not (and (consp last) (consp (car last)) (eq (caar last) 'slc::allocate-temp-pvar))))
			   (if (equal last '(nil))
			       `(,@(nbutlast code) (cm:deallocate-upto-stack-field stack-field) nil)
			       `((prog1 (progn ,@code) (cm:deallocate-upto-stack-field stack-field))))
			   code)))
		(cond ((null code) ())
		      ((null (cdr code)) (car code))
		      (t `(progn 		     
			    ,@(if *generate-comments* (list (comment (origional-expression-as-string) nil)))
			    ,@code)))))
      (if *wrap-with-vp-set-around-code*
	  (setq result `(*with-vp-set ,*wrap-with-vp-set-around-code* ,result)))
      result)))


(defun finish-helper (expression-node)
  (case (node-expression-type expression-node)
    ((constant symbol)
     (values (node-bindings expression-node) (node-code expression-node)))
    (the
      (multiple-value-bind (bindings code)
	  (finish-helper (getf (node-plist expression-node) 'expression))
	(values (append (node-bindings expression-node) bindings)
		(append code (node-code expression-node)))))
    ((let let*)
     (if (getf (node-plist expression-node) 'compiled)
	 (multiple-value-bind (bindings code)
	     (finish-helper (getf (node-plist expression-node) 'let-body))
	   (values (append (node-bindings expression-node) bindings)
		   `((,(node-expression-type expression-node)
		      ,(getf (node-plist expression-node) 'let-bindings)
		      ,@(getf (node-plist expression-node) 'let-declares)
		      ,@code))))
	 (progn
	   (setq *bind-temp-pvar-list* t)
	   (values (node-bindings expression-node) (node-code expression-node)))))
    ((*let *let*)
     (if (getf (node-plist expression-node) 'compiled)
	 (multiple-value-bind (bindings code)
	     (finish-helper (getf (node-plist expression-node) 'let-body))
	   (values (append (node-bindings expression-node) bindings)
		   `((,(if (eq (node-expression-type expression-node) '*let) 'let 'let*)
		      ,(getf (node-plist expression-node) 'let-bindings)
		      ,@(getf (node-plist expression-node) 'let-declares)
		      ;;,@(mapcar #'(lambda (binding) `(identity ,(car binding)))
		      ;;          (getf (node-plist expression-node) 'let-bindings)) ; declare ignorable
		      ,@code))))
	 (progn
	   (setq *bind-temp-pvar-list* t)
	   (values (node-bindings expression-node) (node-code expression-node)))))
    (progn
      (if (getf (node-plist expression-node) 'compiled)
	  (multiple-value-bind (bindings code)
	      (finish-helper (getf (node-plist expression-node) 'progn-value))
	    (values bindings
		    `((progn ,@(getf (node-plist expression-node) 'progn-effect) ,@code))))
	  (progn
	    (setq *bind-temp-pvar-list* t)
	    (values (node-bindings expression-node) (node-code expression-node)))))
    (prog1
      (if (getf (node-plist expression-node) 'compiled)
	  (multiple-value-bind (bindings code)
	      (finish-helper (getf (node-plist expression-node) 'prog1-value))
	    (values bindings
		    `((prog1 (progn ,@code) ,@(getf (node-plist expression-node) 'prog1-effect)))))
	  (progn
	    (setq *bind-temp-pvar-list* t)
	    (values (node-bindings expression-node) (node-code expression-node)))))
    (compiler-let
      (if (getf (node-plist expression-node) 'compiled)
	  (multiple-value-bind (bindings code)
	      (progv (getf (node-plist expression-node) 'compiler-let-symbols)
		     (mapcar #'eval (getf (node-plist expression-node) 'compiler-let-values))
		(finish-helper (getf (node-plist expression-node) 'compiler-let-body)))
	    (values bindings
		    `((compiler-let ,(mapcar #'list
					     (getf (node-plist expression-node) 'compiler-let-symbols)
					     (getf (node-plist expression-node) 'compiler-let-values))
			,@code))))
	  (progn
	    (setq *bind-temp-pvar-list* t)
	    (values (node-bindings expression-node) (node-code expression-node)))))
    ((call lexical-call)
     (if (node-code-includes-nodes expression-node)
	 ;; Special function-call, code is interspersed with nodes.
	 (let ((bindings ()) (code ()))
	   (dolist (form (node-code expression-node))
	     (if (node-p form)
		 (multiple-value-bind (form-bindings form-code)
		     (finish-helper-check form)
		   (dolist (binding form-bindings)
		     (push binding bindings))
		   (dolist (form form-code)
		     (push form code)))
		 (if (and (consp form) (member (car form) '(dotimes *with-vp-set))
			  (node-p (caddr form)))
		     ;; Look for (dotimes (x y) <node>)
		     (multiple-value-bind (form-bindings form-code)
			 (finish-helper-check (caddr form))
		       (dolist (binding form-bindings)
			 (push binding bindings))
		       (let ((dotimes-code ()))
			 (dolist (form form-code)
			   (push form dotimes-code))
			 (push `(,(car form) ,(cadr form) ,@(nreverse dotimes-code)) code)))
		     (if (and (consp form) (eq (car form) 'dotimes)
			      (consp (caddr form)) (eq (caaddr form) 'if) (node-p (caddr (caddr form))))
			 ;; Look for (dotimes (x y) (if x <node> <node>)
			 (multiple-value-bind (then-bindings then-code)
			     (finish-helper-check (caddr (caddr form)))
			   (multiple-value-bind (else-bindings else-code)
			       (finish-helper-check (cadddr (caddr form)))
			     (dolist (binding then-bindings)
			       (push binding bindings))
			     (dolist (binding else-bindings)
			       (push binding bindings))
			     (push `(dotimes ,(cadr form) 
				      (if ,(cadr (caddr form))
					  (progn ,@then-code)
					  (progn ,@else-code)))
				   code)))
			 ;; no nodes anywhere that I can find.
			 (push form code)))))
	   (values (append (node-bindings expression-node) (nreverse bindings)) (nreverse code)))
	 ;; Regular function call.
	 (multiple-value-bind (bindings code)
	     (if (and (getf (node-plist expression-node) 'duplicated-binding) 
		      (member expression-node *duplicated-bindings*))
		 (values () ())
		 (finish-helper-list (call-node-arguments expression-node)))
	   (if (getf (node-plist expression-node) 'duplicated-binding) 
	       (pushnew expression-node *duplicated-bindings*))
	   (values (append (node-bindings expression-node) bindings)
		   (append code (node-code expression-node))))))
    (t ())))


(defun node-reference-with-wrapper (node stack-index &optional (indirect t) name-for-direct-references dont-subst)
  (when (getf (node-plist node) 'binding)
    (setf (getf (node-plist node) 'duplicated-binding) t)
    (return-from node-reference-with-wrapper (getf (node-plist node) 'binding)))
  (let ((constant
	  (cond ((null indirect)
		 #|(if (member (node-expression-type node) '(*let *let* let let* progn prog1 compiler-let))
		     (node-source node)
		     (if (node-must-be-compiled node)
			 (node-source node)
			 (or (node-reference node) (node-source node))))|#
		 (node-source node))
		((eq (node-reference node) 'nil!!) 'nil)
		((eq (node-reference node) 't!!) 't)
		((call-node-p node '!!)
		 (if (member (node-expression-type (call-node-argument1 node)) '(*let *let* let let* progn prog1 compiler-let))
		     (node-source (call-node-argument1 node))
		     (node-reference-or-source (call-node-argument1 node))))
		((and (call-node-p node 'coerce-for!!) (constant-call-p (call-node-argument1 node)))
		 (let ((node node))
		   (loop (when (call-node-p node '!!)
			   (return (node-reference-or-source (call-node-argument1 node))))
			 (if (call-node-p node 'coerce-for!!)
			     (setq node (call-node-argument1 node))
			     (ill-assumption node "node ~S was supposed to be a coerce!! node.")))))
		(t #.(if *consistency-checks* '(ill-assumption node "Node ~S isn't a constant." node)))))
	(binding ()))
    (when (and *constant-fold* (consp constant))
      (cmi::condition-case (error-object)
	  (setq constant (simplify-front-end-expressions constant))
	(cmi::error
	  (*warn node
		 "While attempting to do constant folding, the following error was signalled:~%~A"
		 (error-report-string error-object)))))
    (when (and (not (atom constant)) 
	       (not (eq (car constant) 'quote))
	       (not (and *pref-constant-ok-p* 
			 (member (car constant) '(pref *sum #|*max *min|# *or *and *xor *logand *logior *logxor)))))
      (setf binding (gensym (if indirect "!!-ARGUMENT-" (or name-for-direct-references "ARGUMENT-"))))
      (if *node-reference-in-bindings*
	  (if (stack-effect-free node)
	      (setf (node-bindings (if indirect (call-node-argument1 node) node))	  
		    `((,binding ,constant t)))
	      (setf *bind-temp-pvar-list* t
		    (node-bindings (if indirect (call-node-argument1 node) node))
		    `((,binding ,constant t))))
	  ;; Use setq in body.  
	  (setf (node-bindings (if indirect (call-node-argument1 node) node))
		(if dont-subst `((,binding nil t setq)) `((,binding nil t setq dont-subst)))
		(node-code (if indirect (call-node-argument1 node) node))
	        `((setq ,binding ,constant)))))
    (when (and *pref-constant-ok-p* (consp constant) 
	       (member (car constant) '(pref *sum #|*max *min|# *or *and *xor *logand *logior *logxor)))
      (let ((*compiling* t)) (setq constant (macroexpand-1 constant))))
    (setf (node-stack-before node) stack-index
	  (node-stack-after node) stack-index
	  (node-stack-high node) stack-index)
    (setf (getf (node-plist node) 'binding) (or binding constant))
    (or binding constant)))

(*lisp-i::increment-patch-level 8)
