;;; -*- Mode: LISP; Syntax: Common-lisp; Package: (*LISP-I COMMON-LISP-GLOBAL); Base: 10; Patch-File: Yes -*-

(in-package :*lisp-i)

;;; The top level COND used to look like:

;;; (cond ((eq type1 :array) (eq type2 :array)
;;;    ...

;;; Which was screwed up and caused internal errors.
;;; Now, correctly, there is an AND 

;;; (and (eq type1 :array) (eq type2 :array))

;;; JP.  10/11/91


(defun-wcefi equal!! (pvar1 pvar2)
  (pvar-argument!! (pvar1 pvar2) legal-pvar-value)
  (assert (and (pvarp pvar1) (pvarp pvar2)))
  (let ((type1 (pvar-type pvar1)) (type2 (pvar-type pvar2)))
    (cond
      ((and (eq type1 :array) (eq type2 :array))
       (let ((dim1 (pvar-array-dimensions pvar1))
	     (dim2 (pvar-array-dimensions pvar2)))
	 (cond
	   ((not (equal dim1 dim2))
	    nil!!)
	   ((equal (pvar-array-element-type pvar1) '(pvar string-char))
	    (cond
	      ((equal (pvar-array-element-type pvar2) '(pvar string-char))
	       (let ((result (allocate-boolean-pvar :initial-value t!!)))
		 (dotimes (i (car dim1) result)
		   (*set (the boolean-pvar result)
			 (and!! (the boolean-pvar result)
				(char=!! (aref!! (the (pvar (array string-char ((car dim1)))) pvar1) (!! i))
					 (aref!! (the (pvar (array string-char ((car dim1)))) pvar2) (!! i))))))))
	      ((equal (pvar-array-element-type pvar2) '(pvar character))
	       (let ((result (allocate-boolean-pvar :initial-value t!!)))
		 (dotimes (i (car dim1) result)
		   (*set (the boolean-pvar result)
			 (and!! (the boolean-pvar result)
				(char=!! (aref!! (the (pvar (array string-char ((car dim1)))) pvar1) (!! i))
					 (aref!! (the (pvar (array character ((car dim1)))) pvar2) (!! i))))))))
	      (t nil!!)))
	   ((equal (pvar-array-element-type pvar1) '(pvar character))
	    (cond
	      ((equal (pvar-array-element-type pvar2) '(pvar string-char))
	       (let ((result (allocate-boolean-pvar :initial-value t!!)))
		 (dotimes (i (car dim1) result)
		   (*set (the boolean-pvar result)
			 (and!! (the boolean-pvar result)
				(char=!! (aref!! (the (pvar (array character ((car dim1)))) pvar1) (!! i))
					 (aref!! (the (pvar (array string-char ((car dim1)))) pvar2) (!! i))))))))
	      ((equal (pvar-array-element-type pvar2) '(pvar character))
	       (let ((result (allocate-boolean-pvar :initial-value t!!)))
		 (dotimes (i (car dim1) result)
		   (*set (the boolean-pvar result)
			 (and!! (the boolean-pvar result)
				(char=!! (aref!! (the (pvar (array character ((car dim1)))) pvar1) (!! i))
					 (aref!! (the (pvar (array character ((car dim1)))) pvar2) (!! i))))))))
	      (t nil!!)))
	   ((and (equal (pvar-array-element-type pvar1) '(unsigned-byte 1))
		 (equal (pvar-array-element-type pvar2) '(unsigned-byte 1)))
	    (let ((result (allocate-boolean-pvar :initial-value t!!)))
	      (*set (the boolean-pvar result)
		    (=!! (taken-as!! (the (pvar (array bit ((car dim1)))) pvar1) '(pvar (unsigned-byte *)))
			 (taken-as!! (the (pvar (array bit ((car dim1)))) pvar2) '(pvar (unsigned-byte *)))))
	      result))
	   (t nil!!))))
	  ((and (member type1 '(:field :signed :float :complex)) (member type2 '(:field :signed :float :complex)))
	   (compiler-let ((*compilep* nil)) (=!! pvar1 pvar2)))
	  (t 
	   (compiler-let ((*compilep* nil)) (eql!! pvar1 pvar2))))))


(*lisp-i::increment-patch-level 4)
