;;; -*- Mode: LISP; Syntax: Common-lisp; Package: CMI; Base: 10; Patch-File: Yes -*-

(in-package 'cmi)

;;
;; Patch for /cm/paris/hardware/common/fxxxx/common-ucode-uc.lisp
;; Add clk-cntl's for timesharing register accesses.
;; fixed in /cm/paris/hardware/common/f6200/common-ucode-uc.lisp 
;;
;; 6/24/92 10:52:47 nesheim
;;

(def-min-mic handle-fifo-drain ()
  (min-mic-declare (:disp-entry nil) (:end-return t))

  ;; STATE = drain OFIFO
  ;; set CM-to-H = 2, time-share branch condition off bit 30 in uc-reg0
  (ui (alu-simp (constant 6) (Y $EXP))
      (ybus-dest-sel time-share) (clk-cntl 5-tick))
  (ui (sync-cntl force-sync))

  ;; Wait here until front-end is ready for looped back ififo stuff 
  ;; (HtoUC == 2, bit 30 gets set)
  ;;
  (label DRAIN-OFIFO-LOOP)
  (ui (jump DRAIN-OFIFO-LOOP not-ts-host-to-micro) (sync-cntl force-sync))

  ;; STATE = loop IFIFO to OFIFO
  ;; If the OFIFO has anything in it now, it's a protocol violation,
  ;; flag it and die!
  (ui (jump loop-ififo-to-ofifo of-empty) (sync-cntl force-sync))
  (uc-ferror "Timesharing context switch protocol violation:  OFIFO not empty when HtoCM == 2")

  (label loop-ififo-to-ofifo)
  ;; If there's nothing in the IFIFO, then just cleanup and exit.
  (ui (jump drain-done not-ifor) (sync-cntl force-sync))

  ;; Do *not* want to use any registers here.
  ;; We only get here if there's something in the IFIFO.
  (label if-to-of-loop)
  (wait-for-ofifo)				;; Do we need this here ? -John
  (ui (dbus-src-sel  ififo)
      (ybus-src-sel  bypass)
      (ybus-dest-sel ofifo)
      (enc-fld-a     pop-ififo))
  (ui)						;; NOP to let FIFO flag update
  (ui (jump if-to-of-loop ifor) (sync-cntl force-sync))
  
  (label drain-done)
  ;;
  ;; Wait for the OS to tell us to proceed.
  ;; set CM-to-H bit = 3, branch off bit 30
  ;; loop until bit 30 clears.
  ;;
  (ui (alu-simp (constant 7) (Y $EXP))
      (ybus-dest-sel time-share) (clk-cntl 5-tick))
  (ui (sync-cntl force-sync))

  (label wait-for-os)
  (ui (jump wait-for-os ts-host-to-micro) (sync-cntl force-sync))
  
  (ui (jump error not-of-empty) (sync-cntl force-sync))
  (ui (jump really-done not-ifor) (sync-cntl force-sync))
  (label error)
  (uc-ferror "Timeharing context switch protocol violation: FIFOS not drained!")

  (label really-done)
  ;; Done!  Head back to the dispatch loop.
  (ui (alu-simp (constant 1) (Y $EXP))
      (ybus-dest-sel time-share) (sync-cntl force-sync) (clk-cntl 5-tick))
  (ui (sync-cntl force-sync))

  (ui (alu-simp (constant 1) (Y $EXP))		;; Going back to Dispatch.
      (ybus-dest-sel time-share) (clk-cntl 5-tick)
      (next-macroinstruction)))

(DEF-MIN-MIC FAST-DISPATCH-CYCLE-12-20 ()

  (ui (setreg %total-idle-timer-high% ZERO)		;; Turn OFF timer
      (seq loop t)				;; Pop the stack.
      (enc-fld-a page-mode))			;; Make sure that PAGE-MODE defaults to normal.

  (ui (alu-simp (CONSTANT 1) (Y $EXP))          ;; Set timesharing "in-dispatch" bit
      (ybus-dest-sel time-share) (clk-cntl 5-tick))               ;; ts branch condition to bit 29

  (LABEL DISPATCH-LOOP)

  (call handle-fifo-drain ts-host-to-micro)

  (UI (ALU-SIMP IFIFO-upper (last-opcode $exp))
      (SYNC-CNTL FORCE-SYNC)			;; ***
      (wcs-sp-3 1)				;; ***
      (jump dispatch-loop not-ifor)
      (YBUS-DEST-SEL DISPATCH))

  (ui (alu-simp ZERO (Y $EXP))                  ;; Clear timesharing "in-dispatch" bit,
      (ybus-dest-sel time-share) (clk-cntl 5-tick))               ;; ts branch condition to bit 29

  (UI (SEQ CJS t DISPATCH)
      (wcs-sp-4 1)				;; ***
      (ALU-SIMP (AND MASK-20-bit IFIFO) (ARG1 $EXP))
      (ENC-FLD-A POP-IFIFO))

  (ui (alu-simp (CONSTANT 1) (Y $EXP))          ;; Set timesharing "in-dispatch" bit
      (ybus-dest-sel time-share) (clk-cntl 5-tick))               ;; ts branch condition to bit 29

  (UI (ALU-SIMP last-opcode (R0 $exp))		;; Save LAST-OPCODE in R0 during
      (wcs-sp-5 1)				;; ***
      (JUMP DISPATCH-LOOP)))

(DEF-MIN-MIC BLINK-LEDS-DISPATCH-CYCLE-12-20 ()

  (ui (setreg %total-idle-timer-high% ZERO)		;; Turn timer off.
      (seq loop t)				;; Pop the stack.
      (enc-fld-a page-mode))			;; Make sure that PAGE-MODE defaults to normal.


  (ui (alu-simp (CONSTANT 1) (Y $EXP))          ;; Set timesharing "in-dispatch" bit
      (ybus-dest-sel time-share) (clk-cntl 5-tick))               ;; ts branch condition to bit 29

  (LABEL DISPATCH-LOOP)

  (call handle-fifo-drain ts-host-to-micro)
  (UI (ALU-SIMP IFIFO-upper (last-opcode $exp))
      (jump blink not-ifor)
      (YBUS-DEST-SEL DISPATCH)
      (wcs-sp-3 1)				;; ***
      (SYNC-CNTL FORCE-SYNC))			;; ***

  (ui (alu-simp ZERO (Y $EXP))                  ;; Clear timesharing "in-dispatch" bit,
      (ybus-dest-sel time-share) (clk-cntl 5-tick))               ;; ts branch condition to bit 29

  (UI (SEQ CJS T DISPATCH)
      (wcs-sp-4 1)				;; ***
      (ALU-SIMP (AND MASK-20-bit IFIFO) (ARG1 $EXP)) 
      (ENC-FLD-A POP-IFIFO))

  (ui (alu-simp (CONSTANT 1) (Y $EXP))          ;; Set timesharing "in-dispatch" bit
      (ybus-dest-sel time-share) (clk-cntl 5-tick))               ;; ts branch condition to bit 29

  (UI (ALU-SIMP last-opcode (R0 $exp))		;; Save LAST-OPCODE in R0 during
      (wcs-sp-5 1)				;; ***
      (JUMP DISPATCH-LOOP))			;;

  (label blink)
  (MMCALL (BLINK-LIGHTS) :BR-CNTL NOT-IFOR :SHARE-REGISTERS-P T)
  (JUMP DISPATCH-LOOP))

(DEF-MIN-MIC DIAG-DISPATCH-CYCLE-12-20 ()

  (ui (seq loop t);; Pop the stack.
      (enc-fld-a page-mode));; Make sure that PAGE-MODE defaults to normal.

  ;; Clear time-share bits, sets time-share branch
  ;; condition off of bit 29 in uc-reg0
  (ui (alu-simp (CONSTANT 1) (Y $EXP))
      (ybus-dest-sel time-share) (clk-cntl 5-tick))

  (LABEL DISPATCH-LOOP)
  
  (call handle-fifo-drain ts-host-to-micro)
  (UI (ALU-SIMP IFIFO-upper (last-opcode $exp))
      (SYNC-CNTL FORCE-SYNC);; ***
      (wcs-sp-3 1);; ***
      (jump dispatch-loop not-ifor) (YBUS-DEST-SEL DISPATCH))
  (ui (alu-simp ZERO (Y $EXP))
      (ybus-dest-sel time-share) (clk-cntl 5-tick))
  (UI (SEQ CJS t DISPATCH)
      (wcs-sp-4 1);; ***
      (ALU-SIMP (AND MASK-20-bit IFIFO) (ARG1 $EXP)) (ENC-FLD-A POP-IFIFO))

  ;; Clear time-share bits, sets time-share branch
  ;; condition off of bit 29 in uc-reg0.
  (ui (alu-simp (CONSTANT 1) (Y $EXP))
      (ybus-dest-sel time-share) (clk-cntl 5-tick))
  (UI (ALU-SIMP last-opcode (R0 $exp));; Save LAST-OPCODE in R0 during
      (wcs-sp-5 1);; ***
      (JUMP DISPATCH-LOOP)))

(DEF-MIN-MIC SYNCH-DISPATCH-CYCLE-12-20 ()
  (ui (setreg %total-idle-timer-high% ZERO)		;; Make sure the TIMER is OFF.
      (seq loop t)				;; Pop the stack.
      (enc-fld-a page-mode))			;; Make sure that PAGE-MODE defaults to normal.

  ;; Clear time-share bits, sets time-share branch
  ;; condition off of bit 29 in uc-reg0
  (ui (alu-simp (CONSTANT 1) (Y $EXP))
      (ybus-dest-sel time-share) (clk-cntl 5-tick))

  (LABEL DISPATCH-LOOP)
  
  (call handle-fifo-drain ts-host-to-micro)
  (UI (ALU-SIMP IFIFO-upper (last-opcode $exp))
      (wcs-sp-3 1)				;; ***
      (SYNC-CNTL FORCE-SYNC)			;; ***
      (jump dispatch-loop not-ifor)
      (YBUS-DEST-SEL DISPATCH))
  (ui (alu-simp ZERO (Y $EXP))
      (ybus-dest-sel time-share) (clk-cntl 5-tick))
  (UI (SEQ CJS t DISPATCH)
      (wcs-sp-4 1)				;; ***
      (ALU-SIMP (AND MASK-20-bit IFIFO) (ARG1 $EXP))
      (ENC-FLD-A POP-IFIFO))

  ;; Check that all registers are the same in all UCCs
  (ui (call check-all-registers-thru-sr)
      (wcs-sp-5 1))				;; ***

  ;; Clear time-share bits, sets time-share branch
  ;; condition off of bit 29 in uc-reg0.
  (ui (alu-simp (CONSTANT 1) (Y $EXP))
      (ybus-dest-sel time-share) (clk-cntl 5-tick))
  (UI (ALU-SIMP last-opcode (R0 $exp))		;; Save LAST-OPCODE in R0 during
      (JUMP DISPATCH-LOOP)))

(DEF-MIN-MIC BLINK-AND-SYNCH-DISPATCH-CYCLE-12-20 ()

  (ui (setreg %total-idle-timer-high% ZERO)		;; Make sure the TIMER is reset.
      (seq loop t)				;; Pop the stack.
      (enc-fld-a page-mode))			;; Make sure that PAGE-MODE defaults to normal.

  ;; Clear time-share bits, sets time-share branch
  ;; condition off of bit 29 in uc-reg0
  (ui (alu-simp (CONSTANT 1) (Y $EXP))
      (ybus-dest-sel time-share) (clk-cntl 5-tick))

  (LABEL DISPATCH-LOOP)

  (call handle-fifo-drain ts-host-to-micro)
  (UI (ALU-SIMP IFIFO-upper (last-opcode $exp))
      (wcs-sp-3 1)				;; ***
      (SYNC-CNTL FORCE-SYNC)			;; ***
      (YBUS-DEST-SEL DISPATCH)
      (jump blink not-ifor))
  (ui (alu-simp ZERO (Y $EXP))
      (ybus-dest-sel time-share) (clk-cntl 5-tick))
  (UI (SEQ CJS t DISPATCH)
      (wcs-sp-4 1)				;; ***
      (ALU-SIMP (AND MASK-20-bit IFIFO) (ARG1 $EXP)) (ENC-FLD-A POP-IFIFO))

  (call check-r0-thru-sr)			;; Check R0 before saving LAST-OPCODE

  (UI (ALU-SIMP last-opcode (R0 $exp)))		;; Save LAST-OPCODE in R0 during

  ;; Check that all registers are the same in all UCCs
  (ui (call check-all-registers-thru-sr)
      (wcs-sp-5 1))				;; ***

  ;; Clear time-share bits, sets time-share branch
  ;; condition off of bit 29 in uc-reg0.
  (ui (alu-simp (CONSTANT 1) (Y $EXP))
      (ybus-dest-sel time-share) (clk-cntl 5-tick))
  (UI (ALU-SIMP last-opcode (R0 $exp))		;; Save LAST-OPCODE in R0 during
      (JUMP DISPATCH-LOOP))

  (label blink)

  (MMCALL (BLINK-LIGHTS-WITH-SYNCH) :BR-CNTL NOT-IFOR :SHARE-REGISTERS-P T)

  (UI (JUMP DISPATCH-LOOP)))


(DEF-MIN-MIC START-NEW-TIMER-DISPATCH-LOOP ()
  (ui (seq loop t)		;; pop the stack.
      (enc-fld-a page-mode))	;; make sure that page-mode defaults to normal.

  ;; set CMtoHost bit to 1 (= "in dispatch loop"), also sets time-share 
  ;; branch condition off of bit 29 in uc-reg0.   -DJK 4/17/90
  (ui (alu-simp (constant 1) (Y $EXP))
      (ybus-dest-sel time-share) (sync-cntl force-sync) (clk-cntl 5-tick))
  ;;
  ;; We OR in 512. into %total-idle-timer-high%, to tell 
  ;; wait-for-ififo-timing that it should keep track of idle time.
  ;; We don't just reset the PM and the idle timer registers, since 
  ;; we may be re-entering this dispatch loop due to timesharing context switch.
  ;;
  (ui (setreg %total-idle-timer-high% (logior %total-idle-timer-high% (constant 512.))))

  (label dispatch-loop)

  ;; Call handle-fifo-drain if HosttoCM  == 1
  ;;
  (call handle-fifo-drain ts-host-to-micro)
  (ui (jump fifo-ready ifor) (sync-cntl force-sync))

  ;; Nothing to do.
  ;; Wait for ififo ready or context switch,
  ;; and keep track of how long we waited.
  (ucblock 
    ()
    ;;
    ;; start-temp <= current clock
    ;; 7 UI's
    (stop-read-and-start-timer %scratch-reg1% %scratch-reg2%)
    ;;
    ;; subtract current time (temporarily) from saved idle
    (subtract-64-bits %total-idle-timer-low% %total-idle-timer-high%
		 %scratch-reg1% %scratch-reg2%
		 %total-idle-timer-low% %total-idle-timer-high%)
    
    ;;
    ;; Do nothing until something shows up in the IFIFO,
    ;; or context switch.
    ;;
    (label idle)
    (ui (jump stop-clock ifor) (sync-cntl force-sync))
    (ui (jump stop-clock ts-host-to-micro))
    (ui (jump idle))
    (label stop-clock)
    ;;
    ;;  7 UI's
    (stop-read-and-start-timer %scratch-reg1% %scratch-reg2%)

    ;; Add back new clock value to get updated idle time
    (add-64-bits %total-idle-timer-low% %total-idle-timer-high%
		      %scratch-reg1% %scratch-reg2%
		      %total-idle-timer-low% %total-idle-timer-high%)
    )
  (ui (jump dispatch-loop not-ifor) (sync-cntl force-sync))

  (label fifo-ready)
  ;; FIFO is ready.
  ;;
  (ui (alu-simp ififo-upper (last-opcode $exp))
      (sync-cntl force-sync);; ***
      (wcs-sp-3 1);; ***
      (ybus-dest-sel dispatch))

  ;; clear CMtoHost bit, meaning "not in dispatch loop"  -DJK 4/17/90
  (ui (alu-simp ZERO (Y $EXP))
      (ybus-dest-sel time-share) (clk-cntl 5-tick))

  (ui (seq cjs t dispatch)
      (wcs-sp-4 1)				;; ***
      (alu-simp (and mask-20-bit ififo) (arg1 $exp))
      (enc-fld-a pop-ififo))

  ;; set CMtoHost bit to 1 (= "in dispatch loop"), also sets time-share 
  ;; branch condition off of bit 29 in uc-reg0.   -DJK 4/17/90
  (ui (alu-simp (constant 1) (Y $EXP))
      (ybus-dest-sel time-share) (clk-cntl 5-tick))

  (ui (alu-simp last-opcode (r0 $exp))		;; save LAST-OPCODE in R0 during
      (wcs-sp-5 1))				;; ***

  (jump dispatch-loop)			;;
  )


(cmi::increment-patch-level 20)
