;;; -*- Mode: LISP; Syntax: Common-Lisp; Base: 10; Package: CMI; Patch-File: Yes -*-


;;; *********************** CHANGE LOG *******************
;;; 
;;; 6/23/92 16:24:47 Barmar:  Created from dfs:paris-hardware-router-f6200;skew.lisp.
;;; Comments from there:
;;;
;;; 2/7/92 Heller: reduced space needs sometimes by simplifying skew-to-32.
;;; 
;;; 2/10/92 Heller: fixed cm:permuted-get-1l and cmi::permuted-get-aref
;;; (and implicitly cmi::permuted-get-aref32).  Was getting an incorrect
;;; address length.
;;; 
;;; 
#| *************** END OF CHANGE LOG ***************|#

(in-package "CMI")

;;; This function rounds up to a multiple of 32 producing at least 32.
;;; It used to round to a power of 2 producing at least 32.
;;; [old: (max 32 (ash 1 (integer-length (1- len))))]

(defun skew-to-32 (len)
  (max 32 (logand (lognot #x1F) (+ len 31))))


(defun cm:permuted-get-1l (dest send-address source len)
  (let* ((source-geometry (cm:vp-set-geometry (cm:field-vp-set SOURCE)))
	 (address-len  (cm:geometry-send-address-length source-geometry))
	 (before-len   (1+ address-len))
	 (before-len32 (skew-to-32 before-len))
	 (len32        (skew-to-32 len))
	 )
    ;; 1. allocate space to skew/unskew data
    (with-stack-fields ((skew-before before-len32))
      (with-stack-fields ((skew-dest len32))
	(cm:u-move-zero-always-1l skew-dest len32)

	(let ((skew-address (cm:add-offset-to-field-id skew-before 0))
	      (skew-context (cm:add-offset-to-field-id skew-before address-len))
	      )

	  ;; 2. load the data for skewing
	  (cm:u-move-always-1l skew-address send-address address-len)
	  (cm:store-context skew-context)

	  ;; 3. push the context and overflow flags
	  (with-saved-context-and-overflow
	      (cm:set-context)

	    ;; 4. skew the address and context
	    (skew-always skew-before before-len32)

	    ;; 5. load the skewed context
	    (cm:load-context skew-context)

	    ;; 6. call cm:get-1l on the skewed addresses
	    (cm:get-1l skew-dest skew-address source len)

	    ;; 7. unskew the data
	    (cm:set-context)
	    (unskew-always skew-dest len32)
	    ) ;; restore context and overflow flags
	
	  ;; 8. conditionally move unskewed data to the real destination
	  (cm:u-move-1l dest skew-dest len)
	  ))))
  (values))

(defun permuted-get-aref
    (dest send-address array index dlen index-len index-limit)
  (let* ((source-geometry (cm:vp-set-geometry (cm:field-vp-set ARRAY)))
	 (address-len (cm:geometry-send-address-length source-geometry))
	 (before-len   (+ address-len index-len 1))
	 (before-len32 (skew-to-32 before-len))
	 (len32             (skew-to-32 dlen))
	 )
    ;; 1. allocate space to skew/unskew data
    (with-stack-fields ((skew-before before-len32))
      (with-stack-fields ((skew-dest   len32))
	(let ((skew-address (cm:add-offset-to-field-id skew-before 0))
	      (skew-index   (cm:add-offset-to-field-id skew-before address-len))
	      (skew-context (cm:add-offset-to-field-id skew-before (+ address-len index-len)))
	      )

	  ;; 2. load the data for skewing
	  (cm:u-move-always-1l skew-address send-address address-len)
	  (cm:u-move-always-1l skew-index   index        index-len)
	  (cm:store-context skew-context)

	  ;; 3. push the context and overflow flags
	  (with-saved-context-and-overflow
	      (cm:set-context)

	    ;; 4. skew the address, index, and context
	    (skew-always skew-before before-len32)

	    ;; 5. load the skewed context
	    (cm:load-context skew-context)

	    ;; 6. call cm:get-aref32-2l on the skewed addresses
	    (cm:get-aref32-2l skew-dest skew-address array skew-index dlen index-len index-limit)

	    ;; 7. unskew the data
	    (cm:set-context)
	    (unskew-always skew-dest len32)
	    ) ;; restore context and overflow flags

	  ;; 7. conditionally move unskewed data to the real destination
	  (cm:u-move-1l dest skew-dest dlen)
	  ))))
  (values))

(cmi::increment-patch-level 19)
