;;; -*- Mode: LISP; Syntax: Common-lisp; Package: CMI; Base: 10; Patch-File: Yes -*-

(in-package "CMI")


;;; *********************** CHANGE LOG *******************
;;; 
;;; 11/05/91 10:45:02 Barmar:  Created.
;;; 
#| *************** END OF CHANGE LOG ***************|#

;;; From dfs:diagnostics-cmioc-f6103;cmioc-diag.lisp

(defparameter *cmioc-cm200-nexus-clock-frequency-list* '(8.0 10.0 10.5 7.0))

(defun get-config-for-a-cmioc (cmioc-config-list cmioc-back-plane-mask)
  (when (memq :cm200 (cm-descriptor-property-list *hardware-configuration*))
    ;; For CM-200
    (setq *cmioc-nexus-clock-frequency-list* *cmioc-cm200-nexus-clock-frequency-list*))
  (let ((current-config-list nil) (device-found nil))
    (if (not (eql cmioc-config-list nil))
	(progn
	  (dotimes (i (count (car cmioc-config-list) cmioc-config-list))
	    (setq current-config-list (nth (+ (* i 2) 1) cmioc-config-list))
	    (if (= cmioc-back-plane-mask (get-cmioc-back-plane-mask (get-property :backplane current-config-list)))
		(progn
		  (setq *CMIOC-SELECTED* (get-property :backplane current-config-list))
		  (setq *CMIOC-BACKPLANE-MASK* 
			(get-cmioc-back-plane-mask (get-property :backplane current-config-list)))
		  (setq *CMIOC-BOARD* (get-property :io-board current-config-list))
		  (setq *CMIOC-STATION-ID* (get-property :station-id current-config-list))
		  (setq *CMIOC-BUS-ID* (get-property :bus-id current-config-list))
		  (setq *CMIOC-BUS-ARBITOR* (get-property :arbitor current-config-list))
		  (setq *CMIOC-BUS-SPEED* (get-property :bus-speed-MHz current-config-list))
		  (setq *SERVER* (get-property :server current-config-list))
		  (setq *DV-LIST* (get-property :dv-list current-config-list))
		  (setq *VMEIO-LIST* (get-property :vmeio-list current-config-list))
		  (setq *HIPPI-LIST* (get-property :hippi-list current-config-list))
		  (if (eql nil *HIPPI-LIST*)
		      (format t  "~&CONFIGURATION FILE does not contain an entry for HIPPI"))

		  (setq i (count (car cmioc-config-list) cmioc-config-list))
		  (setq device-found t))
		(setq device-found nil))
	    )))
    device-found)
  )

(cmi::increment-patch-level 7)
