;;; -*- Base: 10; Syntax: Common-Lisp; Package: cmi; Patch-File: Yes; -*- 

(in-package 'cmi)

(defvar *cm200-band-patch-file-set* 'cm200-band-patch-f6102)

(defun warn-if-wrong-machine-type ()
  (if (and (boundp '*cm200-microcode-p*) *cm200-microcode-p*)
      ;;; CM200
      (when (not (memq :cm200 (cm-descriptor-property-list *hardware-configuration*)))
	(format t "
;;; Warning: This band is setup for CM200 hardware; but according to the 
;;;          CM configuration file, the attached CM, \"~a\", is not a CM200.
;;;          Please use the appropriate lisp image for CM2 hardware."
		(cm-descriptor-name *hardware-configuration*)))

      ;;; CM2
      (when (memq :cm200 (cm-descriptor-property-list *hardware-configuration*))
	(format t "
;;; Warning: This band is setup for CM2 hardware; but according to the
;;;          CM configuration file, the attached CM, \"~a\", is a CM200. "
		(cm-descriptor-name *hardware-configuration*))
	(when (y-or-n-p ";;; Load appropriate patches for CM200 operation?")
	  (let (#+lucid (lucid::*redefinition-action* nil))
	    (dfs:compile-load-file-set *cm200-band-patch-file-set*))))))

(eval-when (load eval)
  (cm:add-initialization  "Check for appropriate hardware for this band" 
			  '(cmi::warn-if-wrong-machine-type) 'cm:*after-attach-initializations*))

(cmi::increment-patch-level 4)
