(in-package 'cmi)

;;
;; Patch to make CMFS:transpose-always
;; work correctly in C/Paris based lisp system.
;;
;; The problem is that the lisp interface is *different* in the CMFS library
;; we load for C/Paris based lisp and for Lucid based lisp, but the 
;; CMFS wrappers are the same.  We get away with it everywhere except
;; here.
;;

(defparameter 
  *cmfs-address-mapping-function-list*
  `(
     (,#'cmfs:write-to-row-major     
	  #.(lucid::foreign-variable-address "_CMFS_write_to_row_major" ))
     (,#'cmfs:write-to-column-major  
	  #.(lucid::foreign-variable-address "_CMFS_write_to_column_major" ))
     (,#'cmfs:read-from-row-major   
	  #.(lucid::foreign-variable-address "_CMFS_read_from_row_major" ))
     (,#'cmfs:read-from-column-major 
	  #.(lucid::foreign-variable-address "_CMFS_read_from_column_major"))))

(defvar *lisp-conversion-function* nil)

(lcl::def-foreign-callable
    (lisp-transpose-stub (:return-type :signed-32bit))
    ((field :fixnum))
  (funcall *lisp-conversion-function* field)
  0)

(defvar *cb-func-foreign-pointer* 
    (lucid::foreign-variable-address "_lisp_transpose_stub"))
				    
(defun cmfs::transpose-always
    (address length transposition-type address-mapping-function)
  (let ((function-pointer 0) thing)
    (when (functionp address-mapping-function)
      (setq thing
	    (find 
	      (if (symbolp address-mapping-function)
		  (symbol-function address-mapping-function)
		  address-mapping-function)
	      *cmfs-address-mapping-function-list*
		  :test '(lambda (a b) (if (listp b) (eql a (first b)) nil))))
      (if thing
	  (setq function-pointer (second thing))
	  (if address-mapping-function
	      (setq function-pointer 
		    *cb-func-foreign-pointer*))))
    (let ((*lisp-conversion-function* address-mapping-function))
      (cmfs-transpose-always address 
			     length 
			     transposition-type 
			     function-pointer)))
  (values))


(def-c-func (cmfs-transpose-always "_CMFS_transpose_always")
    ((address :unsigned-32bit) (length :unsigned-32bit) 
     (transposition-type :signed-32bit)
     (function :unsigned-32bit))
  :signed-32bit)

(cmi::increment-patch-level 3)
