#ifndef _CMIOCTL_
#define _CMIOCTL_
/*****************************************************************************
*         Copyright 1989 Thinking Machines Corporation, Inc.		     *
*	      of Cambridge, Mass.  All rights reserved.			     *
*									     *
*  This notice is intended as a precaution against inadvertent publication   *
*  and does not constitute an admission or acknowledgement that publication  *
*  has occurred or constitute a waiver of confidentiality.		     *
*									     *
*  Connection Machine software is the proprietary and confidential property  *
*  of Thinking Machines Corporation.					     *
*****************************************************************************/

#if !defined(lint) && !defined(c_star) && !defined(__SABER__) && !defined(LC)
static char rcsid_cmioctl[] = 
    "$Id: cmioctl.h,v 1.29 1992/05/22 12:50:38 nesheim Exp $";
#endif


/*
 * Ioctl definitions for the front end interface driver.
 *
 */


#ifndef KERNEL
#include <sys/types.h>
#endif

#include "attach.h"		/* for CM_INTERFACE_MAXIMUM */
/*
 * Grot.  We have to define our own versions of these
 * since Ultrix and SunOS are no longer compatable.
 * Use the version from Ultrix, which is independant of C compiler
 * oddities, and is the smaller of the two.
 *
 * _CMIO	--- no third arg.
 * _CMIOW	--- user program *writes* to the kernel in its third arg.
 * _CMIOR	--- user program *reads* from the kernel in its third arg.
 * _CMIOWR	--- user program reads & writes the kernel with its third arg.
 */
#define _CMIOCPARM_MASK   0x7f            /* Parameters are < 128 bytes   */
#define _CMIOC_VOID       (int)0x20000000 /* No parameters                */
#define _CMIOC_OUT        (int)0x40000000 /* Copy out parameters          */
#define _CMIOC_IN         (int)0x80000000 /* Copy in parameters           */
#define _CMIOC_INOUT      (int)(_CMIOC_IN|_CMIOC_OUT)
#define _CMIO(x,y)        (int)(_CMIOC_VOID|(x<<8)|y)
#define _CMIOR(x,y,t)     (int)(_CMIOC_OUT|((sizeof(t)&_CMIOCPARM_MASK)<<16)|(x<<8)|y)
#define _CMIOW(x,y,t)     (int)(_CMIOC_IN|((sizeof(t)&_CMIOCPARM_MASK)<<16)|(x<<8)|y)
#define _CMIOWR(x,y,t)    (int)(_CMIOC_INOUT|((sizeof(t)&_CMIOCPARM_MASK)<<16)|(x<<8)|y)

/*
 * Get CM user information. Should be compatible with previous releases of
 * the Sun VMEFEBI and Vax BIBI drivers, although the state flags have been 
 * extended to include US_BLOCKED and US_SHARED.
 *
 * Later on may want to change user level software to use a CM_PROCESS
 * structure.	 
 */

/*
 * ud_state flags:
 */

#define US_OPEN 	0x0001	/* A process is connected to this slot */
#define US_WAITING	0x0002	/* A connected process is waiting to attach */
#define US_CONNECTED	0x0004	/* We are attached to a hardware interface */
#define US_EXCLUSIVE	0x0008	/* No further opens of this device allowed */
#define US_DISCONNECTED	0x0010	/* We once were attached, but not anymore */
#define US_HARD_ERROR	0x0020	/* Fatal hardware error occurred */
#define US_ATTACHING	0x0040	/* Process is trying to attach */
#define US_BOOTING	0x0080	/* Process is trying to cold-boot */
#define US_BLOCKED	0x0100	/* Process is blocked on IO */
#define US_SHARED	0x0200	/* Process is sharing this device */
#define US_BEQUEATHED	0x0400	/* Process has pass on exclusive rights */
#define US_DIRECT	0x0800	/* Process has opened direct device */
#define US_READING	0x1000	/* Process is in read */
#define US_WRITING	0x2000	/* Process is in write */
#define US_CM_ERROR	0x4000	/* Error detected on suspend */

#define CM_MAX_INTERFACE CM_INTERFACE_MAXIMUM

#define CM_MAX_USERS 128	/* max sessions supported  ( <= 128) */
#define CM_MAX_CMD_LENGTH 31	/* max length of user command remembered */
#define CM_ID_STRING_LENGTH	16

typedef struct cm_user_data {
    u_short ud_state;		/* State flags for this indirect device */
    short   ud_intf;		/* Associated interface (or -1 if none) */
    short   ud_uid;		/* UID of device "owner" (first opener) */
    short   ud_detach_uid;	/* UID of whoever detached us (if we were) */
    long    ud_error_csr;	/* Saved CSR in case of hard error */
    u_long  ud_mark;		/* Time of day of last significant event */
    char    ud_command[CM_MAX_CMD_LENGTH+1]; /* User command, and null */
} CM_UDATA;

/*
 * The argument for a CM_ATTACH_WAIT ioctl:
 */
typedef struct {
    int interface[CM_MAX_INTERFACE];
} CM_WANTED_UCC_SET;

typedef struct {
    int uid;
    int pid;
    u_long began_waiting;
    CM_WANTED_UCC_SET wanted;
} CM_WAITING_USER;

/*
 * structure for a CM_GET_WAITQUEUE call.
 *
 * When calling the kernel, put the number of CM_WAITING_USER *waiting
 * will accomodate into count.
 * The kernel will put into count the number written into *waiting, and
 * will put into total_count the total number of processes waiting.  If
 * count < total_count then there are more waiters to be read.
 */
typedef struct {
    int count;			/* how many were read from the kernel? */
    int total_count;		/* how many are waiting? */
    CM_WAITING_USER *waiting;	/* array of info about each waiter */
} CM_WAITQUEUE;

/*
 * Get the process structures associated with the current device. We write
 * the address of an array (ui_array) which is to be filled  with the the
 * data (up to "ui_nusers" worth). 
 */

struct cmioc_user_info {
    long ui_array_size;		/* # of elements in the array provided */
    struct cm_user_data *ui_array; /* Where the data goes */
};


#define CM_GET_USER_INFO		_CMIOW('c', 13, struct cmioc_user_info)

#define CM_GET_MY_INFO			_CMIOR('c', 14, struct cm_user_data)

/*
 * Change the command name associated with the current process.
 */

struct cm_command_name {
    char cm_command[CM_MAX_CMD_LENGTH+1];
};

/*
 * Following added for compatibility with previous versions of the device
 * driver. These will be removed as more software gets converted to use
 * the new driver. 
 */

#define CM_RESET			_CMIO('c', 1)
#define CM_GET_REG_ADDR			_CMIOR('c', 2, CM_REGS *)
#define CM_SET_ONLINE   		_CMIO('c', 3)
#define CM_SET_OFFLINE  		_CMIO('c', 4)
#define CM_SET_EXCLUSIVE		_CMIO('c', 5)
#define CM_SET_NON_EXCLUSIVE		_CMIO('c', 6)
#define CM_CONNECT_TO_INTERFACE		_CMIOW('c', 7, int)
#define CM_WAIT_FOR_INTERFACE		_CMIOW('c', 8, int)
#define CM_CONNECT_TO_INTERFACE_SET	_CMIOWR('c', 7, int)
#define CM_WAIT_FOR_INTERFACE_SET	_CMIOWR('c', 8, int)
#define CM_DISCONNECT_FROM_INTERFACE	_CMIOW('c', 9, int)
#define CM_SET_DIAG_MODE		_CMIO('c', 10)
#define CM_CLEAR_DIAG_MODE		_CMIO('c', 11)
#define CM_SET_INTERRUPT_PROC		_CMIO('c', 12)
#define CM_SET_INTR_PID			_CMIO('c', 13)
#define CM_CLEAR_INTR_PID		_CMIO('c', 14)

#define CM_CM_OPERATION			_CMIOW('c', 10, struct cmioc_cm_op)
#define CM_DAEMON_REQUEST		_CMIOR('c', 11, struct cmioc_cm_op)
#define CM_DAEMON_REPLY			_CMIOW('c', 12, int)
#define CM_GET_USER_INFO		_CMIOW('c', 13, struct cmioc_user_info)

#define CM_SET_COMMAND_NAME		_CMIOW('c', 15, struct cm_command_name)
#define CM_WRITE_TO_CSR			_CMIOW('c', 16, long)
#define CM_READ_NEXSTAT			_CMIOR('c', 17, long)
#define CM_HARD_RESET			_CMIO('c', 18)
#define CM_SET_SOFT_INTERRUPT		_CMIOW('c', 19, long)

/*
 * New ioctls for timesharing driver
 * 6.0 version...
 */
typedef struct {
    int	p_pid;
    int	p_flags;
    int	p_uid;
} CM_PINFO;


typedef struct {
    int	pt_size;
    CM_PINFO *pt_pinfo;
} CM_PTAB;

#define PT_CM_IDLE 1
#define PT_CM_ERROR 2


/*
 * 6.1 versions...
 */
typedef struct {
    short 	p_pid;			/* pid */
    uid_t 	p_uid;			/* uid */
    int	  	p_flags;		/* ud_state */
    u_long   	p_ud_mark;		/* ud_mark */
    caddr_t	p_wchan;
    int		p_spare2[4];
} CM_PINFOX;


typedef struct {
    int	pt_size;
    int pt_cmstate;
    CM_PINFOX *pt_pinfo;
} CM_PTABX;

typedef struct {
    int	reads;
    int readlength;
    int writes;
    int writelength;
} CM_STAT;


/*
 * Some information provided by the TS daemon to
 * the driver for context switch.  Used for the vfifo-less 
 * version only at the moment.
 */
typedef struct {
    unsigned long   ucode_version;
    unsigned long if_to_of_single;
    unsigned short low_cx_pc;
    unsigned short high_cx_pc;
    unsigned long spare[5];
} CM_TSINFO;

    
#define CM_GET_HOST		_CMIOR('c', 20, int)
#define CM_GET_UCCS		_CMIOR('c', 21, int)

/*
 * Valid modes 
 */

#define CM_FREE 0		/* The CM interface is available for use */
#define CM_EXCLUSIVE  1		/* Exclusive use by client process */
#define CM_SHARE 2		/* First client is providing shared access */

#define CM_GET_MODE		_CMIOR('c', 22, int)
#define CM_SET_MODE		_CMIOW('c', 23, int)
	
/*
 * GET_NSTAT grew the ability to get nstat regs 1->3 by specifying the
 * register in the third argument.  Since older codes don't do this, the
 * register specification is encoded with a magic cookie.
 */
#define CM_OLD_GET_NSTAT	_CMIOR('c', 24, int)
#define CM_GET_NSTAT		_CMIOWR('c', 24, int)
#define CM_SET_NSTAT		_CMIOW('c', 25, int)
	
#define CM_GET_PROCS		_CMIOWR('c', 26, CM_PTAB)
	
#define	CM_SUSPEND		_CMIOW('c', 27, int)
#define CM_RESUME		_CMIOW('c', 28, long)
	
#define CM_DISCONNECT		_CMIOW('c', 29, long)
	
#define CM_GET_UCC0		_CMIOR('c', 30, long)

/*
 * Arguments for CM_SET_MODE
 */

#define	CM_EXCL		1	/* enter exclusive mode */
#define CM_SHARED	2	/* enter shared mode */

#define CM_GET_CONFIG		_CMIOR('c', 31, long)

/*
 * allow descendents exclusive rights (or take them away):
 */
#define CM_BEQUEATH		_CMIOW('c', 32, long) 
#define CM_RETAIN		_CMIOW('c', 33, long) 

#define CM_DEBUG		_CMIO('c', 34) /* toggle debug mode */
#define CM_GET_TS_PROCS		_CMIOWR('c', 36, CM_PTAB)
#define CM_GET_STATS		_CMIOR('c', 37, CM_STAT)
	
#define CM_CLOSE		_CMIO('c', 38) /* replacement for close(2) */

#define	CM_INFO_SIZE	1024	/* size of CMINFO transferred */

typedef struct {
    int	cminfo_size;
    char *cminfo_addr;
} CM_INFO;

#define CM_GET_CMINFO		_CMIOWR('c', 39, CM_INFO)
#define CM_SET_CMINFO		_CMIOWR('c', 40, CM_INFO)

#define CM_GET_CSR		_CMIOR('c', 41, long)

#define CM_RESUME_TIMESHARING	_CMIO('c', 42)
#define CM_SUSPEND_TIMESHARING	_CMIO('c', 43)

#define CM_ACCOUNTING_ON	_CMIO('c', 44)
#define CM_READ_ACCT_RECORD	_CMIOWR('c', 45, CM_ACCT_IOCTL)

struct cm_job_or_acct_id {
    char id[CM_ID_STRING_LENGTH];
};

#define CM_SET_JOB_ID	       	_CMIOW('c', 47, struct cm_job_or_acct_id)

#define CM_SET_TSINFO		_CMIOW('c', 49, CM_TSINFO)
#define CM_GET_TSINFO		_CMIOR('c', 50, CM_TSINFO)

#define CM_WAIT_FOR_CM		_CMIO('c', 51)

#define CM_SET_IDLETIMEOUT	_CMIOW('c', 52, long)
#define CM_GET_IDLETIMEOUT	_CMIOR('c', 53, long)

#define CM_SET_UCCTIMEOUT	_CMIOW('c', 54, long)
#define CM_GET_UCCTIMEOUT	_CMIOR('c', 55, long)

#define CM_PREEMPT_INTERFACE	_CMIOW('c', 56, int)

#define CM_ATTACH_WAIT		_CMIOW('c', 57, CM_WANTED_UCC_SET)
#define CM_GET_WAITQUEUE	_CMIOWR('c', 58, CM_WAITQUEUE)
#define CM_ATTACH		_CMIOW('c', 59, CM_WANTED_UCC_SET)

#define CM_GET_CHILD_ACCT_INFO	_CMIOWR('c', 60, CM_ACCT *)
#define CM_GET_TS_PROCSX	_CMIOWR('c', 61, CM_PTABX)

/*
 * Access-control-list stuff:
 *
 * An access control list may be of arbitrary length.  The way you use
 * CM_GET_ACL is to call it twice --- once with acl.len set to 0 
 * (acl.ids may be NULL).  This will write the *actual* length of the
 * list into the resulting acl.len.  Then you allocate sufficient storage,
 * (putting a pointer to the storage into acl.ids), and call CM_GET_ACL
 * again.
 */
typedef enum { CM_ACL_UID, CM_ACL_GID } CM_ACL_T;
typedef struct {
    CM_ACL_T	type;		/* user or group access control list? */
    int 	len;		/* len of the ids array */
    uid_t 	*ids;		/* storage for the ids array */
} CM_ACL;

#define CM_GET_ACL		_CMIOWR('c', 62, CM_ACL)
#define CM_SET_ACL		_CMIOW('c', 63, CM_ACL)

/*
 * Locking the nexus:
 *
 * Locking the nexus is done through the simple expedient of sticking
 * ENCODE(host-id) into nexus register 1 (``the general register'').  If
 * there is already some other host-id there, you can't lock it.
 *
 * What if the host-id that is there belongs to a host that is down?  Then
 * we force the lock.
 *
 * The user program (in the eLock_nexus() routine) does:
 *
 *	TRY_AGAIN:
 * 0	     r1 <- read NR1 (using ioctl(..., CM_GET_NSTAT, &r1)))
 * 1	     N <- locking-host(r1)
 * 2	     if(N isn't our host-id) {
 * 3		   if(host N responds to a network ping)
 * 4			  host is up, sleep, goto TRY_AGAIN;
 * 5		   --- else host is down, okay to ask for lock at GET_LOCK
 *	     }
 * 6	     --- else it's unlocked or we have it.
 *	GET_LOCK:
 * 7	     if(ioctl(..., CM_NEXUS_LOCK, N) < 0)
 * 8		     some other host has grabbed it, goto TRY_AGAIN;
 * 9	     else return SUCCESS;
 *
 * (This actually translates into a WHILE loop.)
 *
 * The device driver refuses to unlock a nexus unless it is locked by the
 * front-end the user specifies in the ioctl, locked by this front-end, or
 * locked by no one.
 *
 * The user, in turn, does not break the lock of another host unless that
 * host is not responding on the net (and therefore is assumed to be
 * down).  The other situations: this host has it locked, or no one has it
 * locked, are both trivially safe.
 *
 * This protocol works since the hardware protects the NR1 from being
 * written by more than one host at one time.
 * 
 * The host locking the nexus is encoded as hostid+1, so that 0 can be
 * interpreted as ``not locked'' (0 meaning not-locked means we can
 * interoperate with hosts that don't obey the locking protocol).
 */
#define CM_HOST_LOCKING_NEXUS_MASK	0x7
#define CM_HOST_LOCKING_NEXUS(r1)	(((r1) & CM_HOST_LOCKING_NEXUS_MASK)-1)
#define CM_NO_HOST_LOCKING_NEXUS	-1

/*
 * This is the ENCODE(host-id) macro mentioned in the description above: 
 */
#define CM_HOST_LOCKS_NEXUS(hid)	((hid) + 1)

#define CM_NEXUS_LOCK		_CMIOW('c', 64, int)
#define CM_NEXUS_UNLOCK		_CMIO('c', 65)

#define CM_RELAY_ATTACHMENT	_CMIOW('c', 66, int)

/*
 * the following structure allows sites to set quotas on access to the CM
 * by user or group id.  
 *
 * The intent is to allow sites to  shut off a user's (or group's) account
 * when they've spent too much money.
 *
 * We only accept limits measured in seconds because we don't want to do
 * the necessary calculations every clock tick.
 * 
 */
typedef struct {
    CM_ACL_T	type;		/* uid or gid? */
    union {
	uid_t	uid;		/* if 0: applies to all users */
	gid_t	gid;		/* if 0: applies to all groups */
    } id;
    int exclusive_access_limit; /* how long have we hogged the CM? */
} CM_LIMIT;

typedef struct {
    int nelements;		/* when writing: number of CM_LIMIT */
				/* structures pointed to by limit; after */
				/* reading: the number of CM_LIMIT */
				/* structures actually written at limit */
    int limit_chain_len;	/* when reading from the kernel, the kernel */
				/* fills this in with the number of limit */
				/* structures it has (this allows the user */
				/* to know whether or not they've gotten */
				/* all of them). */
    CM_LIMIT *limit;
} CM_LIMIT_ARRAY;

#define CM_SET_RUNTIME_LIMIT	_CMIOW('c', 67, CM_LIMIT_ARRAY)
#define CM_GET_RUNTIME_LIMIT	_CMIOWR('c', 68, CM_LIMIT_ARRAY)
#define CM_GET_INDIVIDUAL_RUNTIME_LIMIT	_CMIOWR('c', 69, CM_LIMIT)

#define CM_GET_ACL_DENIED	_CMIOWR('c', 70, CM_ACL)
#define CM_SET_ACL_DENIED	_CMIOW('c', 71, CM_ACL)

/*
 * Disconnect an individual process.
 */
#define CM_DISCONNECT_PROCESS   _CMIOW('c', 72, int)

/*
 * Set the account ID field for accounting.
 */
#define CM_MAX_ACCOUNT_ID_LEN 8
typedef struct { char id[CM_MAX_ACCOUNT_ID_LEN]; } CM_account_id;
#define CM_SET_ACCOUNT_ID	_CMIOW('c', 73, CM_account_id)

#endif _CMIOCTL_


