;;; -*- SYNTAX: COMMON-LISP; MODE: LISP; BASE: 10; PACKAGE: *lisp-compiler; MUSER: YES; Patch-File: Yes; -*-


(in-package '*lisp-compiler)

;;;; slc::get-from-news was coded incorrectly, using
;;;; multiple news moves instead of a single power of
;;;; two news move.


(defun get-from-news (destination source length &rest indexes)
  (declare (type fixnum destination source length))
  #+LCL3.0
  (declare (lcl:dynamic-extent indexes))

  ;; Make sure that there is at most one non-zero index provided
  ;; and that that non-zero index is a power of two.

  (*lisp-i::safety-check
    (let ((non-zero nil))
      (dolist (index indexes)
	(declare (type fixnum index))
	(when (not (zerop index))
	  (when non-zero
	    (error "Internal *Lisp compiler error.  SLC::GET-FROM-NEWS should only be ~@
                    called with one non-zero index, but it was called with indices ~S"
		   indexes
		   ))
	  (setq non-zero t)
	  (unless (power-of-two-p index)
	    (error "Internal *Lisp compiler error.  SLC::GET-FROM-NEWS should only be ~@
                    called with a news index which is a power of two, but it was called with indices ~S"
		   indexes
		   ))))))

  ;; find the non-zero index, and convert the index into
  ;; an argument useful for cm:get-from-power-two-1l, unless
  ;; the index is 1, in which case just do a simple news.
  ;; This means make it a non-negative number, make sure
  ;; its not too big, and convert it into its logarithm.

  ;; finally, do the power-of-two news operation.
  
  ;; If, in fact, all the index arguments were zero,
  ;; simply move the source to the destination

  (let ((moved? nil) (power-two-index 0) direction)
    (declare (type fixnum power-two-index))
    (do ((index (pop indexes) (pop indexes))
	 (axis 0 (the fixnum (1+ axis)))
	 )
	((null index))
      (locally
	  (declare (type fixnum index))
	(unless (zerop index)
	  (setq direction (if (plusp index) :upward :downward))
	  (if (= 1 index)
	      (progn
		(cm:get-from-news-1l destination source axis direction length)
		(setq moved? t)
		)
	      (progn
		(setq power-two-index (abs index))
		(when (>= power-two-index (dimension-size axis))
		  (setq power-two-index (mod power-two-index (dimension-size axis))))
		(setq power-two-index (1- (integer-length power-two-index)))
		(cm:get-from-power-two-1l destination source axis power-two-index direction length)
		(setq moved? t)
		)))))
    (unless moved? (cm:move destination source length))
    )

  )


(*lisp-i::increment-patch-level 11)
