/* $Id: nexus-code.h,v 1.8 1991/10/01 04:30:46 sean Rel $ */
/*****************************************************************************
* 	  (c) Copyright  1989 Thinking Machines Corporation, Inc.,	     *
*		of Cambridge, Mass.   All rights reserved.		     *
*									     *
*  This notice is intended as a precaution against inadvertent publication   *
*  and does not constitute an admission or acknowledgement that publication  *
*  has occurred or constitute a waiver of confidentiality.		     *
*									     *
*  Connection Machine software is the proprietary and confidential property  *
*  of Thinking Machines Corporation.					     *
*****************************************************************************/

/* 
 * The CM Nexus (Rev3)
 */

#ifndef NEXUS_CODE_H
#define NEXUS_CODE_H

/*
 * NEXUS status register 
 *
 *  +---------------------------------------------------------------+
 *  |  3                   2                   1                    |
 *  |1 0 9 8 7 6 5 4 3 2 1 0 9 8 7 6 5 4 3 2 1 0 9 8 7 6 5 4 3 2 1 0|
 *  +---------------------------------------------------------------+
 *  | |   | |   |   |D    |D    |D    |D    |d    |d    |d    |d    |
 *  +-+---+-+---+---+-----+-----+-----+-----+-----+-----+-----+-----+
 *   |  |     |   |    |     |     |     |     |     |     |     |
 *   |  |     |   |    |     |     |     |     |     |     |     +- UCC0
 *   |  |     |   |    |     |     |     |     |     |     +- UCC1
 *   |  |     |   |    |     |     |     |     |     +- UCC2
 *   |  |     |   |    |     |     |     |     +- UCC3
 *   |  |     |   |    |     |     |     +- HOST0	
 *   |  |     |   |    |     |     +- HOST1 
 *   |  |     |   |    |     +- HOST2
 *   |  |     |   |    +- HOST3
 *   |  |     |   +- Select host which has write access to nexus regs
 *   |  |     +- Select nexus register to write
 *   |  +- HOST ID/reset register access by *writing* to bit 30
 *   +- R0 channel error
 *
 *	D: ``direct'' bit
 *	d: ``disable'' bit
 *
 *	UCC ports contain the host that the UCC is listening to
 *	HOST ports contain ``the'' UCC the host is talking to.
 *
 *	If the disable bit is on, the UCC is not actually talking to that
 *	host. 
 */
/*
 * how far to shift to get at various fields in the nexus R0
 */
#define NEXUS_R0_CHANNEL_ERROR  (01<<31)
#define NEXUS_R0_RSEL		26 /* to select one of regs {1, 2, 3} */
#define NEXUS_R0_RSEL_MASK	(03<<NEXUS_R0_RSEL)
#define NEXUS_R0_RSEL_HOST_NUMBER	24 /* to select the host bashing */
					   /* r{1,2,3} */ 
#define NEXUS_R0_RSEL_HOST_NUMBER_MASK (03<<NEXUS_R0_RSEL_HOST_NUMBER)

#define NEXUS_R0_HOST_PORT_OFFSET	29
#define NEXUS_R0_HOST_PORT_MASK		03
#define NEXUS_R0_RESET_REGISTER_ACCESS	(unsigned long) (1<<30)

#define NEXUS_R0_HOST_DIRECT 04

/*
 * The following include the disable and direct bits in the masks and
 * field size.
 */
#define NEXUS_R0_UCC_FIELD_SIZE	3
#define NEXUS_R0_UCC_FIELD_MASK	07

#define NEXUS_R0_HOST_FIELD_SIZE 	3
#define NEXUS_R0_HOST_FIELD_MASK 	07
#define NEXUS_R0_HOST_FIELD_OFFSET	12

#define NEXUS_R0_UCC_DISABLE 04

/*
 * extract the host-id from r0
 */
#define NEXUS_R0_HOST_ID(r0)		((r0 & 0x60000000) \
					 >>NEXUS_R0_HOST_PORT_OFFSET)

#define UCC_FIELD(ucc, host_port, disable_bit) \
  (unsigned long) (((host_port | disable_bit) & NEXUS_R0_UCC_FIELD_MASK) \
		   << (ucc * NEXUS_R0_UCC_FIELD_SIZE))

#define UCC_FIELD_MASK(ucc) \
  (unsigned long) (NEXUS_R0_UCC_FIELD_MASK << (ucc * NEXUS_R0_UCC_FIELD_SIZE)) 

#define HOST_FIELD(host, value) \
  (unsigned long) (((value)&NEXUS_R0_HOST_FIELD_MASK) \
		   << ((host * NEXUS_R0_HOST_FIELD_SIZE) \
		       + NEXUS_R0_HOST_FIELD_OFFSET))
      
#define HOST_MASK(host) \
  (unsigned long) (NEXUS_R0_HOST_FIELD_MASK \
		   << ((host * NEXUS_R0_HOST_FIELD_SIZE) \
		       + NEXUS_R0_HOST_FIELD_OFFSET)) 

#define NEXUS_R3_CLOCK_CONTROL_OFFSET	15
#define NEXUS_R3_RESET_ALL_ERRORS	(unsigned long) 0x7fff

typedef struct {
    int v[4];
} nexus_port_values;

/*
 * Register 3 bit defs
 * (REV3 only!)
 */
#define HBUS_0_PERR		1
#define RST_HBUS_0_PERR		2
#define DIS_HBUS_0_EXCP		4
#define HBUS_1_PERR		8
#define RST_HBUS_1_PERR		0x10
#define DIS_HBUS_1_EXCP		0x20
#define HBUS_2_PERR		0x40
#define RST_HBUS_2_PERR		0x80
#define DIS_HBUS_2_EXCP		0x100
#define HBUS_3_PERR		0x200
#define RST_HBUS_3_PERR		0x400
#define DIS_HBUS_3_EXCP		0x800

#define XCVR_2_THERM_WARN	0x1000
#define XCVR_1_THERM_WARN	0x2000
#define NEXUS_THERM_WARN	0x4000
#define CLOCK_CTRL_MASK		0x18000
#define CLOCK_CTRL_SHIFT   15
# define CLOCK_7MHZ	0
# define CLOCK_8MHZ	1
# define CLOCK_85MHZ	2
# define CLOCK_EXTERNAL 3
#define NEXUS_NVM_WRITE		0x80000000

#define NEXUS_R3_BITS "\
\20\1HBUS_0_PERR\4HBUS_1_PERR\7HBUS_2_PERR\12HBUS_3_PERR\
\15XCVR_2_THERM_WARN\16XCVR_1_THERM_WARN\17NEXUS_THERM_WARN"


/*
 * Define a software structure that contains the pertinent fields of the Nexus
 * Status Register, so that the values are easier to manipulate.
 */

typedef struct {
    int		raw_status;
    char	host_ports[4];
    char	ucc_ports[4];
} NEXUS_STAT;

#endif /* NEXUS_CODE_H */
