;;; -*- SYNTAX: COMMON-LISP; MODE: LISP; BASE: 10; PACKAGE: (*LISP-COMPILER :use (lisp *lisp)); MUSER: YES; Lowercase: Yes; Patch-File: T -*-

(in-package '*lisp-compiler :use '(lisp *lisp))

;;; Patch name:  realpart-imagpart-ftype-patch.lisp
;;; Source file: melange.lisp
;;; Patched by:  hlv on 18 Dec 91
;;; Description: mincy's fix to eliminate an internal inconsistency
;;;              compiler warning.

(define-special-ftype (realpart imagpart) (number)
  (let ((number-type (descriptor-type (node-descriptor number))))
    (multiple-value-bind (compare-type return-type)
      (parse-descriptor-type number-type)
        (declare (ignore compare-type))
	(or return-type 't))))


(*lisp-i::increment-patch-level 7)
