;;; -*- Mode: LISP; Syntax: Common-lisp; Package: *LISP-I; Base: 10 -*-


(in-package '*lisp-i)


(defvar *starlisp-patch-level* 0)
(defvar *starlisp-patch-level-list* nil)

;;;
;;; This could be smarter, it should check the list for holes.
;;; We can't count on DFS not reloading things, so we have to
;;; be smart about when we complain.

(defun increment-patch-level (n)
;  (when (not (eql *starlisp-patch-level* (1- n)))
  (when (< *starlisp-patch-level* (1- n))
    (warn "All the available patch files have not been loaded in order.~@
           You are currently loading patch ~D, but the current patch level is only ~D.~@
           You should figure out why you are apparently missing patches!~@
           The patches which have been loaded are ~S"
	  n *starlisp-patch-level* (sort 
				     (append (list n)
					     *starlisp-patch-level-list*) '<)
	  ))
  (if (member n *starlisp-patch-level-list*)
      (format t ";;; *lisp: Note: reloaded patch level ~d." n)
      (progn
	(setq *starlisp-patch-level-list*
	      (append *starlisp-patch-level-list* (list n)))
	(setq *starlisp-patch-level* (first
				       (sort *starlisp-patch-level-list* '>))))
      ))

(defun starlisp-patch-level ()
  *starlisp-patch-level*
  )

(import-then-export '*lisp '*lisp '(starlisp-patch-level))
