;;; -*- Base: 10; Syntax: Common-Lisp; Package: cmi; Patch-File: Yes; -*- 

;;;
;;; Patch to lengthen cycles that compute maddr based on scratch ram.
;;; This doesn't change the location of any ui's.
;;;

(in-package 'cmi)


(defucmacro gen-cmis-map-scatter-slices-from-px-stride-to-px-map-from-px-stride-%c4
    (stridereg mapreg map)
  (let ((ireg (ecase stridereg
		(%P1 '%I1)
		(%P2 '%I2)
		(%P3 '%I3)
		(%P4 '%I4)))
	(creg '%C4))
    `(def-min-mic-internal ,(intern (format nil "CMIS-MAP-SCATTER-SLICES-FROM-~s-STRIDE-TO-~s-MAP~d-~s"
					    stridereg mapreg map creg)
				    cmi-package)
		       ()
       NIL
       ((min-mic-declare
	  (:DISP-ENTRY nil)
	  (:END-RETURN nil)
	  (:IMP-INLINE-ENTRY t :NO-SAVE-DISPATCH :NO-XFER))

	(ui "Copy counter from %Cn (offset) to dispatch register"
	    (alu-simp (- ,creg (constant 1))) (ybus-dest-sel dispatch)
	    "Backup counter to point to next mi's entrypoint"
	    (enc-fld-a dec-counter))
	(with-saved-sram-counter
	  "Point SRAM counter to first map entry"
	  (ui (alu-simp (constant
			 (EVAL
			  (+
			   (UC-SCRATCH-ADDRESS
			    (UC-SCRATCH-BLOCK-STRUCT '*CMIS-SCATTER-GATHER-MAP-1*))
			   ,(case map
			      (1 0)
			      (2 63)))))
			(Y $EXP))
	      (YBUS-DEST-SEL COUNTER))
	  "Pre-dec the strided register for pre-incs below, load loop count"
	  (ui (alu-simp (- ,stridereg ,ireg) (,stridereg $EXP))
	      (seq push t dispatch))

	  "Main Loop, iterate through MAP (increment SRAM counter) and dvance
           strided reg by stride (pre-inc)"
	  (ui (alu-simp (+ ,stridereg ,ireg) (,stridereg $EXP))
	      (LD-MADDR MADDR)
	      (sop :memory-bus :bypass-register
		   :memory-bus-direction :write)
	      (clk-cntl 5-tick))	; Extend CM part of this instr to fake out
					; extending sequencer part of next instr.
					; Required for cm200 because
					; sram -> alu -> maddr is too long for 4 ticks.
	  (ui (alu-simp (+ ,mapreg SCRATCH-RAM))
	      (LD-MADDR MADDR)
	      (sop :memory-bus :bypass-register
		   :memory-bus-direction :read)
	      (we-cntl hi-lo)
	      (ENC-FLD-A ,(case map (1 'INC-COUNTER) (2 'DEC-COUNTER)))
	      (seq RFCT)))
	"Restore dispatch to next mi's entrypoint"
	(ui (DBUS-SRC-SEL SCRATCH-RAM)
	    (YBUS-DEST-SEL DISPATCH)
	    (YBUS-SRC-SEL BYPASS)
	    (ENC-FLD-A INC-COUNTER))
	"Advance strided reg to last + stride and done"
	(ui (alu-simp (+ ,stridereg ,ireg) (,stridereg $exp))
	    (imp$-macroinst-return-inline :warp))))))

(def-cmis-min-mic cmis-map-scatter-slices-from-px-stride-to-px-map-%c4 ()
  (cmis-config :SPRINT)
  (min-mic-declare (:ENTRY-SPEC nil) (:DISP-ENTRY nil) (:END-RETURN nil))
  (gen-all-cmis-map-scatter-slices-from-px-stride-to-px-map-%c4))


(defucmacro gen-cmis-map-gather-slices-from-px-map-to-px-stride-%c4
    (stridereg mapreg map)
  (let ((ireg (ecase stridereg
		(%P1 '%I1)
		(%P2 '%I2)
		(%P3 '%I3)
		(%P4 '%I4)))
	(creg '%C4))
    `(def-min-mic-internal ,(intern (format nil "CMIS-MAP-GATHER-SLICES-FROM-~s-MAP~d-TO-~s-STRIDE-~s"
					    mapreg map stridereg creg)
				    cmi-package)
		       ()
       NIL
       ((min-mic-declare
	  (:DISP-ENTRY nil)
	  (:END-RETURN nil)
	  (:IMP-INLINE-ENTRY t :NO-SAVE-DISPATCH :NO-XFER))

	(ui "Copy counter from %Cn (offset) to dispatch register"
	    (alu-simp (- ,creg (constant 1))) (ybus-dest-sel dispatch)
	    "Backup counter to point to next mi's entrypoint"
	    (enc-fld-a dec-counter))
	(with-saved-sram-counter
	  "Point SRAM counter to first map entry"
	  (ui (alu-simp (constant
			 (EVAL
			  (+
			   (UC-SCRATCH-ADDRESS
			    (UC-SCRATCH-BLOCK-STRUCT '*CMIS-SCATTER-GATHER-MAP-1*))
			   ,(case map
			      (1 0)
			      (2 63)))))
			(Y $EXP))
	      (YBUS-DEST-SEL COUNTER))
	  "Pre-dec the strided register for pre-incs below, load loop count"
	  (ui (alu-simp (- ,stridereg ,ireg) (,stridereg $EXP))
	      (seq push t dispatch)
	      (clk-cntl 5-tick))	; Extend CM part of this instr to fake out
					; extending sequencer part of next instr.
					; Required for cm200 because
					; sram -> alu -> maddr is too long for 4 ticks.

	  "Main Loop, iterate through MAP (increment SRAM counter) and advance
           strided reg by stride (pre-inc)"
	  (ui (alu-simp (+ ,mapreg SCRATCH-RAM))
	      (LD-MADDR MADDR)
	      (sop :memory-bus :bypass-register
		   :memory-bus-direction :write)
	      (ENC-FLD-A ,(case map (1 'INC-COUNTER) (2 'DEC-COUNTER))))
	  (ui (alu-simp (+ ,stridereg ,ireg) (,stridereg $EXP))
	      (LD-MADDR MADDR)
	      (sop :memory-bus :bypass-register
		   :memory-bus-direction :read)
	      (we-cntl hi-lo) 
	      (seq RFCT)))
	"Restore dispatch to next mi's entrypoint"
	(ui (DBUS-SRC-SEL SCRATCH-RAM)
	    (YBUS-DEST-SEL DISPATCH)
	    (YBUS-SRC-SEL BYPASS)
	    (ENC-FLD-A INC-COUNTER))
	"Advance strided reg to last + stride and done"
	(ui (alu-simp (+ ,stridereg ,ireg) (,stridereg $exp))
	    (imp$-macroinst-return-inline :warp))))))
(def-cmis-min-mic cmis-map-gather-slices-from-px-map-to-px-stride-%c4 ()
  (cmis-config :SPRINT)
  (min-mic-declare (:ENTRY-SPEC nil ) (:DISP-ENTRY nil) (:END-RETURN nil))
  (gen-all-cmis-map-gather-slices-from-px-map-to-px-stride-%c4))


(defucmacro gen-cmis-map-mxti-px-map-cx (mxfer mdev mapreg map)
  (let ((creg '%C4))
    `(def-min-mic-internal ,(intern (format nil "CMIS-MAP-M~aT~a-~s-MAP~d-~s"
					    (case mxfer
					      (:READ "R")
					      (:WRITE "W"))
					    (symbol-name mdev)
					    mapreg
					    map
					    creg)
				    cmi-package)
	 ()
       NIL
       ((min-mic-declare
	 (:DISP-ENTRY nil)
	 (:END-RETURN nil)
	 (:IMP-INLINE-ENTRY t :NO-SAVE-DISPATCH :NO-XFER))

	(ui "Copy counter from %Cn (offset) to dispatch register"
	    (alu-simp (- ,creg (constant 1)))
	    (YBUS-DEST-SEL DISPATCH)
	    "Backup counter to point to next mi's entrypoint"
	    (enc-fld-a dec-counter))
	(with-saved-sram-counter
	    "Point SRAM counter to first map entry, init loop counter"
	  (ui (alu-simp (constant
			 (EVAL
			  (+
			   (UC-SCRATCH-ADDRESS
			    (UC-SCRATCH-BLOCK-STRUCT '*CMIS-SCATTER-GATHER-MAP-1*))
			   ,(case map
			      (1 0)
			      (2 63)))))
			(Y $EXP))
	      (YBUS-DEST-SEL COUNTER)
	      (seq push t dispatch)
	      (clk-cntl 5-tick))	; Extend CM part of this instr to fake out
					; extending sequencer part of next instr.
					; Required for cm200 because
					; sram -> alu -> maddr is too long for 4 ticks.

	  "Main Loop, iterate through MAP (increment SRAM counter)"
	  (ui (alu-simp (+ ,mapreg SCRATCH-RAM))
	      (LD-MADDR MADDR)
	      (sop :memory-bus ,(trans-letter-to-keyword mdev)
		   :memory-bus-direction ,(if (eql mxfer :READ) `:READ `:WRITE)
		   :memory-bus-pointer-control :POST-ADD)
	      (ENC-FLD-A ,(case map (1 'INC-COUNTER) (2 'DEC-COUNTER)))
	      ,@(if (eql mxfer :READ)
		    `((we-cntl hi-lo))
		    `((clk-cntl 5-tick))) ; Lengthen for next iteration (SRAM -> MADDR)
	      (seq RFCT)))
	"Restore dispatch to next mi's entrypoint"
	(ui (DBUS-SRC-SEL SCRATCH-RAM)
	    (YBUS-DEST-SEL DISPATCH)
	    (YBUS-SRC-SEL BYPASS)
	    (ENC-FLD-A INC-COUNTER))
	"done"
	(ui (imp$-macroinst-return-inline :warp))))))
(def-cmis-min-mic cmis-map-mxti-px-map-cx ()
  (cmis-config :SPRINT)
  (min-mic-declare (:ENTRY-SPEC nil ) (:DISP-ENTRY nil) (:END-RETURN nil))
  (gen-all-cmis-map-mxti-px-map-cx))




(setq *need-to-relink* t)

(cmi::increment-patch-level 12)
