;;; -*- mode: lisp; Syntax: Common-lisp; Package: lcmw; Base: 10; Muser: Yes -*-

;;;*************************************************************************************************
;;; Copyright (c) 1991 by Thinking Machines Corporation, of Cambridge, Massachusetts.
;;; All rights reserved.
;;;
;;; This notice is intended as a precaution against inadvertent publication
;;; and does not constitute an admission or acknowledgment that publication 
;;; has occurred or constitute a waiver of confidentiality.   Connection Machine software
;;; is the proprietary and confidential property of Thinking Machines Corporation.
;;;*************************************************************************************************

(in-package 'lcmw)

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;
;;;	The database goes here
;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(setq *baseline*
      ;; start baseline
      '((cm-configuration                      :no-version)
	(defs-beta                             "6101")
	(paris-defs                            "6100")
	(patch-paris			       "6104")
	(packages                              "6101")

	(utilities                             "6102")

	(starlisp-compiler                     "6101")
	(starlisp-definitions                  "6101")
	(starlisp-interpreter                  "6101")
	(starlisp-library                      "6101")
	(starlisp-graphics                     "6101")
	(paris-fast-graph                      "6101")
	(starlisp-tests                        "6000")
	(patch-starlisp			       "6101")

	(verifiers-router                      "6103")
	(verifiers-float-sgp                   nil)
	(verifiers-framebuffer                 nil)
	(verifiers-float                       "6103")
	
	(diagnostics-microcontroller           "6100")
	(diagnostics-chip                      "6102")
	(diagnostics-sprint                    "6100")
	(diagnostics-cmioc                     "6102")
	(diagnostics-framebuffer               "6102")
	(diagnostics-router-component          "6101")
	(diagnostics-router-beta               "6102")
	(diagnostics-system                    "6101")
	(diagnostics-manufacturing             "6102")
	(diagnostics-ucode-beta                "6101")

	(hardware-defs                         "5300")
	(hardware-hbi                          "5300")
	(hardware-bibi                         "6100")
	(hardware-vmefebi                      "6100")
	(hardware-fifo                         "6100")
	(hardware-nexus                        "6100")
	(hardware-sequencer                    "5301")
	(hardware-beta                         "5300")
	(hardware-error                        "6101")
	(hardware-diagnostics                  "6000")
	(hardware-nexus-diagnostics            "6100")

	(macrocode-cm2-paris                   "6104")
	(macrocode-cm200-paris                 "6104")

	(boot-beta                             "6101")

	(cmfb                                  "6102")
	(cmfs-library                          "6101")

	(clx-x11r4                             :no-version)
	(cmsr                                  "2004")
	(generic-display                       "2004")
	(generic-mouse                         "2004")
	(patch-viz			       "2004")

	(uc-assembler-beta-minimal             "6101")
	(uc-assembler-beta                     "6101")
	(min-mic                               "6102")
 	(mop-beta                              "5300")

	(paris-hardware-common                 "6101")
	(paris-hardware-mechanisms             "6101")
	(paris-hardware-sprint                 "6100")
	(paris-hardware-fp-beta                "6101")
	(paris-hardware-fp-wtl3132             "6101")

	(paris-hardware-fp-wtl3164             "6101")
	(paris-hardware-fp                     "6101")

	(paris-hardware-wtl3164                "6101")
	(paris-hardware-integer                "6101")
	(paris-hardware-news-scan              "6100")
	(paris-hardware-router                 "6102")
	(paris-hardware-random                 "6102")
	(paris-hardware-io                     "6102")
	(paris-hardware-twuffle		       "6103")


	(imps                                  "6102")
	(cmis-uc                               "6101")

	(paris-hardware-fft                    "6101")
	(paris-hardware-matrix-multiply        "6101")

	(paris-hardware-transcendentals        "6101")
	(paris-bitblt                          "6100")
	(paris-bitblt-lispts                   "6100")	; for C/Paris
	(paris-bitblt-tests                    "6100")
	(paris-complex                         "6100")
	(paris-rel-3                           nil)
	(paris-rel-3-defs                      "6001")
	(paris-tests                           "6100")
	(paris-vp                              "6001")

	(starlisp-simulator                    "19")

	(cm200-band-patch                      "6102")
	(lispts-definitions                    "6100")
	(lispts-implementation                 "6101")
	(lispts-imps                           "6101")
	(lispts-cmssl                          "6101")
	(lispts-c                              "6101")
	))

;; end baseline

;;;
;;; This is a list of user configurations.  The syntax is (<configuration-name> <configuration>) where
;;; <configuration> has the same format as *baseline*.
;;;

(setq *user-configurations*
      '())

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;
;;; Here is the LOAD-CM-WORLD tree
;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(def-node top-level-node "Would you like *Lisp?"
  (yes-sticky-or-no starlisp-language-node
		    no-language-node))

(def-node starlisp-language-node "Would you like the *Lisp simulator or *Lisp on top of Paris?"
  (one-of ("*Lisp simulator"       starlisp-simulator-node)
	  ("*Lisp on top of Paris" starlisp-all-node)))

(def-node cm-language-simulator-node "Choose a CM language simulator."
  (one-of ("*Lisp"           starlisp-simulator-node)))

(def-node starlisp-simulator-node ""
  (all-of starlisp-simulator))		  

(def-node starlisp-all-node ""
  (all-of no-language-node
	  starlisp-node
	  starlisp-graphics-p-node))

(def-node starlisp-graphics-p-node "Do you want *Lisp graphics?"
  (yes-sticky-or-no starlisp-graphics-node
		    nothing-node))

(def-node starlisp-graphics-node ""
  (all-of starlisp-graphics)
  :system-p :optional)

(def-node paris-fast-graph-node ""
  (all-of paris-fast-graph)
  :system-p :optional)

(def-node starlisp-node ""
  (all-of starlisp-definitions
	  starlisp-compiler
	  starlisp-interpreter
	  starlisp-library
	  paris-fast-graph-node
	  patch-starlisp)
  :system-p :optional
  )

(def-node utility-node ""
  (all-of cm-configuration
	  packages
	  utilities
	  defs-beta)
  :system-p t)
	  
(def-node no-language-node ""
  (all-of utility-node
	  macrocode-machine-node))

(def-node macrocode-machine-node "Which model CM should be supported?"
  (one-of ("CM2" hardware-macrocode-machine-node)
	  ("CM200" hardware-cm200-macrocode-machine-node)))

(def-node hardware-macrocode-machine-node ""
  (all-of uc-assembler-minimal-environment-node	;; Moved from CM-HARDWARE-NODE
	  ))

(def-node diagnostics-node ""
  (all-of diagnostics-ucode-beta		;; Only need this when diags are loaded.
	  diagnostics-microcontroller	; UCC tests
	  diagnostics-sprint		; SPRINT and WEITEK tests
	  diagnostics-chip		; From BETA-CHIP-TESTER
	  diagnostics-router-component	; From BETA-CHIP-TESTER
	  diagnostics-router-beta	; Router tests (NRT)
	  diagnostics-cmioc
	  diagnostics-framebuffer
	  diagnostics-system		; From BETA-CHIP-TESTER
	  verifiers-router		;; verifiers-p-node
	  verifiers-float
	  diagnostics-manufacturing	;; manufacturing-diagnostics-p-node
	  )
  :system-p :optional)

(def-node diagnostics-p-node "Do you want the diagnostics? (Please say Yes.)"
  (yes-sticky-or-no diagnostics-node
		    nothing-node))

(def-node graphics-node ""
  (all-of clx-x11r4
	  cmsr
	  generic-display
	  generic-mouse
	  patch-viz)
  :system-p :optional)

(def-node graphics-p-node "Do you want the Generic Display software?"
  (yes-sticky-or-no graphics-node
		    nothing-node))

(def-node hardware-node ""
  (all-of hardware-defs
	  hardware-vmefebi
	  hardware-bibi
	  hardware-hbi
	  ;;hardware-nexus
	  hardware-fifo				;; FIFO must load before NEXUS
	  hardware-nexus
	  hardware-beta
	  hardware-sequencer
	  hardware-error
	  hardware-diagnostics
	  hardware-nexus-diagnostics)
  :system-p t)

(def-node cmfs-node ""
  (all-of cmfs-library)
  :system-p :optional)

(def-node cmfs-p-node "Do you want Datavault support?"
  (yes-sticky-or-no cmfs-node
		    nothing-node))

(def-node paris-vp-node ""
  (all-of paris-vp)
  :system-p t)

(def-node minimal-assembler-node ""
  (all-of uc-assembler-beta-minimal)
  :system-p t)

(def-node assembler-node ""
  (all-of uc-assembler-beta
	  min-mic
	  mop-beta)
  :system-p :optional)

(def-node uc-assembler-minimal-environment-node ""
  (all-of minimal-assembler-node
	  hardware-node			;we can load the minimal assembler only on the cm-hardware
	  assembler-node
	  paris-vp-node
	  macrocode-cm2-paris
	  paris-hardware-node
	  graphics-p-node
	  cmfs-p-node
	  diagnostics-p-node
	  patch-paris))

(def-node paris-hardware-node ""
  (all-of paris-hardware-common
	  paris-hardware-mechanisms
	  ;;imps
	  paris-hardware-sprint
	  paris-hardware-integer		;; Will be replacing the next 3

	  imps

	  paris-hardware-fp-beta                ;; this *must* come before fp-wtl3132, fp-wtl3164, and fp
	  paris-hardware-fp-wtl3132
	  paris-hardware-fp-wtl3164
	  paris-hardware-fp                     ;; this *really* should come after the above 3 guys
	  paris-hardware-wtl3164		;; Needed for diags. Defaults to NIL

	  ;;paris-hardware-integer		;; Will be replacing the next 3

	  paris-hardware-news-scan
	  paris-hardware-router
	  paris-hardware-random
	  paris-hardware-io
	  paris-hardware-twuffle
	  ;;cmis-uc				;; Move to last
	  ;;paris-hardware-transcendentals
	  paris-hardware-fft
	  paris-hardware-matrix-multiply
	  cmis-uc				;; Move to last
	  paris-hardware-transcendentals
	  paris-complex
	  paris-rel-3
	  paris-bitblt
	  boot-beta
	  cmfb				; This must follow boot - moose Mon Jun 26 1989
	  )
  :system-p t)


(def-node nothing-node ""
  (nothing))

(def-node hardware-cm200-macrocode-machine-node ""
  (all-of hardware-macrocode-machine-node
	  cm200-node))

(def-node cm200-node ""
  (all-of cm200-band-patch)
  :system-p t)
