#ifndef _ATTACH_H_
#define _ATTACH_H_
/*****************************************************************************
*         Copyright 1991 Thinking Machines Corporation, Inc.		     *
*	      of Cambridge, Mass.  All rights reserved.			     *
*									     *
*  This notice is intended as a precaution against inadvertent publication   *
*  and does not constitute an admission or acknowledgement that publication  *
*  has occurred or constitute a waiver of confidentiality.		     *
*									     *
*  Connection Machine software is the proprietary and confidential property  *
*  of Thinking Machines Corporation.					     *
*****************************************************************************/

#if !defined(lint) && !defined(c_star) && !defined(__SABER__) && !defined(LC)
static char rcsid_attach_h[] = 
    "$Id: attach.h,v 1.8 1991/10/01 04:30:46 sean Rel $";
#endif

#define CM_PCOUNT_MAXIMUM	64 * 1024
#define CM_MSIZE_MAXIMUM	4 * (1024 * 1024)
/*
 * The largest interface-maximum is not (power-of-two)-1, like you'd
 * expect, but (power-of-two)-2.
 *
 * The reason for this is:
 *	   	
 *	0 is used to encode ANY interface in the bit-field (dictated by
 *	  the fact that the user doesn't have to say anything in
 *	  particular when they don't care about interfaces).
 *	BUT 0 is a legitimate selection, so interface-maximum + 1 is the
 *	  highest number that can be encoded in our selection of bits --
 *	  i.e., interface-maximum + 1 = power-of-two - 1.
 *
 */
#define CM_INTERFACE_MAXIMUM	6

/*
 * arguments to CM_attach_to() which select sequencer allocations, etc.
 */

/*
 * wait for the interface to become available (1 bit)
 */
#define CMA_W_SHIFT	0
#define CMA_W_MASK	1
#define CMA_WAIT	1

/*
 * memory size (64K, 256K, 1M, 4M, any (=0), plus a bit to indicate that
 * larger sizes are NOT acceptable) (4 bits)
 */
#define CMA_MSHIFT	1
#define CMA_MMASK	(0x7 << CMA_MSHIFT)

#define CMA_M64K	(1 << CMA_MSHIFT)
#define CMA_M64		CMA_M64K

#define CMA_M256K	(2 << CMA_MSHIFT)
#define CMA_M256	CMA_M256K

#define CMA_M1M		(3 << CMA_MSHIFT)
#define CMA_M1		CMA_M1M

#define CMA_M4M 	(4 << CMA_MSHIFT)
#define CMA_M4		CMA_M4M

/*
 * translate the memory bits into a size:
 *
 * size				bits	(2*bit)-1
 *	  
 * 64K	= 2^16	= 2^(15+1)	1	1
 * 256K = 2^18	= 2^(15+3)	2	3
 * 1M	= 2^20	= 2^(15+5)	3	5
 * 4M	= 2^22	= 2^(15+7)	4	7
 */
#define CMA_MSIZE(bits)	\
	(1<<(((((bits & CMA_MMASK)>>CMA_MSHIFT) * 2) - 1) + 15))

/*
 * translate a size into the proper bits.
 */
#define CMA_MBITS(size) \
	(((((bit_length(size) - 15) + 1) / 2) << CMA_MSHIFT) & CMA_MMASK)

#define CMA_MEXACT 	(8 << CMA_MSHIFT)

/*
 * floating point (none, 32bit, 64bit, any) (2 bits)
 */
#define CMA_FPU_SHIFT	(CMA_MSHIFT + 4) /* (5) */
#define CMA_FPU_MASK	(0x3 << CMA_FPU_SHIFT)
		
#define CMA_FPU_NONE	(1 << CMA_FPU_SHIFT)
#define CMA_FPU_32	(2 << CMA_FPU_SHIFT)
#define CMA_FPU_64	(3 << CMA_FPU_SHIFT)

/*
 * devices wanted (framebuffer, datavault, 3 spares) (5 bits)
 */
#define CMA_DEV_SHIFT	(CMA_FPU_SHIFT + 2) /* (7) */
#define CMA_DEV_MASK	(0xf << CMA_DEV_SHIFT)
		

#define CMA_FRAMEBUFFER	(1 << CMA_DEV_SHIFT)
#define CMA_DATAVAULT	(2 << CMA_DEV_SHIFT)
#define CMA_DEV_SPARE1	(4 << CMA_DEV_SHIFT)
#define CMA_DEV_SPARE2	(8 << CMA_DEV_SHIFT)
	
/*
 * timeshared-only, exclusive-only, don't care (2 bits)
 */

#define CMA_TS_SHIFT	(CMA_DEV_SHIFT + 4) /* (11) */
#define CMA_TS_MASK	(0x3 << CMA_TS_SHIFT)

#define CMA_TIMESHARED	(1 << CMA_TS_SHIFT)
#define CMA_EXCLUSIVE	(2 << CMA_TS_SHIFT)
		
/*
 * sequencer count: 1, 2, or 4 sequencers (2 bits)
 */
#define CMA_UCCS_SHIFT	(CMA_TS_SHIFT + 2) /* (13) */
#define CMA_UCCS_MASK	(0x7 << CMA_UCCS_SHIFT)

#define CMA_UCCS_1	(1 << CMA_UCCS_SHIFT)
#define CMA_UCCS_2	(2 << CMA_UCCS_SHIFT)
#define CMA_UCCS_4	(4 << CMA_UCCS_SHIFT) /* XXX -why not 3<<UCCS_SHIFT? */

/*
 * specific sequencer set: 0, 1, 2, 3, 0-1, 2-3, 0-3 (4 bits)
 */
#define CMA_UCC_SET_SHIFT (CMA_UCCS_SHIFT + 3) /* (16) */
#define CMA_UCC_SET_MASK  (0xf << CMA_UCC_SET_SHIFT)

#define CMA_UCC0	(1 << CMA_UCC_SET_SHIFT)
#define CMA_UCC1	(2 << CMA_UCC_SET_SHIFT)
#define CMA_UCC2	(4 << CMA_UCC_SET_SHIFT)
#define CMA_UCC3	(8 << CMA_UCC_SET_SHIFT)
#define CMA_UCC0_and_1	(CMA_UCC0 + CMA_UCC1)
#define CMA_UCC2_and_3	(CMA_UCC2 + CMA_UCC3)
#define CMA_UCC0_to_3	(CMA_UCC0 + CMA_UCC1 + CMA_UCC2 + CMA_UCC3)

/*
 * macros to go back and forth between a sequencer set as returned by
 * CM_sequencer_set, and the CMA_UCCx format expected by CM_attach_to()
 */
#define CMA_BITS_TO_UCCS(cma_ucc) \
	  (((cma_ucc) & CMA_UCC_SET_MASK) >> CMA_UCC_SET_SHIFT)

#define CMA_UCCS_TO_BITS(ucc) \
	  ((ucc) << CMA_UCC_SET_SHIFT)

/*
 * specific number of processors: 512, 1K, 4K, 8K, 16K, 32K, 64K, any,
 * plus a bit that indicates that larger sizes are NOT acceptable
 * least (5 bits) 
 */

#define CMA_PSHIFT	(CMA_UCC_SET_SHIFT + 4) /* (20) */
#define CMA_PMASK	(0xf << CMA_PSHIFT)

#define CMA_P512	(1 << CMA_PSHIFT)
#define CMA_P1K		(2 << CMA_PSHIFT)
#define CMA_P2K		(3 << CMA_PSHIFT)
#define CMA_P4K		(4 << CMA_PSHIFT)
#define CMA_P8K		(5 << CMA_PSHIFT)
#define CMA_P16K	(6 << CMA_PSHIFT)
#define CMA_P32K	(7 << CMA_PSHIFT)
#define CMA_P64K	(8 << CMA_PSHIFT)

/*
 * Translate a CMA_P... value into the number of processors it represents.
 * 
 * size		bits	bits + 8
 * 512 is 2^9,  1	9
 * 1K  is 2^10, 2	10
 * ...		...	...	
 * 32K is 2^15, 7	15
 * 64K is 2^16, 8	16
 */
#define CMA_PCOUNT(bits) \
  	(1 << (((bits & CMA_PMASK)>>CMA_PSHIFT) + 8))

/*
 * translate a processor count into the proper bits...
 */
#define CMA_PBITS(size) \
	  ((bit_length(size) - 8) << CMA_PSHIFT)

/*
 * Only an exact match on processor count is acceptable.
 */
#define CMA_PEXACT	(0x10 << CMA_PSHIFT)

/*
 * use the direct interface instead of the generic interface (1 bit)
 */
#define CMA_IDSHIFT	(CMA_PSHIFT + 5) /* (25) */
#define CMA_IDMASK	(1 << CMA_IDSHIFT)

#define CMA_IGENERIC	0
#define CMA_IDIRECT	(1 << CMA_IDSHIFT)

/*
 * specific interface to use (0-4 (could be 0-6), or any) (3 bits)
 */
#define CMA_ISHIFT	(CMA_IDSHIFT + 1) /* (26) */
#define CMA_IMASK	(0x7 << CMA_ISHIFT)

#define CMA_I(n)	((n + 1) << CMA_ISHIFT)
#define CMA_I0		CMA_I(0)
#define CMA_I1  	CMA_I(1)
#define CMA_I2  	CMA_I(2)
#define CMA_I3  	CMA_I(3)
#define CMA_I4  	CMA_I(4)
#define CMA_I5  	CMA_I(5)

#define CMA_BITS_FROM_INTERFACE(n) 	CMA_I(n)
/*
 * ``Any'' gets turned into -1 this way...
 */
#define CMA_INTERFACE_FROM_BITS(bits) (((bits & CMA_IMASK) >> CMA_ISHIFT) - 1)

/*
 * specific species: CMA_TYPE_DEFAULT (expressed as 0 in this field, of
 * course), CM2, CM3, CM4, CM5, CM6, CM7, CM8 --- three bits).
 */
#define CMA_TSHIFT	(CMA_ISHIFT + 3) /* (29) */
#define CMA_TMASK	(0x3 << CMA_TSHIFT)
#define CMA_TDEFAULT	(0 << CMA_TSHIFT)
#define CMA_CM2		(1 << CMA_TSHIFT) /* bit 29 */
#define CMA_CM200	(2 << CMA_TSHIFT) /* bit 30 */

/*
 * probably don't want to use bit 31, for fear of getting bitten by
 * sign-extension...
 */

#endif /* _ATTACH_H_ */
