/* $Id: paris-internal.h,v 1.17 1991/11/21 03:37:02 dm Exp $ */
#ifndef _PARIS_INTERNAL_
#define _PARIS_INTERNAL_
/*****************************************************************************
*         Copyright 1989,1990 Thinking Machines Corporation, Inc.	     *
*	      of Cambridge, Mass.  All rights reserved.			     *
*									     *
*  This notice is intended as a precaution against inadvertent publication   *
*  and does not constitute an admission or acknowledgement that publication  *
*  has occurred or constitute a waiver of confidentiality.		     *
*									     *
*  Connection Machine software is the proprietary and confidential property  *
*  of Thinking Machines Corporation.					     *
*****************************************************************************/

/*
 * Internal PARIS header file.
 * For use by CMIS and by paris.
 */

#ifdef sparc
#include <alloca.h>
#endif

#ifndef _LCHEADER_
#include <cm/cmtypes.h>
#include <cm/paris.h>
#else _LCHEADER_
/* need some #defines from paris.h */
#define CM_add_offset_to_field_id(field_id,offset) ((field_id)+(offset))
#endif _LCHEADER_

#include <cm/field-decoding.h>

/*
 * Purely internal well known constants
 */

extern int _CMI_uc_scratch_ram_limit;   /* autosized physical SRAM size in words */
extern int _CMI_default_uc_stack_size;  /* default size for control stack */
extern int _CMI_imp_store_start_address; /* start of imp store (after heap) */

extern int _CMI_wtl3132_p;
extern int _CMI_wtl3164_p;
extern int _CMI_amd29326_p;
extern int _CML_use_cml3132_microcode_p;
extern int _CML_use_cml3164_microcode_p;
extern int _CMI_check_overlapping_fields;

#define _CMI_physical_number_of_processors_limit CM_physical_cube_address_limit

/*
 * Some generally useful macros.
 */
#define min(a, b) (((a)<(b))?(a):(b))
#define max(a, b) (((a)>(b))?(a):(b))

#define ALL_ONES(nbits) (~(0xFFFFFFFF << (nbits)))

/*
 * some useful data objects
 */

extern int errno;		/* UNIX errno */

/*
 * Some FIFO macros and function defs
 */

/*
** READING the fifo. Generally you should call
**
**     _CMI_read_fifo_32(),
**     _CMI_read_fifo_unsigned(),
**     _CMI_read_fifo_low() or
**     _CMI_read_fifo_high().
**
** They all wait for data if necessary.
**
** The R5.2 macros READ_FIFO() and READ_FIFO_UNSAFELY() are no longer 
** provided for brave souls.
*/

int _CMI_wait_until_read_data_available();

#define _CMI_febi_input_fifo_half_empty_p() (1)	     /* always true */
#define _CMI_wait_until_febi_input_fifo_half_empty() /* do nothing */

extern long _CMI_read_vfifo_32();
extern long _CMI_read_rfifo_32();


#define _CMI_wait_until_febi_output_fifo_not_empty \
    _CMI_wait_until_read_data_available

/*
** Machine independent Read routines
*/

# ifdef vax
#define _CMI_read_fifo_32() \
    ((_CMI_fifo_mapped_p) ? _CMI_read_rfifo_32() \
                          : _CMI_read_vfifo_32())
#else
#define _CMI_read_fifo_32() _CMI_read_rfifo_32() 
#endif

#define _CMI_read_fifo_unsigned(length) \
    ((unsigned)((length > 32) \
		? CM_panic("CMI_read_fifo_unsigned length > 32") \
		: _CMI_read_fifo_32()))

#define _CMI_read_fifo_fixnum \
    _CMI_read_fifo_unsigned

#define _CMI_read_fifo_low() \
    ((_CMI_latched_fifo_data = _CMI_read_fifo_32()) & 0xFFFF)

#define _CMI_read_fifo_high() \
    ((_CMI_latched_fifo_data >> 16) & 0xFFFF)


/*
** Global variables
*/

extern int
    _CMI_ififo_room,		/* int: number of free slots in IFIFO	*/
    _CMI_fifo_mapped_p,		/* boolean: Use the REAL fifo		*/
    _CMI_timesharing,		/* boolean: Do TS memory management	*/
    _CMI_fake_timesharing,	/* boolean: TS memory management without daemon */
    CMTS_ProcessPort,		/* int: Timesharing daemon present if > 0	*/
    _CMI_excl_mode;		/* boolean: We're only user of CM (OK to bash stuff) */


extern unsigned long
  * _CMI_ififo_addr,		/* Address of real input FIFO		*/
  * _CMI_vfifo_base,		/* the base of the buffer		*/
  * _CMI_vfifo_bot,		/* the next slot to go to FIFO		*/
  * _CMI_vfifo_top,		/* the next free slot in buffer		*/
  * _CMI_vfifo_ibound,		/* the microcode instruction boundary	*/
  * _CMI_vfifo_end;		/* the end of the buffer + 1		*/

extern long
    _CMI_latched_fifo_data;	/* for read_fifo_{low,high} 		*/



/*
** Data manipulation macros
*/

#define _CMI_32_16_16(low,high) \
    (((high) << 16) | ((low) & 0xFFFF))

#define _CMI_32_12_20(low,high) \
    (((high) << 20) | ((low) & 0xFFFFF))

/*
** External routines
*/

int _CMI_flush_vfifo_buffer();
int _CMI_wait_for_room_in_ififo();

/*
** FIFO state checking
*/


/*
** Exported write macros
*/

#ifdef vax
#define _CMI_write_fifo_32_no_check(data) \
    ((_CMI_fifo_mapped_p) ? _CMI_write_rfifo_32_no_check(data) \
                      : _CMI_write_vfifo_32_no_check(data))
#else
#define _CMI_write_fifo_32_no_check(data) _CMI_write_rfifo_32_no_check(data) 
#endif

#define _CMI_write_fifo_fixnum(data, length) \
    (_CMI_write_fifo_32(data))

#define _CMI_write_fifo_fast \
    _CMI_write_fifo

#define _CMI_write_fifo_12_20_fast \
    _CMI_write_fifo_12_20

#define _CMI_write_fifo_fixnum_fast \
    _CMI_write_fifo_fixnum

#define _CMI_write_fifo_12_20(low,high) \
    {register int _fifo_temp_ = _CMI_32_12_20((low),(high));\
    _CMI_write_fifo_32(_fifo_temp_);}

#define _CMI_write_fifo(low, high) \
    {register int _fifo_temp_ = _CMI_32_16_16((low),(high));\
    _CMI_write_fifo_32(_fifo_temp_);}


#ifdef vax
#define _CMI_check_fifo_room(n) \
    if (_CMI_fifo_mapped_p) {\
       _CMI_check_rfifo_room(n); \
    } else { \
       _CMI_check_vfifo_room(n); \
    }   

#define _CMI_write_fifo_12_20_no_check(low,high) \
    {register int _fifo_temp_ = _CMI_32_12_20((low),(high));\
     if (_CMI_fifo_mapped_p) \
	 _CMI_write_rfifo_32_no_check(_fifo_temp_);\
     else \
         _CMI_write_vfifo_32_no_check(_fifo_temp_);}

#define _CMI_write_fifo_no_check(low,high) \
    {register int _fifo_temp_ = _CMI_32_16_16((low),(high));\
     if (_CMI_fifo_mapped_p) \
	 _CMI_write_rfifo_32_no_check(_fifo_temp_);\
     else \
         _CMI_write_vfifo_32_no_check(_fifo_temp_);}

#define _CMI_write_fifo_32(data) \
    ((_CMI_fifo_mapped_p) ? _CMI_write_rfifo_32(data) \
                          : _CMI_write_vfifo_32(data))

#else /* not vax */
#define _CMI_check_fifo_room(n) _CMI_check_rfifo_room(n)


#define _CMI_write_fifo_12_20_no_check(low,high) \
    {register int _fifo_temp_ = _CMI_32_12_20((low),(high));\
	 _CMI_write_rfifo_32_no_check(_fifo_temp_);}

#define _CMI_write_fifo_no_check(low,high) \
    {register int _fifo_temp_ = _CMI_32_16_16((low),(high));\
	 _CMI_write_rfifo_32_no_check(_fifo_temp_);}

#define _CMI_write_fifo_32(data) _CMI_write_rfifo_32(data) 

#endif /* not vax */

/*
** Direct FIFO access (rfifo) specific
*/

#define _CMI_write_rfifo_32(data) \
    (((--_CMI_ififo_room <= 0) ? (_CMI_wait_for_room_in_ififo(1)) : 0) , \
      ((*_CMI_ififo_addr = (data)),0))

#define _CMI_write_rfifo_32_no_check(data) \
    ((*_CMI_ififo_addr = data),0)

#define _CMI_check_rfifo_room(n) \
    if ((_CMI_ififo_room -= (n)) <= 0) _CMI_wait_for_room_in_ififo(n)

/*
**  Buffered FIFO access (vfifo) specific
*/

#define _CMI_check_vfifo_room(n) \
    if (((int)_CMI_vfifo_end - (int)_CMI_vfifo_top) <= ((n) * sizeof (int))) \
        _CMI_flush_vfifo_buffer(2)

#define _CMI_write_vfifo_32(data) \
    (((_CMI_vfifo_top >= _CMI_vfifo_end) ? (_CMI_flush_vfifo_buffer(0)) : 0), \
     ((*_CMI_vfifo_top++ = (data)), 0))

#define _CMI_write_vfifo_32_no_check(data) \
    (*_CMI_vfifo_top++ = (data))

/*
** Microcode boundary marking
*/

#define _CMI_start_uc_call() \
    (_CMI_vfifo_ibound = _CMI_vfifo_top)

#define _CMI_end_uc_call(npushes) (0)


/*
 * Macros for float conversion.
 */

#ifdef vax

#define _CMI_f_to_ieee_single_16(number,low,high) \
do { \
  unsigned _cvt_temp_; \
  _CMI_vax_double_to_ieee (&_cvt_temp_,(number),23,8); \
  low = _cvt_temp_&0xffff; high = _cvt_temp_ >> 16; \
} while (0)

#define _CMI_f_to_ieee_single_32(number,bits) \
do { \
  bits = _CMI_number_to_ieee_single_float ((number),23,8); \
} while (0)

#define _CMI_f_to_ieee_double_16(number,ll,lh,hl,hh) \
do { \
  unsigned _cvt_temp_[2]; \
  _CMI_vax_double_to_ieee (_cvt_temp_,(number),52,11); \
  ll = _cvt_temp_[0]&0xffff; lh = _cvt_temp_[0] >> 16; \
  hl = _cvt_temp_[1]&0xffff; hh = _cvt_temp_[1] >> 16; \
} while (0)

#define _CMI_f_to_ieee_double_32(number,low,high) \
do { \
  unsigned _cvt_temp_[2]; \
  _CMI_vax_double_to_ieee (_cvt_temp_, (number),52,11); \
  low = _cvt_temp_[0]; high = _cvt_temp_[1];\
} while (0)

#endif vax

#ifdef sparc

struct _CMI_float_conversion_word {
  unsigned short hi, lo;
};

#define _CMI_f_to_ieee_single_16(number,low,high) \
do { \
  register struct _CMI_float_conversion_word *_cvt_temp_; float _cvt_temp_f = number;\
  _cvt_temp_ = (struct _CMI_float_conversion_word *) &_cvt_temp_f;\
  low = _cvt_temp_->lo; high = _cvt_temp_->hi; \
} while (0)

#define _CMI_f_to_ieee_single_32(number,bits) \
do { \
  float _cvt_temp_f = number; \
  bits = * (unsigned *) &_cvt_temp_f; \
} while (0)

struct _CMI_double_conversion_word {
  unsigned short hhw, hlw, lhw, llw;
};

#define _CMI_f_to_ieee_double_16(number,ll,lh,hl,hh) \
do { \
  register struct _CMI_double_conversion_word *_cvt_temp_; double _cvt_temp_d = number; \
  _cvt_temp_ =  (struct _CMI_double_conversion_word *) &_cvt_temp_d; \
  ll = _cvt_temp_->llw; lh = _cvt_temp_->lhw; hl = _cvt_temp_->hlw; hh = _cvt_temp_->hhw; \
} while (0)

struct _CMI_double_conversion_long {
  unsigned hi, lo;
};

#define _CMI_f_to_ieee_double_32(number,low,high) \
do { \
  register struct _CMI_double_conversion_long *_cvt_temp_; double _cvt_temp_d = number; \
  _cvt_temp_ = (struct _CMI_double_conversion_long *) &_cvt_temp_d; \
  low = _cvt_temp_->lo; high = _cvt_temp_->hi; \
} while (0)

#endif sparc
/*
 * some essential function definitions
 */
double _CMI_ieee_single_f_to_number();
double _CMI_ieee_f_to_number();
double OCM_f_read_from_processor();
double _CMI_general_f_read_from_processor();
double _CMI_global_f_add();
double OCM_global_f_max();
double OCM_global_f_min();
double _CMI_global_f_max_internal_interpret();
double _CMI_global_f_min_internal_interpret();
double _OCMI_wtl3132_global_f_add();
double _OCMI_wtl3132_global_f_multiply();

/*
 * MINAME mechanism (code in miname.c). The following structure is used by miname
 * to store entrypoint information for the current control store. DO NOT ACCESS
 * the structure directly, use the accessor macros provided below.
 */

#ifndef _LCHEADER_

/* typedef for an MINAME "name" */

#define P_MI_NAME_SIZE 63	/* Length of mi_names (rest ignored) */
				/* use multiple of 4 less 1 for efficiency */
typedef char mi_name[P_MI_NAME_SIZE+1]; /* MI_NAME with room for null */

/* structure used in miname data base hash table. DO NOT acess directly, use
   accessor macros below */

struct mi_name_table_entry		/* MI Table Entry */
    {
    struct mi_name_table_entry *next; /* Ptr to next in hash list */
    mi_name name;		/* mi_name name */
    unsigned int properties;
    unsigned int dispatch_index;     /* index in dispatch table if fe-callable */
    unsigned int inline_entrypoint; 
    unsigned int after_fifo_entrypoint;
    unsigned int first_uc_loc;
    unsigned int last_uc_loc;
    };

/* accessor macros for the attributes word */

#define get_mi_name(mi) \
  ( mi->name )

#define get_mi_inline_entrypoint(mi) \
  ( mi->inline_entrypoint)

#define get_mi_after_fifo_entrypoint(mi) \
  ( mi->after_fifo_entrypoint)

#define get_mi_first_uc_loc(mi) \
  ( mi->first_uc_loc)

#define get_mi_last_uc_loc(mi) \
  ( mi->last_uc_loc)

#define get_mi_counted_args(mi) \
  ( (mi->properties >> 0) & 0x1F )

#define get_mi_arg1_offset(mi) \
  ( (mi->properties >> 5) & 0x1F )

#define get_mi_arg_count(mi) \
  ( (mi->properties >> 10) & 0x1F )

#define get_mi_arg1_counter(mi) \
  ( mi->properties & (1 << 15) )

#define get_mi_callable_with_reg_args(mi) \
  ( mi->properties & (1 << 16) )

#define get_mi_inline_callable(mi) \
  ( mi->properties & (1 << 17) )

#define get_mi_prepipe(mi) \
  ( mi->properties & (1 << 19) )

/* Routines for lookup up minames from properties (slow) */

struct mi_name_table_entry *mi_name_lookup(/*miname*/);
struct mi_name_table_entry *mi_name_from_inline_entrypoint(/*entrypoint*/);
struct mi_name_table_entry *mi_name_from_pc(/*pc*/);
struct mi_name_table_entry *mi_name_from_dispatch_index(/*dispatch_index*/);

#endif _LCHEADER_

/*
 * for some brokenness
 */
#define SYS_set_aref(new, array, index) ((array)[(index)] = (new))
#define LRS_set_aref(new, array, index) ((array)[(index)] = (new))

#ifdef sun
#define _CMI_front_end_ordering _CMI_msb_first
#endif
#ifdef vax
#define _CMI_front_end_ordering _CMI_lsb_first
#endif

#define _CMFB_number_of_sequencers _CMI_number_of_sequencers

#ifndef _LCHEADER_
/*
 * Hardware interface stuff
 */
typedef enum {
    _CMI_mask_errors, 
    _CMI_enable_errors, 
    _CMI_enable_all_errors
    } _CMI_error_modes_t;

extern _CMI_error_modes_t _CMI_current_error_mode;
#endif

#ifdef LC
/*
 * To get all output to go to CMI_error_stream
 * (this way it can be captured)
 */
#define printf CMI_printf
#endif LC

#endif _PARIS_INTERNAL_

