
/*****************************************************************************
*  Copyright (c) 1987, 1988, 1989, 1990 Thinking Machines Corporation, Inc., *
*		of Cambridge, Mass.   All rights reserved.		     *
*									     *
*  This notice is intended as a precaution against inadvertent publication   *
*  and does not constitute an admission or acknowledgement that publication  *
*  has occurred or constitute a waiver of confidentiality.		     *
*									     *
*  Connection Machine software is the proprietary and confidential property  *
*  of Thinking Machines Corporation.					     *
*****************************************************************************/

#ifndef _CMTYPES_
#define _CMTYPES_

#if !defined(lint) && !defined(c_star) && !defined(LC) && !defined(__SABER__)
static char rcsid_cmtypes[] = "$Id: cmtypes.h,v 1.11 1991/11/21 03:36:48 dm Exp $";
#endif

/*
 * A bit address in CM processor memory.
 */
#ifdef c_star
typedef void void:: * CM_memaddr_t ;
typedef void void:: * CM_field_id_t ;
#else
#ifdef cstar
typedef void:void *CM_memaddr_t ;
typedef void:void *CM_field_id_t;
#else
typedef unsigned long CM_memaddr_t ;
typedef int           CM_field_id_t;
#endif
#endif

/*
 * The send address of a CM processor.  `cubeaddr' is a back-compatible
 * synonym.
 */
#ifndef c_star
typedef unsigned long CM_sendaddr_t;
typedef unsigned long CM_cubeaddr_t;
#else
typedef domain void * CM_sendaddr_t;
typedef domain void * CM_cubeaddr_t;
#endif

/*
 * A CM_memaddr which points to a stripe of processor send addresses
 * (see CM_send()).
 */
#ifndef c_star
typedef unsigned long CM_sendaddr_stripe_t;
typedef unsigned long CM_cubeaddr_stripe_t;
#else
typedef domain void * void:: * CM_sendaddr_stripe_t;
typedef domain void * void:: * CM_cubeaddr_stripe_t;
#endif

/*
 * A CM_memaddr which points to a "stripe" of "virtual memory" addresses.
 * A virtual memory address consists of a processor send address
 * and a bit address within that processor (see CM_store()).
 */
#ifndef c_star
typedef unsigned long CM_virtaddr_stripe_t;
#else
typedef void poly * void:: * CM_virtaddr_stripe_t;
#endif

/* 
 * A VP-set id type 
 */
#ifdef c_star
typedef void void:: * CM_vp_set_id_t ;
#else
#ifdef cstar
typedef shape CM_vp_set_id_t ;
#else
typedef int CM_vp_set_id_t;
#endif
#endif

/*
 * The simulated stack register structure.
 */
typedef struct CM_stack_regs_t {
	CM_memaddr_t pointer;
	CM_memaddr_t limit;
	CM_memaddr_t upper_bound;
} CM_stack_regs_t;

/*
 * The structure returned by a CM_stop_timer calls.
 */
typedef struct CM_timeval {
	   double cmtv_real;		/* wall clock time */
	   double cmtv_cm;		/* CM busy time */
	   double cmtv_fe_user;		/* front end user time */
	   double cmtv_fe_sys;		/* front end system time */
	   double cmtv_cm_elapsed;	/* Elapsed CM time */
} CM_timeval_t;

/*
 * some types for PARIS arguments
 */

/* CM complex type */ 
typedef struct CM_complex {
  double realpart;
  double imagpart;
} CM_complex_t;

typedef int CM_array_format_t;

#define CM_no_axis -1

typedef int CM_axis_order_t;
#define CM_news_order 0
#define CM_send_order 1
#define CM_serial_order 2
#define CM_fb_order 3           /* historical */
#define CM_framebuffer_order 3  /* like the LISP keyword */

typedef int CM_communication_direction_t;
#define CM_upward 0
#define CM_downward 1

typedef int CM_scan_inclusion_t;
#define CM_exclusive 0
#define CM_inclusive 1

typedef int CM_segment_mode_t;
#define CM_none 0
#define CM_segment_bit 1
#define CM_start_bit 2


typedef struct CM_axis_descriptor {
  unsigned length;
  int spare1;
  unsigned weight;
  CM_axis_order_t ordering;
  unsigned char on_chip_bits;
  unsigned char on_chip_pos;
  unsigned char off_chip_bits;
  unsigned char off_chip_pos;
  int spare2;
  unsigned vp_ratio;
  unsigned vp_ratio_multiplier;
  unsigned char address_length;
  unsigned virtual_bitmask;
  unsigned short vp_ratio_shift;
  unsigned short vp_ratio_multiplier_shift;
  unsigned short n_outer_orthogonal;
  unsigned short onchip_offchip;
} *CM_axis_descriptor_t;

typedef struct _CMI_detailed_interned_axis {
  unsigned length;
  int spare1;
  unsigned weight;
  CM_axis_order_t ordering;
  unsigned char on_chip_bits;
  unsigned char on_chip_pos;
  unsigned char off_chip_bits;
  unsigned char off_chip_pos;
  int spare2;
} *_CMI_detailed_interned_axis_t;

typedef struct _CMI_interned_structure {
  int type;
  int (*simple_array);
  _CMI_detailed_interned_axis_t (*detailed_array);
} *_CMI_interned_structure_t;

typedef struct CM_geometry_id {
  int free_p;
  int id;
  int rank;
  unsigned char address_length;
  CM_axis_descriptor_t (*descriptors);
  int vp_ratio;
  unsigned char purely_virtual_address_length;
  unsigned total_number_of_processors;
  _CMI_interned_structure_t interned;
  int vp_set;
  int reference_count;
  unsigned serial_number;
} *CM_geometry_id_t;


typedef unsigned long CM_multicoord_t ;

/*
 * Type definitions for the FFT.
 * These are the symbols used by the Paris FFT, as opposed to the newer
 * CMSSL FFT. These support users of the older FFT who used the older
 * symbols. These were forgotten in 6.0 beta. They must remain forever.
 */

typedef int FFT_fft_integer_t;
typedef int FFT_boolean_t;
typedef int FFT_field_t;

typedef int FFT_op_t;
typedef int FFT_cm_order_t;
typedef int FFT_bit_order_t;
typedef int FFT_scale_t;

#define FFT_nop		 	0
#define FFT_f_xform		1
#define FFT_i_xform 		2

#define FFT_default_124		0
#define FFT_send		1
#define FFT_news		2

#define FFT_normal		0
#define FFT_bit_reversed	1		

#define FFT_noscale		0
#define FFT_scale_sqrt		1
#define FFT_scale_n		2

typedef int *FFT_ops_t ;
typedef int *FFT_cm_orders_t ;
typedef int *FFT_bit_orders_t ;
typedef int *FFT_scales_t ;

typedef FFT_field_t *FFT_on_twiddle_t;
typedef FFT_fft_integer_t *FFT_on_stride_t;
typedef FFT_fft_integer_t *FFT_shuffle_t;
typedef CM_axis_descriptor_t *FFT_axes_t;

typedef struct FFT_fft_setup {
  FFT_on_twiddle_t on_twiddles;
  FFT_field_t off_twiddles;
  FFT_shuffle_t forward_shuffle;
  FFT_shuffle_t back_shuffle;
  FFT_fft_integer_t rank;
  CM_geometry_id_t geometry;
  FFT_fft_integer_t vp_ratio;
  FFT_axes_t axes;
  FFT_fft_integer_t longest_axis;
  FFT_on_stride_t on_stride;
  FFT_fft_integer_t howlong_shuffle;
  int spare1;
  int spare2;
  int spare3;
} *FFT_fft_setup_t;

#endif /* _CMTYPES_ */
