/*	@(#)pw_util.h 1.3 83/08/25 SMI	*/

/*
 * Copyright (c) 1983 by Sun Microsystems, Inc.
 */

/*
 * Pw_util.h is a collection of utilities that implementors of
 * pixwin.h specified routines should use.
 */

/*
 * Loop on clipping and call rect clipping routines.
 * Users of this macro operate upon rintersect.
 */
#define	pw_begincliploop(pw, rdest, rintersect) \
	{ register struct rectnode *rn; \
          for (rn = (pw)->pw_clipdata->pwcd_clipping.rl_head; \
	  rn; rn = rn->rn_next) { \
		/* \
		 * Not doing: \
		 * rl_rectoffset(&(pw)->pw_clipping, &rn->rn_rect, &rtemp); \
		 * cause assuming all clipping is normalized. \
		 */ \
		if (rect_intersectsrect((rdest), &rn->rn_rect)) { \
			rect_intersection((rdest), &rn->rn_rect, (rintersect));

/*
 * Terminates pw_begincliploop
 */
#define	pw_endcliploop()\
		}\
	}\
	}

#ifdef	cplus
/*
 * C Library routine specifically relating to pixel device function
 * implementation.
 */

/*
 * Make rl_fixup set to the clipped part of the bounding box of pw->pw_clipping
 */
void	pw_initfixup(struct pixwin *pw, struct rectlist *rl_fixup);

#endif

