/*	@(#)wmgr.h 1.5 84/01/08 SMI	*/

/*
 * Copyright (c) 1983 by Sun Microsystems, Inc.
 */

/*
 * This header file describes the interface to a window management mechanism.
 * A menu interface to these functions is also provided.
 * Typically, a tool window is responsible for window management.
 */

/*
 * The following menu is initialized and available to a user program once
 * wmgr_setupmenu is called.  It can be stacked with over menus and
 * presented to the menu.h interface.
 */
extern	struct	menu *wmgr_toolmenu;

#define	WMGR_ICONIC	WUF_WMGR1	/* Indicates window is iconic
					   in user flags of window */
#define	WMGR_SETPOS	-1		/* Indicates "use default" in
					   wmgr_figure*rect calles */

extern	int WMGR_NEXTTOOLXOFFSET;	/* X offset between normal windows */
extern	int WMGR_NEXTTOOLYOFFSET;	/* Y offset between normal windows */
extern	int WMGR_NEXTICONXOFFSET;	/* X offset between iconic windows */
extern	int WMGR_NEXTICONYOFFSET;	/* Y offset between iconic windows */

#ifdef	cplus
/*
 * C Library routines that provide tool management and root utilities.
 */

/*
 * Routines to manage the wmgr_toolmenu.
 */
void	wmgr_setupmenu(int toolfd);
void	wmgr_handletoolmenuitem(struct menu *menu, struct menuitem *mi,
	    int toolfd, rootfd);

/*
 * Basic window management operations.
 * Move and stretch require user interaction.
 */
void	wmgr_open(int toolfd, rootfd);
void	wmgr_close(int toolfd, rootfd);
void	wmgr_move(int toolfd);
void	wmgr_stretch(int toolfd);
void	wmgr_top(int toolfd, rootfd);
void	wmgr_bottom(int toolfd, rootfd);

/*
 * Utilities
 */
void	wmgr_refreshwindow(int windowfd);
int	wmgr_confirm(int feedbackfd, char *text);
bool	wmgr_iswindowopen(int toolfd);

/*
 * Global tool position defaulting mechanism.
 */
void	wmgr_setrectalloc(int rootfd,
	    short tool_left, tool_top, icon_left, icon_top);
void	wmgr_getrectalloc(int rootfd,
	    shrot *tool_left, *tool_top, *icon_left, *icon_top);
void	wmgr_figureiconrect(int rootfd, struct *rect);
void	wmgr_figuretoolrect(int rootfd, struct *rect);

/*
 * Fork programname with otherargs.  Place its normal rect at normalrect.
 * Place its iconis rect a iconicrect.  Iconicflag indicates the original
 * state of the tool.  Positioning/state information are only hints.
 * The tool can ignore them.
 */
void	wmgr_forktool(char *programname, *otherargs, struct rect *normalrect,
	   struct rect *iconrect, int iconicflag);
#endif

