/*	@(#)video.h 1.3 84/01/30 SMI	*/

/*
 * Sun-2 video display definitions
 */

/*
 * The Sun-2 video board lives in P2 memory space.
 * Following are the physical addresses in P2 memory
 * space for the various components of the video voard.
 */
#define	VIDEO_ADDR		0xF00000	/* frame buffer */
#define	VIDEO_SIZE		0x20000		/* size of frame buffer */
#define	VIDEO_ZSCC_ADDR		0xF80000	/* UARTS */
#define VIDEO_CTRL_ADDR		0xF81800	/* video control register */

/*
 * The video memory is just memory, although it can also copy data that is
 * written to other locations.
 *
 * The A-side of the ZSCC connects to the keyboard.
 * The B-side of the ZSCC connects to the mouse.
 *
 * The video control register is arranged as shown below.
 *
 * Vc_copybase specifies the base (physical) address in main memory
 * where, if a write is done, the write is also done to the frame buffer.
 * Note that copying only works on 128K boundaries even though the base
 * address is specified in 64K units.
 */
struct	videoctl {
	unsigned vc_video_en:1;		/* Video enable */
	unsigned vc_copy_en:1;		/* Copy enable */
	unsigned vc_int_en:1;		/* Interrupt enable */
	unsigned vc_int:1;		/* Int active - r/o */
	unsigned vc_copybase:12;	/* Base addr of memory to copy from */
};
#define VIDEO_COPY_SHIFT	16	/* bits to shift base address */
