#ifndef lint
static	char sccsid[] = "@(#)panetool.c 1.12 84/02/06 SMI";
#endif

/*
 * Sun Microsystems, Inc.
 */

/*
 * 	Overview:	Pane Tool: Sample program to illustrate multiple
 *			subwindows.
 */

#include <sys/types.h>
#include <sys/time.h>
#include <signal.h>
#include <pixrect/pixrect.h>
#include <pixrect/pixfont.h>
#include <sunwindow/rect.h>
#include <sunwindow/rectlist.h>
#include <sunwindow/pixwin.h>
#include <sunwindow/win_input.h>
#include <sunwindow/win_struct.h>
#include <suntool/icon.h>
#include <suntool/tool.h>
#include <suntool/msgsw.h>
#include <suntool/menu.h>

static	int sigwinchcatcher();

static	struct tool *tool;

static	char charbuf[4];

struct	menuitem m3_items[] = { MENU_IMAGESTRING, "Menu Item", 0};
struct	menu m3_menubody = {
	    MENU_IMAGESTRING, "M3", sizeof(m3_items) / sizeof(struct menuitem), m3_items, 0, 0 };
struct	menuitem m2_items[] = { MENU_IMAGESTRING, "Menu Item", 0};
struct	menu m2_menubody = {
	    MENU_IMAGESTRING, "M2", sizeof(m2_items) / sizeof(struct menuitem),
	    m2_items, &m3_menubody, 0};
struct	menuitem m1_items[] = { MENU_IMAGESTRING, "Menu Item", 0};
struct	menu m1_menubody = {
	    MENU_IMAGESTRING, "M1", sizeof(m1_items) / sizeof(struct menuitem),
	    m1_items, &m2_menubody, 0};
struct	menu *stack1menutop = &m1_menubody;

struct	menuitem m4_items[] = { MENU_IMAGESTRING, "Menu Item", 0};
struct	menu m4_menubody = {
	    MENU_IMAGESTRING, "M4", sizeof(m4_items) / sizeof(struct menuitem),
	    m4_items, 0, 0 };
struct	menuitem m5_items[] = { MENU_IMAGESTRING, "Menu Item", 0};
struct	menu m5_menubody = {
	    MENU_IMAGESTRING, "M5", sizeof(m5_items) / sizeof(struct menuitem),
	    m5_items, &m4_menubody, 0};
struct	menuitem m6_items[] = { MENU_IMAGESTRING, "Menu Item",	0};
struct	menu m6_menubody = {
	    MENU_IMAGESTRING, "M6", sizeof(m6_items) / sizeof(struct menuitem),
	    m6_items, &m5_menubody, 0};
struct	menu *stack2menutop = &m6_menubody;
int	menutoggle;

main(argc, argv)
	int argc;
	char **argv;
{
	char	*toolname = "Pane Tool 1.1 (A sample tool)";
	struct	toolsw *paneNW, *paneNE, *paneSW, *paneSE;
	extern	struct pixfont *pf_sys;

	/*
	 * Create tool window
	 */
	tool = tool_create(toolname, TOOL_NAMESTRIPE|TOOL_BOUNDARYMGR,
	    (struct rect *) 0, (struct icon *) 0);
	if (tool == (struct tool *)0)
		exit(1);
	/*
	 * Create msg subwindows
	 */
	paneNW = msgsw_createtoolsubwindow(tool, "paneNW",
	    100, 100, "Raw keyboard input", pf_sys);
	paneNE = msgsw_createtoolsubwindow(tool, "paneNE",
	    TOOL_SWEXTENDTOEDGE, 100,
	    "Key input here redirected to NW subwindow", pf_sys);
	paneSW = msgsw_createtoolsubwindow(tool, "paneSW",
	    100, TOOL_SWEXTENDTOEDGE, "Display alternating menu stacks",pf_sys);
	paneSE = msgsw_createtoolsubwindow(tool, "paneSE",
	    TOOL_SWEXTENDTOEDGE, TOOL_SWEXTENDTOEDGE,
	    "Try moving subwindow boundaries", pf_sys);
	if (paneNW == (struct toolsw *)0 || paneSW == (struct toolsw *)0 ||
	    paneNE == (struct toolsw *)0 || paneSE == (struct toolsw *)0)
		exit(1);
	/*
	 * Raw input and flushing
	 */
	{
	struct	inputmask im;
	int	paneNW_selected();

	input_imnull(&im);
	im.im_flags |= IM_UNENCODED;
	win_setinputmask(paneNW->ts_windowfd, &im,  &im, WIN_NULLLINK);
	paneNW->ts_io.tio_selected = paneNW_selected;
	}
	/*
	 * Input redirection
	 */
	{
	struct	inputmask im;

	win_getinputmask(paneNE->ts_windowfd, &im, 0);
	win_setinputmask(paneNE->ts_windowfd, &im,  (struct inputmask *) 0,
	    win_fdtonumber(paneNW->ts_windowfd));
	}
	/*
	 * Multi menu stacks
	 */
	{
	struct	inputmask im;
	int	paneSW_selected();

	input_imnull(&im);
	win_setinputcodebit(&im, MENU_BUT);
	win_setinputmask(paneSW->ts_windowfd, &im,  &im, WIN_NULLLINK);
	paneSW->ts_io.tio_selected = paneSW_selected;
	}
	/*
	 * Install tool in tree of windows
	 */
	signal(SIGWINCH, sigwinchcatcher);
	tool_install(tool);
	/*
	 * Handle input
	 */
	tool_select(tool, 0);
	/*
	 * Cleanup
	 */
	tool_destroy(tool);
	exit(0);
}

paneNW_selected(msgsw, ibits, obits, ebits, timer)
	struct	msgsubwindow *msgsw;
	int	*ibits, *obits, *ebits;
	struct	timeval **timer;
{
	struct	inputevent event;
	int	error;

	*ibits = *obits = *ebits = 0;
	error = input_readevent(msgsw->msg_windowfd, &event);
	if (error < 0) {
		perror("panetool");
		return;
	}
	charbuf[0] = 'c';
	charbuf[1] = ':';
	charbuf[2] = (char) event.ie_code&0X7f;
	charbuf[3] = '\0';
	msgsw_setstring(msgsw, charbuf);
}

paneSW_selected(msgsw, ibits, obits, ebits, timer)
	struct	msgsubwindow *msgsw;
	int	*ibits, *obits, *ebits;
	struct	timeval **timer;
{
	struct	inputevent event;
	int	error;
	extern	struct menuitem *menu_display();

	*ibits = *obits = *ebits = 0;
	error = input_readevent(msgsw->msg_windowfd, &event);
	if (error < 0) {
		perror("panetool");
		return;
	}
	(void) menu_display((menutoggle)? &stack1menutop: &stack2menutop,
	    &event, msgsw->msg_windowfd);
	menutoggle = !menutoggle;
}

static
sigwinchcatcher()
{
	tool_sigwinch(tool);
}

