#ifndef lint 
static	char sccsid[] = "@(#)mousetool.c 1.1 84/04/04 SMI";
#endif

#include <stdio.h>
#include <suntool/tool_hs.h>
#include <suntool/optionsw.h>
#include <suntool/msgsw.h>

extern long			  random();
extern char			*initstate();
extern struct pixfont		*pw_pfsysopen();

/* tool and sunwindows-specific data */
static struct tool				*tool;
static struct toolsw			*msg_tsw, *opt_tsw, *range_tsw;
static struct pixwin			*range_pixwin;
static struct msgsubwindow	*msw;
static caddr_t				  osw, start_item, size_item, srand_item;

static struct typed_pair	  start_label	= { IM_TEXT, "Start" };
static struct typed_pair	  size_label	= { IM_TEXT, "Target Size" };
static char				*size_tags[]	= { "4", "8", "12", "16", "24", "32", 0};
static struct typed_pair	  size_choices	= { IM_TEXTVEC, (caddr_t)size_tags };
static int					  size_values[]	= { 4, 8, 12, 16, 24, 32 };
static struct typed_pair	  srand_label	= { IM_TEXT, "Trial ID" };

static u_int	running = FALSE,
			cur_x, cur_y, size = 16,
			cum_time, errors, trials_done,
			win_width, win_height, width_limit, height_limit;

static char	random_state[256];

static struct timeval	start_time, stop_time;
static struct timezone	trash_zone;

static struct pixfont  *font;

static	start_proc(), sigwinched(), range_selected(), range_sighandler();

main()
{
 
/* create the tool */
	tool = tool_create("Mouse Tool 1.1", TOOL_NAMESTRIPE | TOOL_BOUNDARYMGR,
			   (struct rect *)NULL, (struct icon *)NULL);
	if (tool == (struct tool *)NULL)  lose("Couldn't create tool");
	font = pw_pfsysopen();
	if (font == (struct pixfont *)NULL)  lose("Couldn't get default font");

	/* create and initialize the message subwindow */
	msg_tsw = msgsw_createtoolsubwindow(tool, "", TOOL_SWEXTENDTOEDGE,
			(font->pf_defaultsize.y * 3) / 2, "Click (Start) to begin", font);
	if (msg_tsw == (struct toolsw *)NULL)  lose("Couldn't create message subwindow");
	msw = (struct msgsubwindow *)msg_tsw->ts_data;

	/* create and initialize the option subwindow */
	opt_tsw = optsw_createtoolsubwindow(tool, "", TOOL_SWEXTENDTOEDGE,
			 font->pf_defaultsize.y * 3);
	if (opt_tsw == (struct toolsw *)NULL)  lose("Couldn't create option subwindow");
	init_options();

	/* create and initialize the range subwindow */
	range_tsw = tool_createsubwindow(tool, "",
			TOOL_SWEXTENDTOEDGE, TOOL_SWEXTENDTOEDGE);
	if (range_tsw == (struct toolsw *)NULL)  lose("Couldn't create range subwindow");
	init_range();
	initstate(1, random_state, 256);
	signal(SIGWINCH, sigwinched);

	/* install tool */
	tool_install(tool);
	tool_select(tool, 0);

	/* terminate tool */
	tool_destroy(tool);
	pw_pfsysclose();
	exit(0);
}

lose(str)
char	*str;
{	fprintf(stderr, str); exit(1);
}

static
sigwinched()
{	tool_sigwinch(tool);
}

static
init_options()
{
	struct item_place place;

	osw = opt_tsw->ts_data;
	start_item = optsw_command(osw, &start_label, start_proc);
	if (start_item == NULL)  lose("Couldn't create start item");
	size_item = optsw_enum(osw, &size_label, &size_choices, 0, 3, start_proc);
	if (size_item == NULL)  lose("Couldn't create size item");
	srand_item = optsw_text(osw, &srand_label, "1", 0, (int (*)()) NULL);
	if (srand_item == NULL)  lose("Couldn't create  random initializer item");
	optsw_getplace(osw, srand_item, &place);
	place.rect.r_left = optsw_coltox(osw, 0); place.fixed.x = TRUE;
	place.rect.r_width = optsw_coltox(osw, 60); place.fixed.w = TRUE;
	optsw_setplace(osw, srand_item, &place, FALSE);
}

static
init_range()
{
	struct inputmask  mask;

	range_pixwin = pw_open(range_tsw->ts_windowfd);
	if (range_pixwin == (struct pixwin *)NULL)  lose("Couldn't create range pixwin");
	range_tsw->ts_io.tio_handlesigwinch = range_sighandler;
	range_tsw->ts_io.tio_selected = range_selected;
	input_imnull(&mask);
	win_setinputcodebit(&mask, MS_LEFT );
	win_setinputmask(range_tsw->ts_windowfd, &mask, (struct inputmask *)NULL, WIN_NULLLINK);
}

/* respond to damage to range subwindow */
static
range_sighandler(sw)
caddr_t sw;
{
	struct rect	r;
	int			val;

	win_getsize(range_tsw->ts_windowfd, &r);
	win_width = r.r_width; win_height = r.r_height;
	width_limit = r.r_width - size; height_limit = r.r_height - size;
	pw_damaged(range_pixwin);
	pw_writebackground(range_pixwin, 0, 0, r.r_width, r.r_height, PIX_CLR);
	pw_donedamaged(range_pixwin);
	if (running)  start_proc(osw, start_item);
}

/* get notification from option subwindow */
#define SEED_BUF_SIZE	256
static
start_proc(sw, ip, new_value)
caddr_t	sw;
caddr_t	ip;
int		new_value;
{
	int				seed, val;
	char				buf_data[SEED_BUF_SIZE];
	struct string_buf	buf;

	if (running)  {
		running = FALSE;
	  	msgsw_setstring(msw, "Restarting");
		sleep(2);
	}
	pw_writebackground(range_pixwin, 0, 0, win_width, win_height, PIX_CLR);
	size = size_values[optsw_getvalue(size_item, (caddr_t)&val)];
	width_limit = win_width - size; height_limit = win_height - size;
	buf.limit = SEED_BUF_SIZE; buf.data = buf_data;
	optsw_getvalue(srand_item, (caddr_t)&buf);
	seed = atoi(buf_data);
	initstate(seed, random_state, 256);
	set_target();
}

/* respond to user inputs in target range */
static
range_selected(sw, ibits, obits, ebits, timer)
caddr_t			sw;
int				*ibits, *obits, *ebits;
struct timeval	**timer;
{
	int				x, y;
	struct inputevent	ie;

	if (input_readevent(range_tsw->ts_windowfd, &ie) == -1)  {
		perror("input_readevent failed");
		abort();
	}
	*ibits = *obits = *ebits = 0;
	x = ie.ie_locx; y = ie.ie_locy; stop_time = ie.ie_time;
	if (!running)  {
		cum_time = trials_done = errors = 0;
		running= TRUE;
	} else {
		trials_done += 1;
		if (x < cur_x || y < cur_y ||
		    x >= cur_x + size || y >= cur_y + size)  {
			errors += 1;
		} else {
			if (stop_time.tv_usec < start_time.tv_usec) {
				stop_time.tv_usec += 1000000;
				stop_time.tv_sec -= 1;
			}
			cum_time += stop_time.tv_usec - start_time.tv_usec  +
					    (stop_time.tv_sec - start_time.tv_sec) * 1000000;
		}
	}
	pw_writebackground(range_pixwin, cur_x, cur_y, size, size, PIX_CLR);
	report();
	set_target();
}

static
set_target()
{ 
	cur_x = random() % width_limit;
	cur_y  = random() % height_limit;
	pw_writebackground(range_pixwin, cur_x, cur_y, size, size, PIX_SET);
	gettimeofday(&start_time, &trash_zone);
} 

static
report()
{
	int		good_trials = trials_done - errors;
	double	mean_time;
	char		buf[256];

	if (good_trials == 0) {
		mean_time = 0;
	} else {
		mean_time =  ((float)cum_time / (float)good_trials ) /  1000000;
	}
	sprintf(buf,
		"%d trials; %d errors; mean time: %f sec.",
		trials_done, errors, mean_time);
	msgsw_setstring(msw, buf);
}
