/*	@(#)if_mie.h 1.1 83/11/30 SMI	*/

/*
 * Copyright (c) 1983 by Sun Microsystems, Inc.
 */

/*
 * Register definitions for the Sun Multibus version of the
 * Intel EDLC based Ethernet interface
 */
struct mie_device {
	struct miepg {
		u_short	mp_swab	: 1;	/* 68000 byte order */
		u_short		: 1;	/* unused */
		u_short	mp_p2mem: 1;	/* p2 or onboard memory */
		u_short		: 1;	/* unused */
		u_short	mp_pfnum: 12;	/* page number */
	} mie_pgmap[1024];
	short	mie_prom[32];		/* 32 bytes - low bytes of words */
	/* status word */
	u_char	mie_reset	: 1;	/* board reset */
	u_char	mie_noloop	: 1;	/* loopback disable */
	u_char	mie_ca		: 1;	/* channel attention */
	u_char	mie_ie		: 1;	/* interrupt enable */
	u_char	mie_pie		: 1;	/* parity error enable */
	u_char			: 1;	/* unused */
	u_char	mie_pe		: 1;	/* parity error */
	u_char	mie_intr	: 1;	/* interrupt request */
	u_char			: 2;	/* unused */
	u_char	mie_p2mem	: 1;	/* P2 bus enabled */
	u_char	mie_bigram	: 1;	/* true if 256K rams */
	u_char	mie_mbmhi	: 4;	/* hi bits of mem port */
	u_short			: 16;	/* unused */
	u_char			: 7;	/* unused */
	u_char	mie_peack	: 1;	/* dummy bit for pe ack */
	u_char	mie_pesrc	: 1;	/* source of parity error */
	u_char	mie_pebyte	: 1;	/* which byte caused parity error */
	u_char			: 2;	/* unused */
	u_int	mie_erraddr	: 20;	/* error address */
};
