/*	@(#)kbio.h 1.2 84/04/05 SMI	*/

/*
 * Copyright (c) 1983 by Sun Microsystems, Inc.
 */

/*
 * Keyboard related ioctls
 */

#define	KIOCTRANS	_IOW(k, 0, int)	/* set keyboard translation */
#define	KIOCGTRANS	_IOR(k, 5, int)	/* get keyboard translation */
	/* See sundev/kbd.h for TR_NONE (don't translate) and TR_ASCII
	   (translate to ASCII) */

#define	KIOCTRANSABLE	_IOW(k, 6, int)	/* set keyboard translatability */
#define	KIOCGTRANSABLE	_IOR(k, 7, int)	/* get keyboard translatability */
#define	TR_CANNOT	0	/* Cannot translate keyboard using tables */
#define	TR_CAN		1	/* Can translate keyboard using tables */

struct	kiockey {
	int	kio_tablemask;	/* Translation table (one of: 0, CAPSMASK,
				   SHIFTMASK, CTRLMASK, UPMASK) */
	u_char	kio_station;	/* Physical keyboard key station (0-127) */
	u_char	kio_entry;	/* Translation table station's entry */
	char	kio_string[10];	/* Value for STRING entries (null terminated) */
};
#define	KIOCSETKEY	_IOW(k, 1, struct kiockey)
	/* Set kio_tablemask table's kio_station to kio_entry.
	   Copy kio_string to string table if kio_entry is between
	   STRING and STRING+15.
	   EINVAL is possible if there are invalid arguments. */
#define	KIOCGETKEY	_IOWR(k, 2, struct kiockey)
	/* Get kio_tablemask table's kio_station to kio_entry.
	   Get kio_string from string table if kio_entry is between
	   STRING and STRING+15.
	   EINVAL is possible if there are invalid arguments. */
#ifdef	KERNEL
#define	KIOCSUSECODE	_IOR(k, 3, int (*)())
	/* Set hanlder of untranslated keyboard output. */
#define	KIOCGUSECODE	_IOW(k, 4, int (*)())
	/* Get hanlder of untranslated keyboard output. */
#endif	KERNEL
