#ifndef lint
static char  sccsid[] = "@(#)optiontool.c 1.11 84/02/06  Sun Micro";
#endif

/*
 *    Sun Microsystems Inc.
 */

/*
 *	optiontool:	test optionsw library
 */

#include <stdio.h>
#include <suntool/tool_hs.h>
#include <suntool/optionsw.h>

static struct tool	*tool;
static char		*name = "Option Tool 1.1";
static struct toolsw	*tsw;
static caddr_t		 osw;
static struct	pixwin	 opt_pixwin;

static caddr_t		 items [32];
static struct pixfont	*font;
static struct rect	 r;


static unsigned	dump_glyph[16] = {
			0x00002000, 0x00007000, 0x0000D800, 0x00018C00,
			0x00030600, 0x00060C1F, 0x300C1819, 0x0C183019,
			0x0330701F, 0x00E0C87F, 0x0031847F, 0x029B0261,
			0x07EF6FED, 0x1FE49012, 0x7FF89012, 0xFFF8600C
		};
static mpr_static(dump_pr, 32, 16, 1, dump_glyph);

static struct typed_pair title  =  { IM_TEXT, "Option Subwindow Demo" };
static struct typed_pair confirm_label  =  { IM_TEXT, "Quittable" };
static struct typed_pair quit_label  =  { IM_TEXT, "Quit" };
static struct typed_pair verbose_label  =  { IM_TEXT, "Verbose" };
static struct typed_pair dump_label  =  { IM_GRAPHIC, (caddr_t)&dump_pr};
static struct typed_pair x_label  =  { IM_TEXT, "Flag X" };
static struct typed_pair y_label  =  { IM_TEXT, "Flag Y" };
static struct typed_pair z_label  =  { IM_TEXT, "Flag Z" };
static struct typed_pair t1_label  =  { IM_TEXT, "Type here" };
static struct typed_pair t2_label  =  { IM_TEXT, "Secret" };
static struct typed_pair t3_label  =  { IM_TEXT, "line 1"};
static struct typed_pair t4_label  =  { IM_TEXT, "line 2"};
static struct typed_pair txtcmd_label  =  { IM_TEXT, "Report Text" };

static struct typed_pair enum_label  =  { IM_TEXT, "Choose" };
static char   *choice_values[] = { "Zero", "One", "Many", 0 };
static struct typed_pair enum_choices  =  { IM_TEXTVEC, (caddr_t)choice_values };

static int	n,
		confirmed = FALSE,
		remove_which,
		chooser(),
		confirmer(),
		dumper(),
		quitter(),
		reporter(),
		sigwinched(),
		verbose,
		verboser(),
		texter();

FILE	*sysout = stderr;

int	 removed_items;

main()
{
	struct item_place  p;
/*
 * Create tool window
 */
	tool = tool_create(name, TOOL_NAMESTRIPE, NULL, NULL);
	if (tool == (struct tool *)0)
		exit(1);

/*
 * Create subwindow and fill it out
 */
	tsw = optsw_createtoolsubwindow(tool, "optsw",
		     TOOL_SWEXTENDTOEDGE, TOOL_SWEXTENDTOEDGE);
	if (tsw == (struct toolsw *)0)
		exit(1);
	osw = tsw->ts_data;
	n = 0;
	items[n++] = optsw_label(osw, &title);
	items[n++] = optsw_bool(osw, &confirm_label, FALSE, confirmer);
	items[n++] = optsw_command(osw, &quit_label, quitter);
	items[n++] = optsw_bool(osw, &verbose_label, FALSE, verboser);
	items[n++] = optsw_command(osw, &dump_label, dumper);
	items[n++] = optsw_enum(osw, &enum_label, &enum_choices, 0, 0, chooser);
	items[n++] = optsw_bool(osw, &x_label, TRUE, reporter);
	items[n++] = optsw_bool(osw, &y_label, FALSE, reporter);
	items[n++] = optsw_bool(osw, &z_label, TRUE, reporter);
	items[n++] = optsw_text(osw, &t1_label, "A text parameter", 0, NULL);
	items[n++] = optsw_text(osw, &t2_label, "Shhhhh...", OPT_TEXTMASKED, NULL);
	remove_which = n;
	items[n++] = optsw_text(osw, &t3_label, "", 0, NULL);
	items[n++] = optsw_text(osw, &t4_label, "", 0, NULL);
	items[n++] = optsw_command(osw, &txtcmd_label, texter);

	rect_construct(&p.rect, 128, 12, -1, -1);	/*  pixel positioning */
	p.fixed.x = TRUE; p.fixed.y = TRUE;
	optsw_setplace(osw, items[0], &p, FALSE);

	p.rect.r_left = optsw_coltox(osw, 0);	/*  character positioning */
	p.rect.r_top = -1;
	p.fixed.y = FALSE;
	optsw_setplace(osw, items[1], &p, FALSE);

	removed_items = optsw_removeitems(osw, items[remove_which], 2, FALSE);

/*
 * Install tool in tree of windows
 */
	signal(SIGWINCH, sigwinched);
	tool_install(tool);

/*
 *	main loop
 */
	tool_select(tool, 0);

/*
 * Cleanup
 */
	tool_destroy(tool);
	exit(0);
}

static
sigwinched()
{
	tool_sigwinch(tool);
}

static
confirmer(sw, ip, value)
caddr_t	  sw;
caddr_t	  ip;
int	  value;
{
	int	result;

	confirmed = value;
	if (verbose) {
		printf("Confirmation set to %d\n", confirmed);
	}
}

static
reporter(sw, ip, value)
caddr_t	  sw;
caddr_t	  ip;
int	  value;
{
	int	result;

	int	count;
	count = (int)optsw_getvalue(items[6], &result)  +
		(int)optsw_getvalue(items[7], &result)  +
		(int)optsw_getvalue(items[8], &result);
	if (count == 3) {
		count = 2;
	}
	optsw_setvalue(sw, items[5], count);
}

static
chooser(sw, ip, value)
caddr_t	  sw;
caddr_t	  ip;
int	  value;
{
	int	result;

	if (verbose)  {
		printf("Choice set to %d\n", value);
	}
}

static
dumper(sw, ip)
caddr_t	  sw;
caddr_t	  ip;
{
	int	result;

	if (verbose)  {
		optsw_dumpsw(stdout, sw, TRUE);
	}
}

static
quitter(sw,ip)
caddr_t	  sw;
caddr_t	  ip;
{
	int	result;

	if (verbose)  {
		printf("Quit invoked\n");
	}
	if (!confirmed)  {
		if (verbose)  {
			printf("\tbut not confirmed.\n");
		}
		return;
	}
	tool_done(tool);
}

static char		  buf1[1024];
static char		  buf2[1024];
static struct string_buf  str1 = { 1024, buf1 };
static struct string_buf  str2 = { 1024, buf2 };

static
texter(sw, ip)
caddr_t   sw;
caddr_t	  ip;
{
	int	result;

	if (verbose)  {
		result = optsw_getvalue(items[9], &str1);
		result = optsw_getvalue(items[10], &str2);
		switch (optsw_getvalue(items[5], &result)) {
		  case 0:	printf("Mum's the word.\n");
				break;
		  case 2:	printf("First field: %s\n", buf1);
		  case 1:       printf("Second field: %s\n", buf2);
		}
	}
	if (removed_items != 0)  {
		optsw_restoreitems(osw, items[remove_which],
				   removed_items, TRUE);
		removed_items = 0;
	} else {
		removed_items = optsw_removeitems(osw, items[remove_which],
						  2, TRUE);
	}
}

static
verboser(sw, ip, val)
caddr_t	  sw, val;
caddr_t	  ip;
{
	verbose = (int) val;
}
