/*	@(#)icon.h 1.4 83/08/26 SMI	*/

/*
 * Copyright (c) 1983 by Sun Microsystems, Inc.
 */

/*
 * An icon is a mini graphic (with text) representation of some object.
 * This header file describes the icon structure.
 * The icon image is displayed by (optionally) displaying a background,
 * then the image is copied (if no image then do nothing),
 * then the icon->textrect is blanked out,
 * then the text is formatted into the icon->textrect.
 * The positions in the icon are self-relative, i.e., relocatable.
 * Icon_display takes a position within a pixwin where to place the icon.
 */

struct icon {
	short	ic_width, ic_height;	/* overall icon dimensions */
	struct	pixrect *ic_background;	/* background pattern (mem pixrect) */
	struct	rect ic_gfxrect;	/* where the graphic goes */
	struct	pixrect *ic_mpr;	/* the graphic (a memory pixrect) */
	struct	rect ic_textrect;	/* where text goes */
	char	*ic_text;		/* the text */
	struct	pixfont *ic_font;	/* Font with which to display text */
	int	ic_flags;
#define	ICON_BKGRDPAT	0x02		/* use ic_background to prepare image*/
#define	ICON_BKGRDGRY	0x04		/* use std gray to prepare image*/
#define	ICON_BKGRDCLR	0x08		/* clear to prepare image*/
#define	ICON_BKGRDSET	0x10		/* set to prepare image*/
};

#ifdef	cplus
void	icon_display(struct icon *icon, struct pixwin *pixwin, int x, y);
#endif
