#ifndef lint
static	char sccsid[] = "@(#)clocktool.c 1.18 84/04/05 SMI";
#endif

/*
 * Sun Microsystems, Inc.
 */

/*
 *	Clocktool:	Display time as text when open and icon when closed.
 */

#include <sys/time.h>
#include <sys/types.h>
#include <errno.h>
#include <stdio.h>
#include <signal.h>
#include <pixrect/pixrect.h>
#include <pixrect/pixfont.h>
#include <pixrect/pr_util.h>
#include <pixrect/memvar.h>
#include <sunwindow/rect.h>
#include <sunwindow/rectlist.h>
#include <sunwindow/win_input.h>
#include <sunwindow/pixwin.h>
#include <sunwindow/win_struct.h>
#include <sunwindow/win_environ.h>
#include <suntool/icon.h>
#include <suntool/tool.h>
#include <suntool/msgsw.h>

extern	char *asctime();
extern	int errno;

static	int clock_sigwinchcatcher();

struct	hands	{
	char	/* use char to save data space (biggest value is < 256)	*/
		x1, y1,		/* first origin for this position	*/
		x2, y2,		/*  second origin for this position	*/
		sec_x, sec_y,	/*  second-hand origin for this minute	*/
		min_x, min_y,	/*  end of minute- and second hands	*/
		hour_x, hour_y; /*  end of hour hand			*/
};
#include "clockhands.c"		/* Defines hand_points			*/

#include "clocktool.icon"
mpr_static(base_mpr, 64, 64, 1, icon_data);

static	struct pixrect *ic_mpr;
static	struct icon clockicon = {64, 64, (struct pixrect *)0,
	    {0, 0, 64, 64}, 0,
	    {0, 0, 0, 0}, (char *)0, (struct pixfont *)0, 0};

static	struct tool *tool;
static	struct toolsw *clocksw;
static	int (*tool_cachedhandlesigwinch)();

static	struct tm *tmp;
static	struct timeval	tv;

static	unsigned show_seconds = FALSE;
static	unsigned testing = FALSE;

clocktool_main(argc, argv)
	int argc;
	char **argv;
{
	char	*name = "Clock Tool 1.1";
	struct	inputmask im;
	int	clock_selected(), clock_handlesigwinch();

	/*
	 * Set up clock icon
	 */
	clockicon.ic_mpr = ic_mpr = mem_create(64, 64, 1);
	/*
	 * Create and customize tool
	 */
	tool = tool_create(name, TOOL_NAMESTRIPE, (struct rect *)0, &clockicon);
	if (tool == (struct tool *)0)
		exit(1);
	tool_cachedhandlesigwinch = tool->tl_io.tio_handlesigwinch;
	tool->tl_io.tio_handlesigwinch = clock_handlesigwinch;
	/*
	 * Setup timer
	 */
	clock_resettimer();
	/*
	 * Create and customize msg subwindow
	 */
	clocksw = msgsw_createtoolsubwindow(tool, "clocksw",
	    TOOL_SWEXTENDTOEDGE, TOOL_SWEXTENDTOEDGE,
	    asctime(tmp), pw_pfsysopen());
	if (clocksw == (struct toolsw *)0)
		exit(1);
	clocksw->ts_io.tio_selected = clock_selected;
	clocksw->ts_io.tio_timer = &tv;
	input_imnull(&im);
	im.im_flags |= IM_ASCII;
	win_setinputmask(clocksw->ts_windowfd, &im, (struct inputmask *)0,
	    WIN_NULLLINK);
	/*
	 * Prime the icon
	 */
	clock_painthands();
	/*
	 * Install tool
	 */
	signal(SIGWINCH, clock_sigwinchcatcher);
	tool_install(tool);
	/*
	 * Main loop
	 */
	tool_select(tool, 0);
	/*
	 * Cleanup
	 */
	tool_destroy(tool);
	pr_destroy(ic_mpr);
	exit(0);
}

clock_selected(msgsw, ibits, obits, ebits, timer)
	struct	msgsubwindow *msgsw;
	int	*ibits, *obits, *ebits;
	struct	timeval **timer;
{
	if (*timer && ((*timer)->tv_sec == 0) && ((*timer)->tv_usec == 0)
	    && *ibits == 0) {
		clock_resettimer();
		clock_drawtime();
	}
	if (*ibits & (1 << msgsw->msg_windowfd)) {
		struct inputevent event;

		if (input_readevent(msgsw->msg_windowfd, &event) == -1) {
			perror("clocktool");
			exit(1);
		}
		switch (event.ie_code) {
		  case 's':	/* toggle second */
		  case 'S':	/*    hand	*/
			show_seconds = !show_seconds;
			clock_resettimer();
			break;
		  case 't':	/* toggle testing */
		  case 'T':
			testing = !testing;
			clock_resettimer();
			break;
		  default: {}	/*  ignore the rest */
			/*
			 * Note: Need putback event so can putback and then
			 * call tool_selected right here.
			 */
		}
	}
	*ibits = 0;
	*obits = 0;
	*ebits = 0;
} 

clock_resettimer()
{
	int	clock;

	if (testing) {
		tv.tv_sec = 0;
		tv.tv_usec = 0;
		if (++(tmp->tm_min) == 60) {
			tmp->tm_min = 0;
			if (++(tmp->tm_hour) == 24)
				tmp->tm_hour = 0;
		}
	} else {
		clock = time(0);
		tmp = localtime (&clock);
		tv.tv_usec = 0;
		tv.tv_sec = ((show_seconds) ? 1: 60 - tmp->tm_sec);
	}
}

clock_drawtime()
{
	if (tool->tl_flags & TOOL_ICONIC)  {
		clock_painthands();
		tool_display(tool);
	}  else {
		msgsw_setstring(clocksw->ts_data, asctime(tmp));
	}
}

clock_painthands()
{
	struct hands   *hand;

	pr_rop(ic_mpr, 0, 0, 640, 64, PIX_SRC, &base_mpr, 0, 0);

	hand = &hand_points[(tmp->tm_hour*5 + (tmp->tm_min + 6)/12) % 60];
	pr_vector(ic_mpr,
		  hand->x1, hand->y1,
		  hand->hour_x, hand->hour_y,
		  PIX_SET, 1);
	pr_vector(ic_mpr,
		  hand->x2, hand->y2,
		  hand->hour_x, hand->hour_y,
		  PIX_SET, 1);

	hand = &hand_points[tmp->tm_min];
	pr_vector(ic_mpr,
		  hand->x1, hand->y1,
		  hand->min_x, hand->min_y,
		  PIX_SET, 1);
	pr_vector(ic_mpr,
		  hand->x2, hand->y2,
		  hand->min_x, hand->min_y,
		  PIX_SET, 1);

	if (show_seconds) {
		hand = &hand_points[tmp->tm_sec];
		pr_vector(ic_mpr,
			  hand->sec_x, hand->sec_y,
			  hand->min_x, hand->min_y,
			  PIX_SET, 1);
	}
}

clock_handlesigwinch(tool)
	struct	tool *tool;
{
	/*
	 * Update backing representation of time before let tool
	 * handle sigwinch so that correct time is shown
	 * immediately after changing state.
	 */
	if (tool->tl_flags & TOOL_ICONIC)  {
		/*
		 * May be going normal so update string.
		 */
		((struct msgsubwindow *)clocksw->ts_data)->msg_string =
		    asctime(tmp);
	}  else {
		/*
		 * May be going iconic so update icon.
		 */
		clock_painthands();
	}
	tool_cachedhandlesigwinch(tool);
}

static	int
clock_sigwinchcatcher()
{
	tool_sigwinch(tool);
}

