/*	@(#)clock.h 4.7 83/10/17 SMI	*/

/*
 * Copyright (c) 1983 by Sun Microsystems, Inc.
 */

/*
 * Sun clock registers
 */
#ifdef LOCORE
#define	CLKADDR	0xEE0000
#else
struct clk {
	short	clk_data;	/* data register */
	short	clk_cmd;	/* command register */
};
#define	CLKADDR	((struct clk *)(0xEE0000))
#endif

/*
 * Carefully define the basic CPU clock rate so
 * that time-of-day calculations don't float
 */
#define	CLK_BASIC	19660800

#define	CLK_F1		0xB00 	/* F1 = pulse/1 */
#define	CLK_F2		0xC00	/* F2 = pulse/16 */
#define	CLK_F3		0xD00	/* F3 = pulse/256 */
#define	CLK_F4		0xE00	/* F4 = pulse/4096 */
#define	CLK_F5		0xF00	/* F5 = pulse/65536 */
#define	CLK_F1DIV	1
#define	CLK_F2DIV	16
#define	CLK_F3DIV	256
#define	CLK_F4DIV	4096
#define	CLK_F5DIV	65536
#define	CLK_LMODE	0xFF00	/* Command to load the mode register */
#define	CLK_LLOAD	0xFF08	/* Command to load the load register */
#define	CLK_LHOLD	0xFF10	/* Command to load the hold register */
#define	CLK_TICK_MODE	(CLK_F2+0x22) /* F2 + Operating mode D */
#define	CLK_UART_MODE	(CLK_F1+0x22) /* F1 + Operating mode D */
#define	CLK_HZ(hz)	((CLK_BASIC/(4*CLK_F2DIV))/hz) /* hz to clk conv */	
#define	CLK_GO		0xFF20	/* Command to arm counter 2 */
#define	CLK_REFR	0xFFE2	/* Command to re-enable clock */
#define	CLK_RESET	0xFFFF	/* Command to reset clock */
#define	CLKTIMER	2	/* Timer 2 */

/*
 * Definitions for National Semi MM58167 Time-Of-Year Clock
 * This brain damaged chip insists on keeping the time in
 * MM/DD HH:MM:SS format, even though it doesn't know about
 * leap years and Feb. 29, thus making it nearly worthless.
 * We just treat it as a series of counters which trigger at funny
 * times.  Since the chip thinks all years are the same, we consider
 * all "years" to have SECDAY seconds.  We always load the chip with
 * the UNIX time modulo SECDAY.
 *
 * All counters are in BCD.
 */
#ifndef LOCORE
#define	TODBASE	(struct tod *)0xEE1000
	
#define	SECDAY		(24*60*60)	/* seconds per day */
#define	SECYR		(365*SECDAY)	/* per common year */

struct tod {
	struct {		/* counters */
		u_char	val;
		u_char	: 8;
	} tod_counter[8];
	struct {		/* compare latches - not used */
		u_char	val;
		u_char	: 8;
	} tod_latch[8];
	u_char	tod_isr;	/* interrupt status - not used */
	u_char	: 8;
	u_char	tod_icr;	/* interrupt control - not used */
	u_char	: 8;
	u_char	tod_creset;	/* counter reset mask */
	u_char	: 8;
	u_char	tod_lreset;	/* latch reset mask */
	u_char	: 8;
	u_char	tod_status;	/* bad counter read status */
	u_char	: 8;
	u_char	tod_go;		/* GO - start at integral seconds */
	u_char	: 8;
	u_char	tod_stby;	/* standby mode - not used */
	u_char	: 8;
	u_char	tod_test;	/* test mode - ??? */
	u_char	: 8;
};

/* counters and latches */
#define	TOD_MSEC	0	/* milliseconds * 10 */
#define	TOD_TSEC	1	/* hundredths of seconds */
#define	TOD_SEC		2	/* seconds 0-59 */
#define	TOD_MIN		3	/* minutes 0-59 */
#define	TOD_HOUR	4	/* hours 0-23 */
#define	TOD_WEEKDAY	5	/* weeekday 1-7 */
#define	TOD_DAY		6	/* day-of-month 1-{28,30,31} */
#define	TOD_MONTH	7	/* month 1-12 */
#endif
