| C run time startoff.

	.text
	.globl	_start,_end,_edata

_start:	jra	__st1
	.long	_end+4			| ddt uses this to find symtab
__st1:
	movl	#_edata,a0		| clear bss area
	clrl	d0			|  (why doesnt C startup do this??)
1$:
	movw	d0,a0@+
	cmpl	#_end,a0
	blts	1$
	jsr	asminit

	movl	#_start,sp
	movl	sp,a6
|	jsr	ddtinit
	jsr	main
    	movl	#0,sp@-
	jsr 	exit
    	addql	#4,sp
	jra	_start


|
| which PROMs are we using?
|

prom_ftx=1			| forward tech ft68x board, default proms
breakkey=1			| default proms don't have a break key
prom_ftx_su=0			| ft68x board, stanford proms

|
| low memory globals
|

refvec	=	0x7c		| address of refresh vector, level 7 autovector
refloc	=	0xc0		| location of refresh routine (with prom_ftx)
nop256	=	0x100		| address of nop chain (256 bytes long)
globptr	=	0x200		| start of global data
msclock	=	0x278		| address of refresh counter (in msec)


|
| one time initialization to setup vectors, etc.
|
	.globl	asminit
asminit:
	.if	nz,prom_ftx_su
	rts
	.endc

	.if	nz,prom_ftx		| fix up refresh routine
	movl	#areft,refvec		| hold off refresh for awhile
	movw	anop,d0			| place 127 nops at 0x100
	movl	#nop256,a0
	movl	#127-1,d1
1$:	movw	d0,a0@+
	dbra	d1,1$
	movw	arts,a0@+		| followed by an rts

| copy refresh routine to 0xc0 (refloc)

	movl	#aref,a0
	movl	#refloc,a1
2$:	movw	a0@+,a1@+
	cmpl	#arefe,a0
	blts	2$
	movl	#refloc,refvec		| level 7 autovector is refresh

| stop counter 2 from interrupting at level 6

	movw	#0xFFC2,0x800002	| disarm counter 2
	movw	#0xFFE2,0x800002	| clear output counter 2
	movw	#0xFF02,0x800002	| setup to write counter 2 mode
	movw	#0x0B00,0x800000	| clear counter 2 mode

| setup the memory management to match Stanford's

	movl	#mtab,a0
3$:
	movl	a0@+,d0			| d0=address
	movl	a0@+,d1			| d1=mapvalue
	tstl	d1
	blts	arts			| done
4$:
	movl	d0,d2
	orl	#0xA00000,d2		| address of page map itself
	movl	d2,a1
	movw	d1,a1@			| set the map cell
	addl	#0x800,d0		| bump to next cell and value
	addqw	#1,d1

	cmpl	a0@,d0
	beqs	3$			| if ready for next mtab entry
	bras	4$

arts:	rts

| this routine gets moved down to @refloc (0xc0) and called by level 7 int.

anop:	nop
aref:	movw	#0xFFE3,0x800002	| clear output counter #3 (refresh)
	jsr	0x100			| call nop chain
	addql	#2,msclock		| bump ms clock
	.if	nz,breakkey
	movb	#0x10,0x600002		| reset UART external status latches
	btst	#7,0x600002		| check break status
	beqs	1$			| if not break
	trap	#0
	.endc
1$:	rte
arefe:
areft:	movw	#0xFFE3,0x800002
arte:	rte

| table of memory management settings.  each pair represents the starting
| virtual address and pagemap entry for that group of addresses.

mtab:	.long	0,0			| onboard RAM
	.long	0x40000,0x1000		| 40000-100000 non-existant
	.long	0x100000,0x2000		| 100000-1F0000 multibus mem
	.long	0x1F0000,0x3000		| 1F0000-> multibus IO
	.long	0x1FF800,0x1000		| top page non-existant
	.long	0x200000,-1		| end of table

	.endc


|
| copy bytes, using movb,movw, or movl as appropriate.
|
	.globl	bcopy
bcopy:	movl	sp@(4),d0
	movl	d0,a0
	movl	d0,d1
	movl	sp@(8),d0
	movl	d0,a1
	orl	d0,d1
	movl	sp@(12),d0
	orl	d0,d1
	btst	#0,d1
	beqs	2$
	subql	#1,d0
1$:	movb	a0@+,a1@+
	dbra	d0,1$
	rts

2$:	btst	#1,d0
	beqs	4$
	asrl	#1,d0
	subql	#1,d0
3$:	movw	a0@+,a1@+
	dbra	d0,3$
	rts

4$:	asrl	#2,d0
	subql	#1,d0
5$:	movl	a0@+,a1@+
	dbra	d0,5$
	rts


|
| zero bytes
|
	.globl	bzero
bzero:	movl	sp@(4),a0
	movl	sp@(8),d0
	subql	#1,d0
	moveq	#0,d1
1$:	movb	d1,a0@+
	dbra	d0,1$
	rts


|
| compare bytes
|
	.globl	bcmp
bcmp:	movl	sp@(4),a0
	movl	sp@(8),a1
	movl	sp@(12),d0
	subql	#1,d0
1$:	cmpmb	a0@+,a1@+
	dbne	d0,1$
	bnes	2$
	moveq	#0,d0
	rts
2$:	moveq	#1,d0
	rts


|
| fake out printf [gef]cvt, so all the floating code doesnt come in.
|
	.globl	gcvt,ecvt,fcvt,fltused
gcvt:
ecvt:
fcvt:
fltused:
	rts


|
| Our own console IO.  If we used the library routines they would call an
| EMT (trap) on each byte, locking out ints and taking 10X longer.
| Everything here is polled, but at least these can work in 
| parallel with interrupts if used at backround spl0 level.
|

cons=0x600000	| console A port (data)
cont=2		| control reg offset
consb=cons+4
rdyrx=1
rdytx=4

	.globl	putchar
putchar:
	movl	sp@(4),d0
	cmpb	#0xA,d0		| if newline, do CR first
	bnes	put1
	movb	#0xD,d0
	bsrs	put1
	movb	#0xA,d0
put1:
	movb	cons+cont,d1
	andb	#rdytx,d1
	beqs	put1
	movb	d0,cons
	rts

	.globl	getchar
getchar:
	movb	cons+cont,d0
	andb	#rdyrx,d0
	beqs	getchar
	clrl	d0
	movb	cons,d0
	andb	#0x7F,d0
	bsrs	put1
	rts

	.globl	getchaready,linereadyrx
getchaready:
linereadyrx:
	clrl	d0
	movb	cons+cont,d0
	andb	#rdyrx,d0
	rts

	.globl	exit
exit:	trap	#0

	.globl	emt_getchar,emt_putchar,lineget
emt_getchar=getchar
emt_putchar=putchar
lineget=getchar
