/*
 * Ethernet address - 6 octets
 */
struct ether_addr {
	u_char	ether_addr_octet[6];
};

/*
 * Structure of a 10Mb/s Ethernet header.
 */
struct	ether_header {
	struct	ether_addr ether_dhost;
	struct	ether_addr ether_shost;
	u_short	ether_type;
};

#define	ETHERTYPE_PUPTYPE	0x0200		/* PUP protocol */
#define	ETHERTYPE_IPTYPE	0x0800		/* IP protocol */
#define ETHERTYPE_ARPTYPE	0x0806		/* Addr. resolution protocol*/

#define	ETHERMTU	1500
#define	ETHERMIN	(60-14)
