|
| quick loader.
|
| load format
|
| ^A	XXXX	XXXX	XXXX........	XXXX
| soh	addr	count	data		checksum
|
| ^Z
| eof

cons=0x600000	| console A port (data)
cont=2		| control reg offset
consb=cons+4
rdyrx=1
rdytx=4

	.globl	start
start:
	clrl	d7		| d7 = start address received
scan:
	bsrs	getc
	cmpb	#1,d0		| ^A
	beqs	nextseg
	cmpb	#0x1a,d0	| ^Z
	beqs	done
	tstl	d7
	beqs	scan		| keep scanning if nothing received yet
	bras	badnews		| else trouble
done:
	movb	#0x4f,d0	| print OK and call _start
	bsrs	putc
	movb	#0x4b,d0
	bsrs	putc
	tstl	d7
	beqs	badnews
	movl	d7,a0
	jmp	a0@

nextseg:
	bsrs	getl
	movl	d0,a2		| a2=addr
	tstl	d7
	bnes	1$
	movl	d0,d7		| save start address
1$:
	bsrs	getl
	movl	d0,d6		| d6=count
	clrl	d5		| d5=sum
load:
	tstl	d6
	bles	cksum		| count done
	subql	#1,d6
	bsrs	getc
	movb	d0,a2@+		| store next byte
	addl	d0,d5		| accum sum
	tstb	d6
	bnes	load
	movb	#0x2e,d0	| print '.' every 256 bytes
	bsrs	putc
	bras	load
cksum:
	bsrs	getl
	cmpl	d0,d5
	beqs	scan		| it's good, look for more
badnews:
	movb	#0x21,d0	| print '!' and quit
	bsrs	putc
	bras	.

getc:
	movb	consb+cont,d0
	andb	#rdyrx,d0
	beqs	getc
	clrl	d0
	movb	consb,d0
	rts
putc:
	movb	cons+cont,d1
	andb	#rdytx,d1
	beqs	putc
	movb	d0,cons
	rts
getl:
	bsrs	getc
	movb	d0,d1
	asll	#8,d1
	bsrs	getc
	movb	d0,d1
	asll	#8,d1
	bsrs	getc
	movb	d0,d1
	asll	#8,d1
	bsrs	getc
	movb	d0,d1
	movl	d1,d0
	rts
