/* 
 *  Quick downloader.
 *  Modified to store symbols: V. Pratt, Jan. 1981.
 *  Jan. 1982 - V. Pratt - Modified to load symbol table where the Sun
 *  	bootloader puts it
 *  Jan. 1985 - Croft - 'quick' downloader.
 */

#include "/usr/sun/include/b.out.h"
#include <stdio.h>
#include <sgtty.h>
#include <signal.h>

#define	GOCMD	"g 3ff00\r"	/* cmd to start qload.s */

struct bhdr filhdr;

struct sym68 {			/* fake sym for 68000 */
	short dummy1;		/* ignored */
	char stype;		/* type */
	char slength;		/* length */
	long svalue;
};

FILE *infile, *outfile;
char infilename[30];

struct sgttyb old,new;
int	setllitout	=	LLITOUT;
int	bye();
/* 'qload' program in S format */
char	*ql[] = {
#include "qload.h"
0 };

main(argc,argv)
int argc;
char *argv[];
{
	int     Sa, Daddr=0, i;
	int     sz;
	int     ssize68;
	register char *cp;
	char    stable[8192];	/* enough? */

	argc--;argv++;
	for (i = 0; i < argc; i++) {/* get options */
		if (argv[i][0] != '-') {
			strcpy (infilename, argv[i]);
			continue;
		}
		switch (argv[i][1]) {
			case 'T': 
				if (i++ < argc)
					sscanf (argv[i], "%x", &Daddr);
				break;
		}
	}
 /* open infile */
	if (*infilename == 0 || (infile = fopen (infilename, "r")) == NULL) {
		strcpy (infilename, "b.out");
		if ((infile = fopen (infilename, "r")) == NULL) {
			fprintf (stderr, "dl68: Can't open %s\n", infilename);
			exit (1);
		}
	}
	outfile = stdout;
 /* get header info */
	if (fread (&filhdr, sizeof (struct bhdr), 1, infile) != 1
		|| filhdr.fmagic != FMAGIC) {
		fprintf (stderr, "dl68: %s wrong format\n", infilename);
		exit (1);
	}
	gtty(1, &old);
	new = old;
	new.sg_flags &= ~ECHO;
	if (signal(SIGINT, SIG_IGN) != SIG_IGN)
		signal(SIGINT, bye);
	if (signal(SIGTERM, SIG_IGN) != SIG_IGN)
		signal(SIGTERM, bye);
	stty(1, &new);
	ioctl(1, TIOCLBIS, &setllitout);
	printf("\\");		/* unlocks ROM monitor */
	fflush(stdout);
	sleep(1);
	for (i = 0 ; ql[i] ; i++) {
		fwrite(ql[i], strlen(ql[i]), 1, stdout);
		putchar('\r');
		fflush(stdout);
		sleep(1);
		stty(1, &new);	/* flush input */
	}
	printf(GOCMD);
	fflush(stdout);
	sleep(1);
	stty(1, &new);	/* flush input */
	/* ioctl(1, TIOCFLUSH, 0); */
/* Output records for TEXT portion */
	if (Daddr == 0)
		Daddr = filhdr.entry;
	outbin (infile, Daddr, filhdr.tsize);
	Daddr += filhdr.tsize;	/* adjust output address */
	fseek (infile, DATAPOS, 0);/* seek to DATA portion */
/* Output records for DATA segment */
	outbin (infile, Daddr, filhdr.dsize);
	Daddr += filhdr.dsize;	/* adjust output address */
	fseek (infile, SYMPOS, 0);/* seek to SYM portion */
	if (filhdr.ssize == 0)
		goto quit;
	(char *) rbuild (stable, infile, &sz);
	ssize68 = htonl (sz);
	Daddr += filhdr.bsize;
 /* skip bss (should be 0 really) */
	outbuf (&ssize68,Daddr,4);
	Daddr += 4;
	outbuf (stable, Daddr, sz);
quit: 
	putchar('Z'& 0x1f);	/* send ^Z to terminate qload */
	fflush(stdout);
	sleep(4);
	bye();
}

bye()
{
	ioctl(1, TIOCLBIC, &setllitout);
	stty(1,&old);
	_exit (1);
}

/* Procedure that puts out records from a buffer */
outbuf(buffer,addr,size)
char *buffer;
int addr, size;
{
	register i;
	register sum = 0;

	putchar(1);	/* control-a */
	outl(addr);	outl(size);
	for (i = 0 ; i < size ; i++) {
		int c;
		c = (*buffer++ & 0xFF);
		sum += c;
		putchar(c);
	}
	outl(sum);
}

outbin(file,addr,size)
FILE *file;
int addr, size;
{
	register i;
	register sum = 0;

	putchar(1);	/* control-a */
	outl(addr);	outl(size);
	for (i = 0 ; i < size ; i++) {
		int c;
		c = (fgetc(file) & 0xFF);
		sum += c;
		putchar(c);
	}
	outl(sum);
}
		
outl(i)
{
	int j = htonl(i);

	fwrite((char *)&j, 4, 1, stdout);
}

/* Procedure to convert symbol table to .r format */
rbuild(table,source,size) struct sym68 *table; FILE *source; int *size;
{
	struct sym      s;
	int     symno, chrno;
	char    c;
	struct sym68   *s68 = table;
	int     pos;
	for (pos = 0; pos < filhdr.ssize;) {
		if (!fread (&s, sizeof s, 1, source))
			break;	/* Get symbol descriptor */
		pos += sizeof s;
		s68 = (struct sym68    *) ((int) s68 - 2);/* kludge */
		s68->stype = s.stype;
		s68->slength = s.slength;
		s68->svalue = htonl (s.svalue);
		s68++;
		while (*(char *) s68 = getc (source)) {
			s68 = (struct sym68    *) ((int) s68 + 1);
			pos++;
		}
		s68 = (struct sym68    *) ((int) s68 + strlen (s68) + 1);
		if ((int) s68 & 1) {
			*((char *) s68) = 0;/* clear extra byte */
			s68 = (struct sym68    *) ((int) s68 + 1);
				/* word align */
		}
	}
	*size = (int) s68 - (int) table;
}

