/*	atalku.h	1.1	02/19/85	*/


/*
 * AppleTalk package for UNIX (4.2 BSD);  header file.
 *
 * Packets are enclosed by IP/UDP headers, which are handled by the
 * protocol-translating ethernet appletalk gateway.
 *
 * Copyright (C) 1985, Stanford Univ. SUMEX project.
 * May be used but not sold without permission.
 */

/*
 * history
 * 02/16/85	croft	created.
 */



/*
 * ATP packet buffer.
 */
struct atpbuf {
	char	lapddp[lapSize+ddpSize];/* these headers are odd lengths */
	struct ATP atp;			/* ATP header */
	char	data[atpMaxData];
};


#define	NRES	4		/* number of response structs (powerof 2) */
#define	TRES	30		/* timeout (in seconds) of response structs */


/*
 * ATP response structure.  Each response is cached here for
 * possible retransmission.
 */
struct atpres {
	int	stamp;		/* timestamp */
	short	tid;		/* transaction ID */
	char	buf[atpMaxData*atpMaxNum];
	BDS	bds[atpMaxNum];	/* buffer data structures */
	int	bdslen;		/* number of bds structs active */
};


/*
 * ATP socket.  This structure holds the state information for active
 * transactions.
 */
struct atpsoc {
	int	fd;		/* UNIX file descriptor (socket) */
	struct sockaddr_in lsin; /* local sockaddr/internet */
	struct sockaddr_in fsin; /* foreign    ..  */
	AddrBlock laddr;	/* AppleTalk local address block */
	AddrBlock faddr;	/*    ..     foreign   .. */
	short	tid;		/* transaction id (in host byte order) */
	struct atpres res[NRES];	/* response cache */
	struct atpbuf req;	/* request packet (received) */
	int	reqlen;		/* length of req.data */
	struct DDP reqddp;	/* 'unpacked' ddp header from req */
	/* below are some boolean flags */
	char	bind;		/* bind/socket calls completed on fd */
	char	connect;	/* 'connect' call on fd */
	/* these flags can be set by the user (caller) */
	char	noblock;	/* for non-blocking recv */
	char	oneout;		/* only one outstanding req at a time */
};
