|___________________________________________________________________________
|
| mpp handler  (lap only)
|
| alan oppenheimer and larry kenyon
| march-april, 1984
|
| version 1.0a  as listed for developer's conference, 4/30/84
|
| copyright (c) 1984 apple computer inc.
|
|   apple computer assumes no responsibility for the correct operation of
|   this software.  nor does apple assume responsibility for any errors it
|   may contain, or have any liabilities or obligations arising out of or in
|   connection with the use of this software.
|
| history
| 04/30/84	AO&LK	Released in MPP at 1st developer's conference.
| 07/30/84	croft	Distilled LAP only;  C callable.
| 08/06/84	croft	Parameterize delay loops.
| 08/20/84	croft	Coexist with SUN board software refresh.
|
| Copyright (C) 1984, Stanford SUMEX project; may be
| used but not sold without permission.
|___________________________________________________________________________

	.insrt	"lap.h"
	.insrt	"lapref.s"
	.globl	abstats, abaddr, abbridge, abvalid
	.globl	pq, pfree, p_enq

	.data
abvalid:.byte	0		| ff when node address has been validated
abaddr:	.byte	0		| this node's lap address
abnet:	.byte	0		| this node's network number (N/A)
abbridge:.byte	0		| node address of a bridge

flapadrvalid=abvalid
syslapaddr=abaddr
sysnetnum=abnet
sysabridge=abbridge

abusvars:
	.long	abvars
abvars:	.blkb	abvarsend
abstats:
	.blkb	statslen 	| stats area (must be contig with abvars)

sccdata	=	2		| data offset from ctl
actl	=	0		| scc control and data offsets
bctl	=	1
adata	=	2
bdata	=	3

sccrd:	.long	0x1f6000+actl	| read and write address of scc

maxdefers =	32		| max defers before send routine gives up
maxcollsns =	32		| ibid for collisions
laphiaddr =	0x80		| high bit of my lap address (0x80 if server)

	.text

|
| set/clear priority levels
|
abusvec	=	0x70		| level 4 autovector address
	.macro	_splabus	| disable abus ints
	movw	#0x2400,sr
	.endm
	.macro	_spl0		| allow all ints
	movw	#0x2000,sr
	.endm
	.macro	_splabusm1	| spl to abus level - 1 (allow abus ints)
	movw	#0x2300,sr
	.endm
	.macro	_splimp		| locks all interrupts (except refresh)
	movw	#0x2700,sr
	.endm


|
| Delay loop timers.  The original code released 4/30 had many
| cryptic delay constants sprinkled through it.  I've tried to comment
| these (grep DL) with the real-time interval involved so that moving
| to a different speed processor is easier.  On my 8 MHz SUN board,
| each instruction in a timing loop seems to take about a usec.  Most
| of the delay loops are of the form:  loop: test bit; dbne to loop.
| So the loop count * 2 gives roughly the number of usecs.
|
| Delays were originally set up for a ~6 MHz Macintosh;  the multipliers
| below adjust this for an 8(or ~10) MHz SUN board.
|
DLN=2				| delay numerator
DLD=1				| delay denominator

|
| SCC access recovery delay 6 * PCLK + 200 = 1.7 usec
|
	.macro	_sccDL
	movl	sp@,sp@		| actually 2.7 usec
	.endm


||
|| I N T E R F A C E   T O   C
||

|
| set and restore abus spl level:
|	oldlevel = splabus();
|	...
|	splx(oldlevel);
|

	.globl	splabus,splx,splabusm1,splimp,spl0
splabus:
	movw	sr,d0
	_splabus
	rts
splx:
	movl	sp@(4),d0
	movw	d0,sr
	rts
splabusm1:
	movw	sr,d0
	_splabusm1
	rts
splimp:
	movw	sr,d0
	_splimp
	rts
spl0:
	_spl0
	rts
	
|
| write a packet to abus:
|	status = abuswrite((struct abwds *)&abwds[0]));
|

	.globl	abuswrite
abuswrite:
	movl	sp@(4),a1
	movw	sr,sp@-
	_splabus
	moveml	#0x3030,sp@-	| d2 d3 a2 a3
	movl	abusvars,a2
	movl	a1@(2),a0	| get dest addr in d2
	movb	a0@,d2
	bsr	abwrite
	_ref_on			| make sure it's back on
	moveml	sp@+,#0x0c0c
	movw	sp@+,sr
	rts

|
| applebus interrupt handler.
|

abusintr:
	tstb	abusiip
	beqs	2$
	.word	0x4e4e		| trap to ddt
2$:
	movb	#1,abusiip
	moveml	#0xF0F0,sp@-	| save d0-d3,a0-a3
	movl	sccrd,a0	| {get scc address}
	_ref_off
	_ref_seta1
	movl	abusvars,a2
	btst	#rcabit,a0@
	bnes	20$		| if receive char avail
	_statcount spurcount
	bras	10$
20$:	_statcount intcount
	bsr	recvpkt
10$:	_ref_on
	moveml	sp@+,#0x0F0F
	clrb	abusiip
	rte
abusiip:
	.word	0		| catch recursive interrupts

|
| initialize applebus code.  return abaddr.
|

	.globl	abusinit
abusinit:
	moveml	#0x3030,sp@-	| d2 d3 a2 a3
	movl	abusvars,a2
	movl	#abusintr,abusvec
	.if	nz,refresh
	movl	refvec,refvecsave
	.endc
	jsr	abinit
	moveml	sp@+,#0x0c0c
	clrl	d0
	movb	abaddr,d0	| return hardware node address
	rts
	

||
|| L A P   R O U T I N E S
||

|___________________________________________________________________________
|
| routine:	abuswrite - send a packet on the applebus
|		cdsendenq - see if someone is using the number we want . . .
|
| arguments:	a2 (input)--	local variables ptr
|		d2 (input)--	lap destination address
|		a1 (input)--	wds pointer (first entry must start as follows:
|				.byte destination address 
|				.byte 0
|				.byte level 1 type )
|		d0 (output)	--	status
|		uses: d1-d3,a0,a1,a3
|
| function:	send the next packet in the queue, adhering to
|		applebus link access protocol. this implements the special
|		provisions for csma/ca on applebus.
|
|		here we use a 4 bit global backoff mask to initialize our
|		local backoff mask which can grow to 8 bits due to collisions
|		while trying to send this packet.	the global mask can only
|		change by 1 bit either way per call to this subroutine.
|
|		it would be nice to make this subroutine asynchronous.
|
| note: we could save a bit by keeping defertries, collsntries, and lbackoff
|	in registers . . .
|___________________________________________________________________________

bitcount:
	moveq	#0,d0		| d0 returns bits set in d2, byte 0
	moveq	#7,d1		| loop cnt, bit number

1$:	btst	d1,d2
	beqs	2$
	addqw	#1,d0
2$:	dbra	d1,1$
	subqb	#2,d0		| a useful compare
	rts


cdsendenq:
	st	a2@(fsendenq)	| {flag where we're coming from}
	movb	syslapaddr,d2	| {send to our own address}
	bras	adjbk_1


abwrite:
	clrb	a2@(fsendenq)	| {flag we came here to send data}
	movl	a1,a2@(wdsptr)	| save wdsp

adjbk_1:
	movb	d2,a2@(destnode)	| remember destination node
	movw	a2@(backoff),d3	| {current global backoff mask}
	lea	a2@(collsnhistory),a0
	lea	a2@(deferhistory),a1
	movb	a0@,d2		| for i:=1 to 7 do collsnhistory[i] :=
	addb	d2,a0@		|	collsnhistory[i-1];collsnhistory[0]:=0

	bsrs	bitcount	| if bitcount(collsnhistory) > 2 then begin
	bles	adjbk_2
	addw	d3,d3		|	backoff := min (max( backoff*2, 2), 16)
	bset	#0,d3
	andw	#/000f,d3	|	{note backoff is really a mask . . .}
	clrb	a0@		|	for i:=0 to 7 do collsnhistory[i] := 0
	bras	adjbk_3		| end

adjbk_2:
	movb	a1@,d2		| else
	bsrs	bitcount	| if bitcount(deferhistory) < 2 then begin
	bges	adjbk_3
	lsrw	#1,d3		|	backoff := backoff div 2;
	st	a1@		|	for i:=0 to 7 do deferhistory[i] := 1
				| end;

adjbk_3:movb	a1@,d2		| for i:=1 to 7 do deferhistory[i] :=
	addb	d2,a1@		|	deferhistory[i-1];deferhistory[0]:=0
	movw	d3,a2@(backoff)	| {update global backoff mask}
	movw	d3,a2@(lbackoff)

	clrl	a2@(defertries)	| defertries := 0; collsntries := 0;
	_assumeeq defertries+2,collsntries
	movl	sccrd,a0	| {get scc address}
	_ref_seta1
	_ref_all

|	{wait for any packet in progress}

cds_pktwait:
	_ref_on
|	_spl0			| (mac: spl1)
	btst	#hunt,a0@	| if carriersense then begin
	bnes	cds_bkoff	| (if still hunting, then line idle)
	bset	#0,a2@(lbackoff) |	backoff := max( backoff, 2);
	bset	#0,a2@(deferhistory) |	deferhistory[0] := 1;

	DL4maxpack=45000*DLN/DLD	| about 90 msec = ~4 max packets
	movl	#DL4maxpack,d0	|	{extra long for "in packet" timer}
1$:	btst	#hunt,a0@	|	while carriersense
	dbne	d0,1$		|	do nothing;
	bnes	cds_bkoff	|	{br if we're no longer in a packet}
				| end;

	bsr	resetrcvr	| {reset receiver in case of bizarreness}
	_statcount idletocount

|	{wait for minimum interpacketgap time plus a random backoff}

cds_bkoff:
	bsr	randomword	| figure out a random number
	andw	a2@(lbackoff),d0 | then make it using the local backoff mask
	andw	#/000f,d0	| max out at 4 bits (just like global mask)
	beqs	2$		| br if no random backoff

1$:	bsrs	wait100usec	| call wait routine (which also checks the line)
	dbeq	d0,1$
	beqs	cds_busy	| br if the line is busy . . .

2$:
	_ref_off
|	_splabus		| (mac: spl3)
	moveq	#3,d0		| always wait 4 (*100usec) for idg time
	movb	#14,a0@		| reset missing clocks line going in . . .
	_sccDL
	movb	#resetclks,a0@

3$:	bsrs	wait100usec	| call wait routine (which also checks the line)
	dbeq	d0,3$
	beqs	cds_busy	| br if the line is busy . . .

	movb	#10,a0@		| set up to read missing clock reg
	_sccDL
	movb	a2@(destnode),d2	| figure out destination and delay
	movb	a0@,d1		| missing clock set since clear?
	bpls	csendrts	| br if not

cds_busy:
	_statcount defercount
	addqw	#1,a2@(defertries)
	moveq	#excessdefers,d0	| assume exceeded defer max
	cmpw	#maxdefers,a2@(defertries)
	bge	cdsendxit	| exit if so
	bra	cds_pktwait	| otherwise, try again

wait100usec:
	DL50usec=27		| accurate on my SUN board
	moveq	#1,d1		| 50usec if busy, 100usec if idle
2$:	moveq	#DL50usec,d3
1$:	subql	#1,d3
	bnes	1$
	btst	#hunt,a0@	| are we outside packet?
	dbeq	d1,2$
	rts			| bne for ok

|	{before sending the rts or enq we send out a
|	synchronizing transition on the bus}

csendrts:
	movb	#5,a0@		| address wr5
	_sccDL
	moveq	#qlaprts,d0	| set code for rts (and delay)
	movb	#enbrts,a0@	| enable drivers only

|	{wait at least one bit time}

	tstb	a2@(fsendenq)	| do we really want to send enq?
	beqs	10$		| br if not
	moveq	#qlapenq,d0	| set code for enq then
				| {add check for fadrinuse here . . }

10$:	movb	#5,a0@		| address wr5
	_sccDL
	movb	#distxrts,a0@	| then disable until we really start

	bsr	sendxxx		| go send it
	tstb	a2@(fsendenq)	| did we send an enq?
	bnes	waitack		| then go wait for ack

	cmpb	#/ff,a2@(destnode)	| check if broadcast
	bnes	waitcts		| br if not

|	{for broadcasts, just idle for 200 usec}

	moveq	#1,d0
20$:	bsrs	wait100usec	| call our wait routine (which also checks the line)
	dbeq	d0,20$
	bnes	sendpkt		| no, assume all is ok for us

cds_collision:
|	_spl0			| (mac: spl0)	
	_statcount collsncount	| count collisions
	bset	#0,a2@(collsnhistory)
	movw	a2@(lbackoff),d0
	movw	#/10,cc	| set x-bit
	roxlw	#1,d0
	movw	d0,a2@(lbackoff) | increase local backoff mask to max of 8 bits

	addqw	#1,a2@(collsntries)
	moveq	#excesscollsns,d0	| assume exceeded collision max
	cmpw	#maxcollsns,a2@(collsntries)
	bgts	cdsendxit	| exit if so
	bra	cds_pktwait	| otherwise, try again

|	{wait for cts}

waitcts:
	clrb	a2@(fgoodcts)	| clear flag
	bsrs	getxxx
	tstb	a2@(fgoodcts)	| did we get a good one?
	beqs	cds_collision	| br if not

|	{send data packet}

sendpkt:
	bsr	sendpacket	| so send the data packet

cdsendok:
	moveq	#0,d0		| success!
	_statcount xmitcount	| count of good data packets xmitted

cdsendxit:
	_ref_on
|	_spl0			| (mac: spl0)
	rts			| and return

|	{wait for cts/ack}

waitack:
	bsrs	getxxx
	tstb	a2@(fadrinuse)	| well, have we received anything for this address?
	bnes	cdsendok	| exit if so . . . need to find a new number
	bras	cds_collision	| otherwise, assume collision	. . .

|	getxxx - wait for RCA, then recvpkt

	DL400usec=200*DLN/DLD
getxxx:	movl	#DL400usec,d1	| wait for first byte of message . . .
10$:	_ref_one
	btst	#rcabit,a0@	| but only wait 400 usec
	dbne	d1,10$		|
	beqs	30$		| br if no rca . . . (failure)

	bra	recvpkt		| read the message
				| recvpkt sets a2@(fgoodcts)=ff if a valid cts is
				| received; and fadrinuse if a valid packet
				| was received and fadrvalid=00
30$:	rts


|_______________________________________;
|					;
| routine to generate a random word -	;
|_______________________________________;

randomword:
	moveml	#0x40c0,sp@-	| save d1 a0 a1
	.globl	rand
	jsr	rand
	moveml	sp@+,#0x0302
	rts


|___________________________________________________________________________
|
| routine:	sendpacket, sendxxx subroutines
|
| arguments:	a0 (input)	--	scc control register
|		a2 (input)	--	our variables
|
|		a0-a2 are preserved, a3/d0-d3 are trashed.
|
|	sendxxx:
|
|		d0 (input)	--	lap data packet code (cts, rts, enq, ack)
|		d2 (input)	--	lap dstaddr
|
|
|	sendpacket:
|
|		a2@(wdsptr)	--	write data structure:
|					.word length1
|					.long addr1
|					:
|					.word lengthn
|					.long addrn
|					.word 0
|
| function:	routine to send a packet on the bus.	no carrier sense is
|		done at this level.	there is no status returned (the caller
|		should assume that the packet was sent correctly).
|
|___________________________________________________________________________

shdata:				| config scc to send header
	.byte	5,enbtxrts	| (/6b) enable transmitter, output buffer
	.byte	3,disrx		| (/d0) disable receiver
shlth	=	.-shdata

stdata:				| reconfig scc after sending trailer
	.byte	5,distxrts	| (/e2) turn off drivers
	.byte	14,resetclks	| (/43) reset missing clocks flag
	.byte	3,enbrxslv	| (/dd) enable receiver
stlth	=	.-stdata

|	simple little routine to setup work packet and send it:

sendxxx:
	lea	a2@(packetout),a2	| lap header
	movb	d0,a2@(laptypeos)	| fill in dltyp, dldst
	movb	d2,a2@(dstadros)
	moveq	#3,d2		| flag sendxxx (and set byte count)
	bras	send_enb

sendpacket:
	moveq	#0,d2		| flag sendpacket
	movl	a2@(wdsptr),a2	| lap header + data (see structure note)

send_enb:
	lea	shdata,a3
	moveq	#shlth,d3
	bsr	writescc	| disablerx; enabletxdrivers; enabletx;

	DL2flags=16*DLN/DLD	| (was 16) one abus byte SHOULD=35usec
	moveq	#DL2flags,d0	| { empirically determined delay count }
send_flg:
	dbra	d0,send_flg	| { output at least 2 flags }

	movl	a2,a3
	movb	#restxcrc,a0@	| (/80) reset xmit crc
	movw	d2,d3		| lap only packet?
	bnes	send_1st	| skip if so

	movw	a2@+,d3		| d3 = length of first part to write
	movl	a2@+,a3		| a3 = addr of first part to write

send_1st:
	movb	a3@+,a0@(sccdata)	| send the first byte
	subqw	#1,d3		| decrement count (one extra for loop)
	movb	syslapaddr,a3@	| 2nd byte is always our node address

|	write out the next part

send_dta:
	DLtxunder=40*DLN/DLD	| tx underrun if not ready in 60 usec
	moveq	#DLtxunder,d0	| timeout just in case . . .
10$:	btst	#txemptybit,a0@	| transmitter buffer empty?
	dbne	d0,10$
	bnes	20$		| if txemptybit set
	_statcount xundcount
	bras	send_to

20$:	movb	a3@+,a0@(sccdata)	| move the next byte of this part
	_ref_some
	subqw	#1,d3
	bgts	send_dta	| do all the bytes in this part

	tstw	d2		| special packet?
	bnes	send_crc	| br if so
	movw	a2@+,d3		| pick up count of the next part
	beqs	send_crc	| if zero, we've sent all of it
	movl	a2@+,a3		| pick up address of next part
	bras	send_dta	| go write it out

|	send crc and finish up

send_crc:
	movb	#resetund,a0@	| (/c0) reset underrun flag
	_sccDL

10$:	btst	#undrunbit,a0@	| wait for eom (underrun)
	beqs	10$

20$:	btst	#txemptybit,a0@	| wait for crc to be sent
	beqs	20$

	movb	#5,a0@		| disable xmitter, leave on drivers
	_sccDL
	DLabort=53*DLN/DLD	| abus byte=35usec, about 1.5 - 2 bytes
	movl	#DLabort,d0	| delay count
	movb	#enbrts,a0@	| (/62) actually do the disable

send_abort:
	dbra	d0,send_abort	| delay for trailer (min 12, max 18 abort bits)

send_to:
	movb	#addrreg,a0@	| config our port address here
	lea	stdata,a3	| turn off drivers,
	moveq	#stlth,d3	|	re-enable receiver
	movb	syslapaddr,a0@	| just for dynamic capability
	movl	abusvars,a2	| restore a2, fall thru to writescc

|	writescc - write out data (as indicated by a3 and d3) to the scc

writescc:
	movb	a3@+,a0@
	_sccDL
	subqw	#1,d3
	bnes	writescc
	rts


|___________________________________________________________________________
|
| routine:	rinthnd, recvpkt
|
| arguments:	a0 (input)	--	scc control address
|
| function:	this routine doubles as the receive interrupt handler and
|		as the routine used to read in cts and ack responses to rts
|		and cts packets.  this routine is written to handle the arrival
|		of any type packet regardless of whether it was called by the
|		interrupt handler or internally by getxxx.	this routine
|		executes differently based upon the laptype field of the
|		incoming packet, whether this node has aquired a lap node
|		address yet (flapadrvalid=0 if not), and whether any errors are
|		detected in the incoming packet.
|
|		if flapadrvalid=0 and laptype<>ff 
|		then {set fadrinuse flag and exit}
|
|		else case laptype of
|
|		lapdataframe:
|			{dispatch to appropriate protocol handler which
|			should read in the rest of the packet thru calls
|			to readpacket and readrest. note that no protocol
|			handlers would be installed if flapadrvalid=0,
|			so check is made only if no handler is found}
|
|		lapenqframe:
|			{send ack to defend this node's address}
|
|		laprtsframe:
|			{if dstaddr<>ff send cts to srcaddr; wait for
|			receive char available, then loop back to receive
|			the frame - which should usually be a lapdataframe}
|
|		lapackframe:
|			{just exit - initial check will set fadrinuse if
|			appropriate}
|
|		lapctsframe:
|			{set fgoodcts and exit}
|
|		end; {case}
|
|___________________________________________________________________________

recvpkt:
	lea	a2@(torha),a3	| keep a copy in memory (in rha)
	movb	a0@(sccdata),a3@+ | byte 1 of packet - dstaddr
	DL2bytes=60*DLN/DLD
	movl	#DL2bytes,d1	| timeout (for 2 bytes)
10$:	btst	#rcabit,a0@	| wait for next byte
	dbne	d1,10$		| (or timeout)
	beq	pktinto		| br if timeout
	movb	a0@(sccdata),a3@+	| byte 2 of packet - srcaddr

20$:	btst	#rcabit,a0@	| wait for next byte
	dbne	d1,20$		| (or timeout)
	beq	pktinto		| br if timeout
	movb	a0@(sccdata),d0
	movb	d0,a3@+		| byte 3 of packet - laptype
	bmi	lapin		| neg codes are for lap control packets

| it's a data packet and we don't have much time

datain:	
|	moveq	#<laptblsz-1>,d2	| index into active protocols list
|30$:	cmpb	protocols(a2,d2),d0 | match?
|	dbeq	d2,30$
|	bnes	badpktin	| no protocol handler (bad packet most likely)
|	lslw	#2,d2		| make d2 a longword index into handlers

|___________________________________________________________________________
|
|	at this point, handlers(a2,d2) points to the address of the protocol
|	handler for this packet's protocol. jmp to it with the following:
|
|	a0 = scc address
|	a2 = ptr to driver locals
|	a3 = ptr into the header buffer (first three bytes loaded)
|	a4 = the address of our read packet routine
|	a5 saved for handler's usage (until packet's all in or error)
|
|	the protocol handler must obey the following conventions:
|
|	1) it must preserve, across the call, a0-a2, a4
|	2) a6 and d4-d7 must be saved and restored if used.
|	3) it must jsr to the routine at a4@ or a4@(2) with registers as defined below,
|	for the purpose of reading more of the packet and eventually resetting
|	the scc for the next interrupt. this must be done within approximately
|	50 usecs.
|___________________________________________________________________________

|	moveml	#A4+A5,a2@(savea45)	| preserve a4 and a5 locally
|	movl	handlers(a2,d2),a5	| protocol handler address
|	lea	readpacket,a4	| a4 -> read packet routine
|	jmp	a5@		| call the handler

|
| The handler below is the one wired in for our C usage.  Store
| the packet in the next available pbufr.
|
	.globl	pbntypes,pbnfree,pbndrops,ifab
	_splimp			| lock buffer manipulation
	movl	pfree,a3
	cmpw	#0,a3
	bnes	20$		| if buffer avail
	addw	#1,pbndrops
	_splabus
	bra	badpktin	| flush it
20$:	movl	a3@,pfree	| take buf from free list
	subw	#1,pbnfree
| WARNING: these offsets must agree with pbuf.h
p_off=4
p_len=8
p_type=10
p_head=12
pt_abus=1
p_data=140
	addw	#1,pbntypes+[pt_abus*2]	| bump packet usage counter
	_splabus		| done with free queue, lower priority
	movl	a3,sp@-		| save header address
	addl	#p_data,a3	| point to data
	movl	a2@(torha),a3@	| re-store dst/src/type
	addql	#3,a3
	movl	#608,d3		| 3 + 600 + 2 + slop
	bsr	readrest	| read rest of packet
	orw	d3,d0		| d0 = error | overrun status
	movl	a3,d1		| final buf address
	movl	sp@+,a3		| buf header pntr
	subl	a3,d1
	subl	#p_data,d1	| d1 = actual count
	subql	#1,d1		| don't include crc byte
	tstw	d0
	bges	30$		| if no errors or overruns
	moveq	#-1,d1		| set count negative
30$:
	movw	d1,a3@(p_len)	| set count, type, off, in pbuf header
	movw	#pt_abus,a3@(p_type)
	movl	a3,a3@(p_off)
	addl	#p_data,a3@(p_off)
	movl	#ifab,a3@(p_head)	| set interface pointer
| append to main packet queue
	_splimp
	movl	a3,sp@-
	movl	#pq,sp@-
	jsr	p_enq
	addql	#8,sp
	_splabus
	rts


|_______________________________________;
|					;
| we come here if it's a lap control	;
|	packet (rts, enq, ack, cts)	;
|_______________________________________;

	_assumeeq	lapcts,/85
	_assumeeq	laprts,/84
	_assumeeq	lapack,/82
	_assumeeq	lapenq,/81

lapin:	moveq	#127,d2
	andb	d0,d2		| strip off sign bit and save in d2
	cmpb	#[lapcts-/80],d2	| make sure it's a valid lap type
	bgts	badpktin	| skip it if not

	bsr	readcrc		| get the crc
	bnes	rintexit	| br if overrun, bad crc

	cmpb	#/ff,a2@(torha+dstadros) | check if it's a broadcast
	seq	d1		| save info for later
	beqs	10$		| and br if so

	tstb	flapadrvalid	| have we configured our address yet?
	bnes	10$		| br if so
	st	a2@(fadrinuse)	| otherwise, some other node must have it
	bras	20$		| (we got a valid, non-broadcast lap packet)

10$:	subqb	#1,d2		| was it an enq/rts?
	beqs	enqin		| br if enq
	subqb	#3,d2
	beqs	rtsin		| br if rts
	subqb	#1,d2
	seq	a2@(fgoodcts)	| set flag if good cts received (shouldn't have
				|	to worry about getting a broadcast cts)
20$:	rts			| rts to getxxx (probably)

badpktin:
	_statcount badcount	| count bad packets
	bras	skippktin	|

pktinto:
	_statcount rundcount	| count underruns

scinthnd:			| special condition interrupt handler, too
skippktin:
	bsrs	resetrcvr	| reset receiver for next packet (twice)
	moveq	#-1,d0		| note error in case called from getxxx
resetrcvr:
	movb	#reseterr,a0@	| (/30) reset errors
	_sccDL
	movb	#reenbint,a0@	| (/20) re-enable 1st character interrupts
	_sccDL
	movb	#3,a0@
	_sccDL
	movb	#disrx,a0@	| disable/enable rx (reenters hunt)
	_sccDL
	movb	#3,a0@
	_sccDL
	movb	#enbrxslv,a0@
	tstw	d0		| set ccr to d0
rintexit:
	rts

rtsin:	tstb	d1		| check if it's a broadcast
	bnes	10$		| if so, don't send cts

	moveq	#qlapcts,d0	| set code to send cts
	bsrs	tosendxxx	| share some code with enqin

|	ok, we might as well wait for the data . . .

10$:	movl	#DL400usec,d0	| better get here in 400 usec
20$:	_ref_one
	btst	#rcabit,a0@	| wait for first byte of message . . .
	dbne	d0,20$		|
	bne	recvpkt		| br if rca . . .
	_statcount nodtacount	| count no data after cts-rts
	bras	rintexit	| otherwise, give up . . .

enqin:	tstb	d1		| broadcast enq? (shouldn't really get)
	bnes	rintexit	| just exit if so (really a bad packet)
	moveq	#qlapack,d0	| set code to send ack

tosendxxx:
	movb	a2@(torha+srcadros),d2
	bsr	sendxxx		| now send out an ack
	rts			| and exit

|___________________________________________________________________________
|
|	readpacket - read in the specified number of bytes into the specified
|	buffer. end-of-frame is an error.
|
|	readrest - read in the rest of the packet, putting the specified number
|	of bytes into the specified buffer, and ignoring the rest.
|
|	call:
|	a0 = control address
|	a2 -> local variables
|	a3 -> buffer to read into
|	a4 -> start of readpacket
|	d3 = byte count to read (word)
|
|	return:
|	d0 = error byte (z bit set in ccr)
|	d1 modified
|	d2 saved (until packet's all in or error)
|	d3	= 0 if exact number of bytes requested were read
|	> 0 indicates number of bytes requested but not read
|		(packet smaller than requested maximum)
|	< 0 indicates number of extra bytes read but not returned
|		(packet larger than requested maximum)
|	a3 -> one past where last character went
|	a4,a5 saved (until packet's all in or error)
|
| note: crc bytes not included in count (in buffer, however)
|___________________________________________________________________________

| readpacket and readrest are implemented as two separate routines so that
| readpacket can be as fast as possible.

readcrc:
	moveq	#0,d3		| read nothing (no buffer)
	bras	rdpkcom

readpacket:
	bras	dorp		| need this for two entry points

readrest:
	bset	#31,d3		| indicate not from readcrc
rdpkcom:
	DL1byte=30*DLN/DLD
	moveq	#DL1byte,d1	| char timeout
10$:	btst	#rcabit,a0@	| next byte in?
	bnes	20$		| br to handle the character
	dbra	d1,10$		| else, wait for rca
	_statcount rundcount	| count number of underruns
	moveq	#underrunerr,d0
	bras	rdpktexit

|	character is in fifo, check if its end, or what

20$:	movb	#1,a0@		| set to read rr1
	_sccDL
	moveq	#checkbits-256,d0	| delay, setup error bits
	andb	a0@,d0		| see if end-of-frame or overrun
	bnes	30$		| branch if so
	movb	a0@(sccdata),d0	| grab the data
	_ref_some
	subqw	#1,d3		| any more bytes being accepted?
	bmis	rdpkcom		| br if not
	movb	d0,a3@+		| store it away
	bras	rdpkcom		| and keep going
30$:
	movb	#1,a0@		| re-read the error register
	_sccDL
	movb	a0@,d1		| d1 = error byte
	bmis	endframe	| branch if end of frame
	_statcount ovrcount	| must be overrun
	moveq	#overrunerr,d0
rdpktexit:
	tstl	d3		| did we come from readcrc?
	bpls	rd5		| branch if so
rdrestore:
|	moveml	a2@(savea45),#A4+A5 | restore a4 and a5

	tstw	d0		| errors?
	bnes	rd5		| br if so
	_statcount rcvcount	| count number of data packets received

rd5:	bra	resetrcvr	| reset receiver and return (sets z bit)

|	we got the end of frame - d1 contains error bits

endframe:
	addqw	#1,d3		| adjust count for crc byte
	moveq	#0,d0		| assume success
	andb	#ovrorcrc,d1	| check for overrun or crc
	beqs	10$		| branch if not
	_statcount crccount	| count number of crc errors
	moveq	#crcerr,d0	| note the error otherwise
10$:	bras	rdpktexit	| that's it

|	this is the readpacket code (d0 = error bits on overrun or eofr)

dorp:	moveq	#DL1byte,d1	| set timeout value
10$:	btst	#rcabit,a0@	| check for rca
	bnes	20$		| branch if got it
	dbra	d1,10$		| keep checking
	_statcount rundcount	| count number of underruns
	moveq	#underrunerr,d0	| set underrun error code
	bras	rdrestore	| restore registers and return

20$:	movb	#1,a0@		| setup to read rr1
	_sccDL
	moveq	#checkbits-256,d0	| delay, setup error bits
	andb	a0@,d0		| check error bits
	bnes	rdrestore	| branch on error (return error bits)
	movb	a0@(sccdata),a3@+	| move data to buffer
	_ref_some
	subqw	#1,d3		| decrement count
	bnes	dorp		| do more if any left
	rts			| otherwise return (z bit set)

|_______________________________________;
|
| aquireaddr is used to auto-allocate a
| node number at system start time . . .
|_______________________________________;

maxtries	=	20	| {for nodes with non-stick nums}

aquireaddr:
	movw	#maxtries,a2@(aqtries) | {init try count}
|	movw	pramword,d0	| {use pram value as a hint}
|	bgts	aqloop_2	| {but only if it's not 0 or neg}

aqloop_1:
	bsr	randomword	| {otherwise take a random guess}
aqloop_2:
	andw	#/007f,d0
	beqs	aqloop_1	| {no zeroes}

	orw	#laphiaddr,d0	| set high bit if server
	movw	d0,flapadrvalid	| syslapaddr := myaddress; flapadrvalid := 0;

aqloop_3:
	clrb	a2@(fadrinuse)	| {clear in-use flag}
	bsr	cdsendenq	| if send(syslapaddr,syslapaddr,lapenq,0) = sendacked
	tstb	a2@(fadrinuse)
	bnes	aqloop_1	|	then goto {try another number}

	subqw	#1,a2@(aqtries)	| {try a number of times}
	bgts	aqloop_3

|	now that we have a number, remember it for next time

|	movw	pramcopy,pramword	| {note: high byte=0 for abus}
	st	flapadrvalid	| {set driver internal validity flag}
	rts

	_assumeeq	syslapaddr,flapadrvalid+1


abinit:
	movw	sr,sp@-		| save current interrupt priority
	_splabus

|	setup scc for applebus and get dynamic node id

	lea	opentbl,a0	| configure the scc for applebus . . .
	bsrs	sccconfig	| set up with node number 0 initially
	bsr	aquireaddr	| then go through configure routine
	movw	sp@+,sr		| reenable interrupts
	rts


|___________________________________________________________________________
|
| sccconfig:
|
| this routine is used to configure scc operation at open time.	note that
| scc access timing is restricted by the reset command given at the beginning.
|___________________________________________________________________________

sccconfig:
	movl	sccrd,a3	| point to scc port a registers
	movb	a3@,d0		| ensure we're synced up

1$:	movw	a0@+,d0		| get next register number / control word
	beqs	9$		| zero is terminator
	movb	d0,a3@		| put out register number
	_sccDL
	rorw	#8,d0		| pickup control word
	movb	d0,a3@		| set to scc
	bras	1$		| and keep going

9$:	rts			| return

|	scc initialization table
|	entry format: .byte control-value, control-reg-number

opentbl:	
	.byte	reseta,9	| (/80) reset port a
	.byte	sdlcmode,4	| (/20) sdlc mode
	.byte	setfm0,10	| (/e0) set fm0, preset crc
	.byte	/00,addrreg	| (/00) address (set to 0 initially)
	.byte	sdlc,7		| (/7e) sdlc flag byte
	.byte	clocks,11	| (/70) dpll receive, baud rate gen xmit
	.byte	baudrate,bdratelo | (/06) baud rate generator value
	.byte	0,bdratehi	| (/00)
	.byte	fmmode,14	| (/c0) set fm mode
	.byte	srchmode,14	| (/23) start pll, set brg src (brg enabled)
	.byte	enbrxslv,3	| (/dd) enable receiver, address match mode
	.byte	distxrts,5	| (/60) disable transmitter
	.byte	/00,2		| (/00) set zeros in interrupt vector
|	.byte	dcdie,15	| (/08) enable dcd interrupts (for mouse)
	.byte	0,15		| (/00) no external interrupts
|	.byte	rxie+extie,1	| (/09) interrupt on first char and dcd
	.byte	rxie,1		| (/08) interrupt on first char 
	.byte	mie,9		| (/0a) master interrupt enable
	.word	0		|	*** end of table ***


|
| sccdump.  dumps scc regs to 'sccregs'.  was used during debugging.
|
	.globl	sccdump
sccdump:
	movl	#sccregs,a3
1$:	tstb	a3@
	blts	3$
	movb	a3@+,a0@
	_sccDL
	movb	a0@,a3@+
	bras	1$
3$:
	addql	#1,a3
	movb	a0@(sccdata),d0
	movb	d0,a3@
|	cmpb	#0xFF,d0
|	beqs	4$
	_ref_on
	.word	0x4e4e		| take that!  (calls ddt)
4$:	rts

	.globl	sccregs
sccregs:
	.byte	0,0
	.byte	1,0
	.byte	3,0
	.byte	10,0
	.byte	0xFF,0
